/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.InvalidCollectionIDException;
import com.sun.portal.rewriter.rom.Rule;
import com.sun.portal.rewriter.rom.RuleCollection;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.collections.ListSet;
import com.sun.portal.rewriter.util.xml.Node;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;

public final class DataRuleCollection
extends RuleCollection {
    private List collection = new ListSet();
    static /* synthetic */ Class class$com$sun$portal$rewriter$util$xml$Node;

    private DataRuleCollection(String aCollectionID) {
        super(aCollectionID);
    }

    public DataRuleCollection(String aCollectionID, DataRule[] aDataRuleArray) {
        this(aCollectionID);
        this.add(aDataRuleArray);
        this.collection = Collections.unmodifiableList(this.collection);
    }

    private boolean add(DataRule aDataRule) throws InvalidCollectionIDException {
        if (aDataRule == null) {
            return false;
        }
        if (this.getCollectionID().equals(aDataRule.getCollectionID())) {
            if (aDataRule.isValid()) {
                return this.collection.add(aDataRule);
            }
            if (Debug.isWarningEnabled()) {
                Debug.recordRuleSetWarning("Ignoring the Invalid Rule: " + aDataRule.toXML());
            }
            return false;
        }
        throw new InvalidCollectionIDException("Error: Collection ID Expected '" + this.getCollectionID() + "' and not of type '" + aDataRule.getCollectionID() + "'");
    }

    public List getCollection() {
        return this.collection;
    }

    private boolean add(DataRule[] aDataRuleArray) throws InvalidCollectionIDException {
        boolean lBool = true;
        if (aDataRuleArray == null) {
            return false;
        }
        int i = 0;
        while (i < aDataRuleArray.length) {
            try {
                this.add(aDataRuleArray[i]);
            }
            catch (InvalidCollectionIDException e) {
                lBool = false;
                Debug.warning("Invalid Collection ID", e);
            }
            ++i;
        }
        return lBool;
    }

    public DataRule findMatch(Data aObject) {
        if (null == aObject || this.collection.size() <= 0) {
            return null;
        }
        int collectionLength = this.collection.size();
        int i = 0;
        while (i < collectionLength) {
            DataRule lRule = (DataRule)this.collection.get(i);
            if (lRule.matches(aObject)) {
                if (Debug.isMessageEnabled()) {
                    Debug.message("\nMatch Happend : \nRule Object:" + lRule.toXML() + "\nContent Object: " + aObject.toXML());
                }
                return lRule;
            }
            ++i;
        }
        return null;
    }

    public final int size() {
        return this.collection.size();
    }

    public boolean contains(Data aObject) {
        return this.findMatch(aObject) != null;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.collection.size()) {
            Rule lValue = (Rule)this.collection.get(i);
            sb.append(lValue.toXML());
            ++i;
        }
        return sb.toString();
    }

    public static DataRuleCollection create(Class aClassRef, Node[] lArray) {
        DataRuleCollection lCollection = null;
        try {
            Constructor constructor = aClassRef.getConstructor(class$com$sun$portal$rewriter$util$xml$Node == null ? (class$com$sun$portal$rewriter$util$xml$Node = DataRuleCollection.class$("com.sun.portal.rewriter.util.xml.Node")) : class$com$sun$portal$rewriter$util$xml$Node);
            DataRule lDataRule = (DataRule)constructor.newInstance(new Node(null));
            lCollection = new DataRuleCollection(lDataRule.getCollectionID());
            int i = 0;
            while (i < lArray.length) {
                try {
                    lDataRule = (DataRule)constructor.newInstance(lArray[i]);
                    lCollection.add(lDataRule);
                }
                catch (Exception e) {
                    Debug.error("Exception in create of DataRuleCollection:", e);
                }
                ++i;
            }
        }
        catch (Exception me) {
            me.printStackTrace();
        }
        return lCollection;
    }

    public static void main(String[] args) {
        DataRule[] attributes = SampleRuleObjects.defaultHTMLAttributes;
        DataRuleCollection lCollection = new DataRuleCollection("Attribute", attributes);
        Debug.println("DataRuleCollection : " + lCollection.contains(attributes[0].getData()));
        Debug.println("DataRuleCollection : " + lCollection.contains(null));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

