/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.portletwindow;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.WindowState;
import com.sun.portal.container.impl.ContainerRequestImpl;
import com.sun.portal.container.impl.ContainerResponseImpl;
import com.sun.portal.container.impl.ExecuteActionRequestImpl;
import com.sun.portal.container.impl.ExecuteActionResponseImpl;
import com.sun.portal.container.impl.GetMarkupRequestImpl;
import com.sun.portal.container.impl.GetMarkupResponseImpl;
import com.sun.portal.desktop.DesktopRequest;
import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.desktop.ServletConfigThreadLocalizer;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.jsp.JSPProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortletWindowProvider
extends JSPProvider {
    private Container container = null;
    private ServletContext SCtx = null;
    private String title = "";
    private static HashMap windowStateMap = new HashMap();
    private static HashMap reverseMap = new HashMap();
    private static List portalParamKeyList = new ArrayList();
    private static List channelModeVE = new ArrayList();
    private static List channelModeH = new ArrayList();
    private static List windowStateMN = new ArrayList();
    private static final String KEYWORD_PREFIX = "javax.portlet.portletc.";
    private static final String RENDER_PARAM_PREFIX = "javax.portlet.portletc.renderParams.";
    private static final String PARAM_DELIMITER = "|";
    private static final String KEY_DELIMITER = "=";
    private static final String ARRAY_DELIMITER = ";";
    private static final String TARGET_SUFFIX = ".isTarget";
    private static final String MODE_SUFFIX = ".previousMode";
    private static final String STATE_SUFFIX = ".previousState";
    private static final String PROCESS_CHANNEL = "PortletWindowProcessChannel";
    public static final String PORTLET_CONTAINER = "portlet_container";
    public static final String RENDER = "RENDER";
    public static final String PROVIDER_CONTEXT = "provider_context";
    public static final String SSO_TOKEN = "sso_token";

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.SCtx = ServletConfigThreadLocalizer.get().getServletContext();
        this.container = (Container)this.SCtx.getAttribute(PORTLET_CONTAINER);
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        ContainerProviderContext cpc = (ContainerProviderContext)pc;
        boolean authless = pc.isAuthless(req);
        String portletentityId = this.getEntityID();
        Map renderParams = this.getRenderParams(portletentityId, authless);
        boolean isTarget = this.getIsTarget(portletentityId, authless);
        this.setIsTarget(portletentityId, authless, false);
        String mode = req.getParameter("javax.portlet.portletc.Mode");
        if (mode != null && mode.equals("HELP")) {
            String parent = req.getParameter("containerName");
            ContainerProvider parentcp = null;
            if (parent != null && parent.length() != 0) {
                parentcp = (ContainerProvider)((Object)cpc.getProvider(req, null, parent));
            }
            List allowableWindowState = parentcp == null ? windowStateMN : this.getWindowStateList(parentcp.getSupportedWindowStates());
            GetMarkupRequestImpl creq = (GetMarkupRequestImpl)this.assembleContainerRequest(req, parent, portletentityId, ChannelMode.HELP, WindowState.NORMAL, allowableWindowState, channelModeH, true);
            creq.setRenderParameters(renderParams);
            creq.setIsTarget(isTarget);
            GetMarkupResponseImpl cres = (GetMarkupResponseImpl)this.assembleContainerResponse(res, true);
            try {
                this.container.getMarkup((GetMarkupRequest)creq, (GetMarkupResponse)cres);
            }
            catch (ContainerException ce) {
                throw new ProviderException("PortletWindowProvider.getContent():container exception", ce);
            }
            catch (ContentException cte) {
                throw new ProviderException("PortletWindowProvider.getContent():An exception occured when trying to get content for portlet " + this.getName(), cte);
            }
            this.title = cres.getTitle();
            StringBuffer helpContent = cres.getMarkup();
            if (helpContent == null) {
                pc.debugError("PortletWindowProvider.getContent(): help content from cres is null for channel:" + this.getName());
            }
            req.setAttribute("helpContent", (Object)helpContent);
            return super.getContent(req, res);
        }
        String parent = pc.getParentContainerName(this.getName());
        ContainerProvider parentcp = null;
        WindowState windowState = WindowState.NORMAL;
        List allowableWindowState = windowStateMN;
        if (parent != null && parent.length() != 0) {
            parentcp = (ContainerProvider)((Object)cpc.getProvider(req, null, parent));
            windowState = (WindowState)windowStateMap.get(Integers.get(parentcp.getWindowState(this.getName())));
            allowableWindowState = this.getWindowStateList(parentcp.getSupportedWindowStates());
        }
        GetMarkupRequestImpl creq = (GetMarkupRequestImpl)this.assembleContainerRequest(req, parent, portletentityId, ChannelMode.VIEW, windowState, allowableWindowState, channelModeVE, true);
        creq.setRenderParameters(renderParams);
        creq.setIsTarget(isTarget);
        GetMarkupResponseImpl cres = (GetMarkupResponseImpl)this.assembleContainerResponse(res, true);
        try {
            this.container.getMarkup((GetMarkupRequest)creq, (GetMarkupResponse)cres);
        }
        catch (ContainerException ce) {
            throw new ProviderException("PortletWindowProvider.getContent():container exception", ce);
        }
        catch (ContentException cte) {
            throw new ProviderException("PortletWindowProvider.getContent():An exception occured when trying to get content for portlet " + this.getName(), cte);
        }
        this.title = cres.getTitle();
        StringBuffer content = cres.getMarkup();
        if (content == null) {
            pc.debugError("PortletWindowProvider.getContent(): content from cres is null for channel: " + this.getName());
        }
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        ContainerProviderContext cpc = (ContainerProviderContext)pc;
        boolean authless = pc.isAuthless(req);
        String portletentityId = this.getEntityID();
        Map renderParams = this.getRenderParams(portletentityId, authless);
        boolean isTarget = this.getIsTarget(portletentityId, authless);
        this.setIsTarget(portletentityId, authless, false);
        String parent = req.getParameter("containerName");
        ContainerProvider parentcp = null;
        if (parent != null && parent.length() != 0) {
            parentcp = (ContainerProvider)((Object)cpc.getProvider(req, null, parent));
        }
        List allowableWindowState = parentcp == null ? windowStateMN : this.getWindowStateList(parentcp.getSupportedWindowStates());
        GetMarkupRequestImpl creq = (GetMarkupRequestImpl)this.assembleContainerRequest(req, parent, portletentityId, ChannelMode.EDIT, WindowState.NORMAL, allowableWindowState, channelModeVE, true);
        creq.setRenderParameters(renderParams);
        creq.setIsTarget(isTarget);
        GetMarkupResponseImpl cres = (GetMarkupResponseImpl)this.assembleContainerResponse(res, true);
        try {
            this.container.getMarkup((GetMarkupRequest)creq, (GetMarkupResponse)cres);
        }
        catch (ContainerException ce) {
            throw new ProviderException("PortletWindowProvider.getContent():container exception", ce);
        }
        catch (ContentException cte) {
            throw new ProviderException("PortletWindowProvider.getEdit():An exception occured when trying to get content for portlet " + this.getName(), cte);
        }
        this.title = cres.getTitle();
        StringBuffer portletedit = cres.getMarkup();
        req.setAttribute("editContent", (Object)portletedit);
        URL helpURL = null;
        String editContainerName = req.getParameter("provider");
        if (editContainerName != null && editContainerName.length() != 0) {
            Provider editProvider = cpc.getProvider(req, null, editContainerName);
            helpURL = editProvider.getHelp(req);
        }
        if (helpURL != null) {
            req.setAttribute("editContainerHelpURL", (Object)helpURL.toString());
        } else {
            req.setAttribute("editContainerHelpURL", (Object)"");
        }
        return super.getEdit(req, res);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        ContainerProviderContext cpc = (ContainerProviderContext)pc;
        String parent = req.getParameter("containerName");
        ContainerProvider parentcp = null;
        if (parent != null && parent.length() != 0) {
            parentcp = (ContainerProvider)((Object)cpc.getProvider(req, null, parent));
        }
        boolean authless = pc.isAuthless(req);
        String portletentityId = this.getEntityID();
        String mode = req.getParameter("javax.portlet.portletc.portletMode");
        String currentChannelMode = req.getParameter("currentChannelMode");
        ChannelMode channelMode = mode != null ? new ChannelMode(mode) : new ChannelMode(currentChannelMode);
        URL returnURL = this.processModeChange(channelMode, req, pc, parent);
        String state = req.getParameter("javax.portlet.portletc.windowState");
        WindowState windowState = state == null ? null : new WindowState(state);
        boolean validState = this.validateWindowStateChange(channelMode, windowState);
        if (!validState) {
            windowState = WindowState.NORMAL;
        }
        this.processWindowStateChange(windowState, parentcp);
        String pAction = req.getParameter("javax.portlet.portletc.portletAction");
        if (pAction != null && pAction.equals(RENDER)) {
            this.setRenderParams(portletentityId, authless, this.parseParameterMap(((DesktopRequest)req).getParameterMap()));
            this.setIsTarget(portletentityId, authless, true);
        } else {
            this.setRenderParams(portletentityId, authless, Collections.EMPTY_MAP);
            Map actionParams = this.parseParameterMap(((DesktopRequest)req).getParameterMap());
            List allowableWindowState = parentcp == null ? windowStateMN : this.getWindowStateList(parentcp.getSupportedWindowStates());
            List allowableChannelMode = channelMode.equals((Object)ChannelMode.HELP) ? channelModeH : channelModeVE;
            boolean isTarget = true;
            if (windowState == null) {
                windowState = parentcp != null ? (WindowState)windowStateMap.get(Integers.get(parentcp.getWindowState(this.getName()))) : WindowState.NORMAL;
            }
            ExecuteActionRequestImpl creq = (ExecuteActionRequestImpl)this.assembleContainerRequest(req, parent, portletentityId, channelMode, windowState, allowableWindowState, allowableChannelMode, false);
            creq.setActionParameters(actionParams);
            creq.setCharacterEncoding(req.getCharacterEncoding());
            ExecuteActionResponseImpl cres = (ExecuteActionResponseImpl)this.assembleContainerResponse(res, false);
            try {
                this.container.executeAction((ExecuteActionRequest)creq, (ExecuteActionResponse)cres);
            }
            catch (ContainerException ce) {
                throw new ProviderException("PortletWindowProvider.processEdit():container exception", ce);
            }
            catch (ContentException cte) {
                throw new ProviderException("PortletWindowProvider.processEdit():An exception occured when trying to get processing an action for portlet " + this.getName(), cte);
            }
            URL redirectURL = cres.getRedirectURL();
            if (redirectURL == null) {
                boolean valid;
                channelMode = cres.getNewChannelMode();
                if (channelMode != null) {
                    returnURL = this.processModeChange(channelMode, req, pc, parent);
                }
                if (!(valid = this.validateWindowStateChange(channelMode, windowState = cres.getNewWindowState()))) {
                    windowState = WindowState.NORMAL;
                }
                this.processWindowStateChange(windowState, parentcp);
                Map renderParameters = cres.getRenderParameters();
                if (renderParameters != null) {
                    this.setRenderParams(portletentityId, authless, renderParameters);
                }
            } else {
                returnURL = redirectURL;
            }
        }
        return returnURL;
    }

    public String getTitle() throws ProviderException {
        if (this.title != null && this.title.length() != 0) {
            return this.title;
        }
        return this.getStringProperty("title");
    }

    public URL getHelp(HttpServletRequest req) throws ProviderException {
        String contentType = this.getProviderContext().getContentType();
        String hu = null;
        Map hasHelpMap = this.getMapProperty("hasHelpByMimeType");
        if (hasHelpMap.containsKey(contentType)) {
            hu = (String)hasHelpMap.get(contentType);
        }
        if (hu != null && hu.length() == 0) {
            return null;
        }
        String desktopURL = this.getProviderContext().getDesktopURL(req);
        URL helpURL = null;
        try {
            helpURL = new URL(desktopURL + "?action=content&provider=" + this.getName() + "&" + KEYWORD_PREFIX + "Mode=HELP&last=false");
        }
        catch (MalformedURLException mue) {
            throw new ProviderException("PortletWindowProvider.getHelp():couldn't build helpURL", mue);
        }
        return helpURL;
    }

    public boolean isPresentable() {
        try {
            String contentType = this.getProviderContext().getContentType();
            List supportedContentTypes = this.getListProperty("supportedContentTypes");
            return supportedContentTypes.contains(contentType) || supportedContentTypes.contains("text/*") || supportedContentTypes.contains("*/*");
        }
        catch (ProviderException pe) {
            if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning("PortletWindowProvider.isPresentable(): exception getting supportedContentTypes", pe);
            }
            return false;
        }
    }

    public boolean isEditable() throws ProviderException {
        boolean isEditable = false;
        String contentType = this.getProviderContext().getContentType();
        Map isEditableMap = this.getMapProperty("isEditableByMimeType");
        if (isEditableMap.containsKey(contentType)) {
            isEditable = (Boolean)isEditableMap.get(contentType);
        }
        return isEditable;
    }

    private String getEntityID() throws ProviderException {
        String entityIdPrefix = this.getStringProperty("entityIDPrefix");
        String entityId = entityIdPrefix + PARAM_DELIMITER + this.getName();
        return entityId;
    }

    private ContainerRequestImpl assembleContainerRequest(HttpServletRequest req, String parent, String entityId, ChannelMode channelMode, WindowState winState, List allowableWinStates, List allowableChannelModes, boolean markup) throws ProviderException {
        Object creq = null;
        creq = markup ? new GetMarkupRequestImpl() : new ExecuteActionRequestImpl();
        HttpServletRequest origReq = RequestThreadLocalizer.getRequest();
        creq.setHttpServletRequest(origReq);
        origReq.setAttribute(PROVIDER_CONTEXT, (Object)this.getProviderContext());
        creq.setEntityID(entityId);
        creq.setAllowableWindowState(allowableWinStates);
        creq.setAllowableChannelMode(allowableChannelModes);
        String contentType = this.getProviderContext().getContentType();
        ArrayList<String> allowableContentTypes = new ArrayList<String>();
        allowableContentTypes.add(contentType);
        creq.setAllowableContentType(allowableContentTypes);
        creq.setWindowState(winState);
        creq.setChannelMode(channelMode);
        String userID = null;
        SSOToken token = null;
        if (!this.getProviderContext().isAuthless(req)) {
            userID = this.getProviderContext().getUserID();
            try {
                SSOTokenManager tokenManager = SSOTokenManager.getInstance();
                if (tokenManager == null) {
                    throw new ProviderException("PortletWindowProvider.assembleContainerRequest(): Failed to getSSOTokenmanager.");
                }
                token = tokenManager.createSSOToken(req);
            }
            catch (SSOException ssoe) {
                throw new ProviderException("PortletWindowProvider.assembleContainerRequest():", ssoe);
            }
        }
        creq.setUserID(userID);
        origReq.setAttribute(SSO_TOKEN, token);
        StringBuffer desktopURL = new StringBuffer(this.getProviderContext().getDesktopURL(req));
        desktopURL.append("?action=process&provider=").append(PROCESS_CHANNEL).append("&targetPortletChannel=").append(this.getName()).append("&containerName=").append(parent).append("&currentChannelMode=").append(channelMode.toString());
        creq.setDesktopURL(desktopURL.toString());
        ArrayList<String> rolesList = null;
        try {
            if (this.getProviderContext().existsCollectionProperty(this.getName(), "roleMap")) {
                Map roleMap = this.getMapProperty("roleMap");
                Set roles = this.getProviderContext().getRoles();
                if (roles.isEmpty()) {
                    rolesList = Collections.EMPTY_LIST;
                } else {
                    rolesList = new ArrayList<String>();
                    Iterator i = roles.iterator();
                    while (i.hasNext()) {
                        String dsameRole = (String)i.next();
                        if (!roleMap.containsKey(dsameRole)) continue;
                        String logicalRole = (String)roleMap.get(dsameRole);
                        rolesList.add(logicalRole);
                    }
                }
            } else {
                rolesList = Collections.EMPTY_LIST;
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("PortletWindowProvider.assembleContainerRequest():couldn't check for exists on roleMap collection", pce);
        }
        creq.setRoles((List)rolesList);
        HashMap<String, String> userInfo = null;
        try {
            if (this.getProviderContext().existsCollectionProperty(this.getName(), "userInfoMap")) {
                Map userInfoMap = this.getMapProperty("userInfoMap");
                userInfo = new HashMap<String, String>();
                Set keys = userInfoMap.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String dsameAttr = (String)i.next();
                    String portletAttr = (String)userInfoMap.get(dsameAttr);
                    String attrValue = this.getProviderContext().getStringAttribute(dsameAttr);
                    if (attrValue == null) continue;
                    userInfo.put(portletAttr, attrValue);
                }
            } else {
                userInfo = Collections.EMPTY_MAP;
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("PortletWindowProvider.assembleContainerRequest():couldn't check for exists on userInfoMap collection", pce);
        }
        creq.setUserInfo((Map)userInfo);
        return creq;
    }

    private ContainerResponseImpl assembleContainerResponse(HttpServletResponse res, boolean markup) {
        Object cres = null;
        cres = markup ? new GetMarkupResponseImpl() : new ExecuteActionResponseImpl();
        HttpServletResponse origRes = RequestThreadLocalizer.getResponse();
        cres.setHttpServletResponse(origRes);
        return cres;
    }

    private List getWindowStateList(int[] supportedWinStates) {
        ArrayList<WindowState> newList = new ArrayList<WindowState>();
        int i = 0;
        while (i < supportedWinStates.length) {
            int element = supportedWinStates[i];
            WindowState winState = (WindowState)windowStateMap.get(Integers.get(element));
            newList.add(winState);
            ++i;
        }
        return newList;
    }

    private Map parseParameterMap(Map parameterMap) {
        HashMap<String, String[]> parsedMap = new HashMap<String, String[]>();
        Iterator keyIterator = parameterMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            if (key.startsWith(KEYWORD_PREFIX) || portalParamKeyList.contains(key) || key.endsWith(".targetProvider") || key.endsWith(".channelAction") || key.endsWith(".setSelected")) continue;
            parsedMap.put(key, (String[])parameterMap.get(key));
        }
        return parsedMap;
    }

    private String getStringFromMap(Map paramMap) {
        String paramString = "";
        StringBuffer sb = new StringBuffer();
        Iterator i = paramMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key).append(KEY_DELIMITER);
            try {
                String[] value = (String[])paramMap.get(key);
                int j = 0;
                while (j < value.length) {
                    sb.append(value[j]);
                    if (j + 1 < value.length) {
                        sb.append(ARRAY_DELIMITER);
                    }
                    ++j;
                }
            }
            catch (ClassCastException cce) {
                this.getProviderContext().debugWarning("PortletWindowProvider.getStringFromMap(): RenderParam value should be a String array", cce);
            }
            if (!i.hasNext()) continue;
            sb.append(PARAM_DELIMITER);
        }
        paramString = sb.toString();
        return paramString;
    }

    private Map getMapFromString(String paramString) {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        StringTokenizer paramtokenizer = new StringTokenizer(paramString, PARAM_DELIMITER);
        while (paramtokenizer.hasMoreTokens()) {
            String keyValue = paramtokenizer.nextToken();
            StringTokenizer keyTokenizer = new StringTokenizer(keyValue, KEY_DELIMITER);
            if (keyTokenizer.countTokens() != 2) continue;
            String key = keyTokenizer.nextToken();
            String value = keyTokenizer.nextToken();
            StringTokenizer valueTokenizer = new StringTokenizer(value, ARRAY_DELIMITER);
            int noTokens = valueTokenizer.countTokens();
            String[] valueArray = new String[noTokens];
            int i = 0;
            while (i < noTokens) {
                valueArray[i] = valueTokenizer.nextToken();
                ++i;
            }
            paramMap.put(key, valueArray);
        }
        return paramMap;
    }

    private Map getRenderParams(String entityId, boolean authless) {
        Map renderParams = null;
        ProviderContext pc = this.getProviderContext();
        if (authless) {
            String paramString = pc.getClientProperty(RENDER_PARAM_PREFIX + entityId);
            if (paramString == null) {
                return Collections.EMPTY_MAP;
            }
            renderParams = this.getMapFromString(paramString);
        } else {
            renderParams = (Map)pc.getSessionProperty(RENDER_PARAM_PREFIX + entityId);
        }
        if (renderParams == null) {
            return Collections.EMPTY_MAP;
        }
        return renderParams;
    }

    private void setRenderParams(String entityId, boolean authless, Map renderParams) {
        ProviderContext pc = this.getProviderContext();
        if (authless) {
            String paramString = "";
            if (!renderParams.isEmpty()) {
                paramString = this.getStringFromMap(renderParams);
            }
            pc.setClientProperty(RENDER_PARAM_PREFIX + entityId, paramString);
        } else {
            pc.setSessionProperty(RENDER_PARAM_PREFIX + entityId, renderParams);
        }
    }

    private boolean getIsTarget(String entityId, boolean authless) {
        ProviderContext pc = this.getProviderContext();
        Boolean target = null;
        target = authless ? new Boolean(pc.getClientProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX)) : new Boolean((String)pc.getSessionProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX));
        if (target != null) {
            return target;
        }
        return false;
    }

    private void setIsTarget(String entityId, boolean authless, boolean isTarget) {
        ProviderContext pc = this.getProviderContext();
        if (authless) {
            pc.setClientProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX, String.valueOf(isTarget));
        } else {
            pc.setSessionProperty(KEYWORD_PREFIX + entityId + TARGET_SUFFIX, String.valueOf(isTarget));
        }
    }

    private URL processModeChange(ChannelMode channelMode, HttpServletRequest req, ProviderContext pc, String parent) throws ProviderException {
        URL redirectURL;
        block9: {
            redirectURL = null;
            if (channelMode != null && channelMode.equals((Object)ChannelMode.EDIT)) {
                try {
                    redirectURL = new URL(pc.getDesktopURL(req) + "?action=edit&provider=" + pc.getStringProperty(parent, "editContainerName") + "&targetprovider=" + this.getName() + "&containerName=" + parent);
                }
                catch (MalformedURLException mue) {
                    if (pc.isDebugWarningEnabled()) {
                        pc.debugWarning("portletWindowProvider.processEdit(): couldn't generate redirect URL to edit page", mue);
                    }
                    break block9;
                }
                catch (ProviderContextException pce) {
                    if (pc.isDebugWarningEnabled()) {
                        pc.debugWarning("portletWindowProvider.processEdit(): couldn't generate redirect URL to edit page", pce);
                    }
                    break block9;
                }
            }
            if (channelMode != null && channelMode.equals((Object)ChannelMode.HELP)) {
                try {
                    redirectURL = new URL(pc.getDesktopURL(req) + "?action=content&provider=" + this.getName() + "&" + KEYWORD_PREFIX + "Mode=HELP&last=false");
                }
                catch (MalformedURLException mue) {
                    if (!pc.isDebugWarningEnabled()) break block9;
                    pc.debugWarning("portletWindowProvider.processEdit(): couldn't generate redirect URL to help page", mue);
                }
            }
        }
        return redirectURL;
    }

    private void processWindowStateChange(WindowState windowState, ContainerProvider parentcp) throws ProviderException {
        try {
            if (windowState != null) {
                int providerWinState = (Integer)reverseMap.get(windowState);
                if (parentcp != null) {
                    parentcp.setWindowState(this.getName(), providerWinState);
                } else if (!windowState.equals((Object)WindowState.MAXIMIZED) && !windowState.equals((Object)WindowState.NORMAL)) {
                    throw new ProviderException("portletWindowProvider.processEdit(): couldn't set the window state to " + providerWinState);
                }
            }
        }
        catch (UnsupportedWindowStateException wse) {
            throw new ProviderException("PortletWindowProvider.processContainerResponse():The new window state set in the portlet is not supported", wse);
        }
    }

    private boolean validateWindowStateChange(ChannelMode channelMode, WindowState windowState) {
        boolean validState = true;
        if (channelMode != null && (channelMode.equals((Object)ChannelMode.EDIT) || channelMode.equals((Object)ChannelMode.HELP)) && windowState != null && windowState.equals((Object)WindowState.MINIMIZED)) {
            validState = false;
        }
        return validState;
    }

    static {
        windowStateMap.put(Integers.get(1), WindowState.MINIMIZED);
        windowStateMap.put(Integers.get(3), WindowState.MAXIMIZED);
        windowStateMap.put(Integers.get(2), WindowState.NORMAL);
        reverseMap.put(WindowState.MINIMIZED, Integers.get(1));
        reverseMap.put(WindowState.MAXIMIZED, Integers.get(3));
        reverseMap.put(WindowState.NORMAL, Integers.get(2));
        channelModeVE.add(ChannelMode.VIEW);
        channelModeVE.add(ChannelMode.EDIT);
        channelModeH.add(ChannelMode.HELP);
        windowStateMN.add(WindowState.MAXIMIZED);
        windowStateMN.add(WindowState.NORMAL);
        portalParamKeyList.add("action");
        portalParamKeyList.add("provider");
        portalParamKeyList.add("targetprovider");
        portalParamKeyList.add("containerName");
        portalParamKeyList.add("last");
        portalParamKeyList.add("page");
        portalParamKeyList.add("error");
        portalParamKeyList.add("container");
        portalParamKeyList.add("selected");
        portalParamKeyList.add("editChannelName");
        portalParamKeyList.add("targetPortletChannel");
        portalParamKeyList.add("currentChannelMode");
    }
}

