/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import java.util.HashMap;
import java.util.Set;

class DPAMerge {
    XMLDPFactory dpf = XMLDPFactory.getInstance();

    DPAMerge() {
    }

    public String process(DSAMEAdminDPContext dadc, String dn, boolean global, String name, boolean verbose) throws DPAException {
        Object[] tokens;
        String doc = null;
        if (verbose) {
            tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            DPAUtil.debug("dbgRetrievingDP", tokens);
        }
        try {
            if (global) {
                doc = dadc.getGlobalDPDocument();
                if (doc == null || doc.length() == 0) {
                    return null;
                }
                if (name == null) {
                    return doc.toString();
                }
            } else {
                doc = dadc.getDPDocumentByDN(dn);
            }
        }
        catch (Throwable ex) {
            Object[] tokens2 = new Object[]{DPAUtil.getLocalizedString("msgGlobal")};
            throw new DPAException("errorRetrieveDP", ex, tokens2);
        }
        if (verbose) {
            tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            DPAUtil.debug("dbgBuildingDPRoot", tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = doc != null && doc.length() > 0 ? this.dpf.createRoot((DPContext)dadc, doc) : this.dpf.createRoot(dadc);
            if (!global) {
                Set names = dadc.getDPDocumentNames(dn);
                dpr = this.dpf.addMergers(dadc, dadc, dpr, names, new HashMap());
                if (name == null) {
                    return dpr.toMergedXML();
                }
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorCreateDPRoot", ex, tokens3);
        }
        if (verbose) {
            Object[] tokens4 = new Object[]{name};
            DPAUtil.debug("dbgFindPropertyHolder", tokens4);
        }
        DPPropertyHolder ph = null;
        try {
            ph = dpr.getChannel(name);
            if (ph == null) {
                ph = dpr.getProvider(name);
            }
            if (ph != null) {
                return ph.toMergedXML();
            }
            return null;
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{name};
            throw new DPAException("errorFindPropertyHolder", ex, tokens5);
        }
    }
}

