/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.util.GWDebug;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class EvalPAC
extends ScriptableObject {
    private static String pacFileBody = "";
    private Scriptable defaultInitializedScript;
    private Context context;
    private String clientIPAddress = "255.255.255.255";
    static /* synthetic */ Class class$com$sun$portal$util$EvalPAC;

    public String getClassName() {
        return "EvalPAC";
    }

    public boolean shExpMatch(String url, String exp) {
        StringTokenizer stTok = new StringTokenizer(exp, "*");
        int startPos = 0;
        while (stTok.hasMoreTokens()) {
            String token = stTok.nextToken();
            int temp = url.indexOf(token, startPos);
            if (temp < 0) {
                return false;
            }
            startPos = temp + token.length();
        }
        return true;
    }

    public String myIpAddress() {
        return this.clientIPAddress;
    }

    public String dnsResolve(String host) {
        String ipAddr = "";
        try {
            ipAddr = InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipAddr;
    }

    public boolean isResolvable(String host) {
        boolean result = false;
        try {
            InetAddress.getByName(host).getHostAddress();
            result = true;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public boolean isInNet(String host, String pattern, String mask) {
        int count = 0;
        int startPos = 0;
        while ((startPos = mask.indexOf("255", startPos + 1)) > -1) {
            ++count;
        }
        StringTokenizer hostTok = new StringTokenizer(host, ".");
        StringTokenizer patternTok = new StringTokenizer(pattern, ".");
        for (int i = 0; i <= count; ++i) {
            if (!hostTok.hasMoreTokens() || !patternTok.hasMoreTokens()) {
                return false;
            }
            if (hostTok.nextToken().equals(patternTok.nextToken())) continue;
            return false;
        }
        return true;
    }

    public boolean dnsDomainIs(String url, String domain) {
        return url.endsWith(domain);
    }

    public boolean localHostOrDomainIs(String host, String domain) {
        return domain.startsWith(host);
    }

    public boolean isPlainHostName(String host) {
        return host.indexOf(".") <= -1;
    }

    public int dnsDomainLevels(String host) {
        int count = 0;
        int startPos = 0;
        while ((startPos = host.indexOf(".", startPos + 1)) > -1) {
            ++count;
        }
        return count;
    }

    public static EvalPAC getInstance(Context context) {
        return new EvalPAC(context);
    }

    public EvalPAC(Context context) {
        String[] names = new String[]{"shExpMatch", "dnsResolve", "isResolvable", "isInNet", "dnsDomainIs", "isPlainHostName", "myIpAddress", "dnsDomainLevels", "localHostOrDomainIs"};
        try {
            this.defineFunctionProperties(names, class$com$sun$portal$util$EvalPAC == null ? (class$com$sun$portal$util$EvalPAC = EvalPAC.class$("com.sun.portal.util.EvalPAC")) : class$com$sun$portal$util$EvalPAC, 2);
        }
        catch (PropertyException e) {
            throw new Error(e.getMessage());
        }
        this.context = context;
        this.defaultInitializedScript = context.initStandardObjects((ScriptableObject)this);
    }

    public void setIPAddress(String ipAddr) {
        this.clientIPAddress = ipAddr;
    }

    public String evaluate(String pacFileBody, Vector arguments) throws Exception {
        String evalSt = " ;FindProxyForURL (\"" + arguments.elementAt(0) + "\",\"" + arguments.elementAt(1) + "\")";
        Object result = this.context.evaluateString(this.defaultInitializedScript, pacFileBody + evalSt, "userPacFile", 1, null);
        String resultToString = Context.toString((Object)result);
        return resultToString;
    }

    public static String getProxy(String url, String host, String clientIP) {
        try {
            Vector<String> arguments = new Vector<String>();
            arguments.add(url);
            arguments.add(host);
            Context context = Context.enter();
            EvalPAC t = EvalPAC.getInstance(context);
            t.setIPAddress(clientIP);
            String result = t.evaluate(pacFileBody, arguments);
            Context.exit();
            return result;
        }
        catch (Exception ex) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("PAC : getProxy exception ", ex);
            }
            return null;
        }
    }

    private static byte[] readContent(URLConnection configURLConn) throws IOException {
        int numbytes;
        InputStream autoConfigURLInputStream = configURLConn.getInputStream();
        int length = configURLConn.getContentLength();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] content = new byte[2048];
        if (length <= 0) {
            int read = 0;
            int totalRead = 0;
            while (totalRead < length) {
                int left = length - totalRead;
                read = autoConfigURLInputStream.read(content, 0, left < content.length ? left : content.length);
                if (read == -1) {
                    if (totalRead >= length) break;
                    continue;
                }
                if (read <= 0) continue;
                totalRead += read;
                baos.write(content, 0, read);
            }
            return baos.toByteArray();
        }
        int totalRead = 0;
        while ((numbytes = autoConfigURLInputStream.read(content)) != -1) {
            totalRead += numbytes;
            baos.write(content, 0, numbytes);
        }
        return baos.toByteArray();
    }

    public static void initPACFile(String pacFileLocation) throws Exception {
        try {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("PAC File URL : " + pacFileLocation);
            }
            URL url = new URL(pacFileLocation);
            URLConnection configURLConn = url.openConnection();
            configURLConn.setUseCaches(false);
            configURLConn.setDoInput(true);
            configURLConn.setAllowUserInteraction(false);
            byte[] data = EvalPAC.readContent(configURLConn);
            pacFileBody = new String(data, "UTF8");
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("PAC file body : \n" + pacFileBody);
            }
        }
        catch (Exception ex) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Error processing pac file : " + pacFileLocation, ex);
            }
            throw new Exception("Unable to load PAC File.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

