/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.services;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.re.RegExp;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.util.List;

public class URI2RuleSetMap {
    private final ListMap uriPatternsMap;
    private final ListMap domainMap;
    private final String starRuleSet;

    URI2RuleSetMap(List aRuleSetMap) {
        ListMap lPatternMap = new ListMap();
        ListMap lDomainMap = new ListMap();
        String lStarRuleSet = null;
        for (int i = 0; i < aRuleSetMap.size(); ++i) {
            String line = StringHelper.normalize((String)((String)aRuleSetMap.get(i))).toString();
            String[] splited = StringHelper.tokenize((String)line, (String)"|", (boolean)false, (int)2);
            splited[0] = splited[0].trim();
            splited[1] = splited[1].trim();
            if (splited[0].length() == 0 || splited[1].length() == 0) continue;
            if (splited[0].length() == 1 && splited[0].equals("*")) {
                lStarRuleSet = splited[1];
                continue;
            }
            String lRulesetName = splited[1].toLowerCase();
            if (splited[0].indexOf(42) == -1 && splited[0].indexOf(47) == -1 && splited[0].indexOf(58) == -1) {
                lDomainMap.put((Object)splited[0].toLowerCase(), (Object)lRulesetName);
                continue;
            }
            lPatternMap.put((Object)new Pattern(splited[0], true), (Object)lRulesetName);
        }
        this.uriPatternsMap = ListMap.unmodifiableListMap((ListMap)lPatternMap);
        this.domainMap = ListMap.unmodifiableListMap((ListMap)lDomainMap);
        this.starRuleSet = lStarRuleSet;
    }

    public String selectRuleset4Page(PageSpec aPageSpec) {
        String lResult = this.matchURIPatterns(aPageSpec);
        if (lResult != null) {
            return lResult;
        }
        lResult = this.matchDomains(aPageSpec);
        if (lResult != null) {
            return lResult;
        }
        return this.starRuleSet;
    }

    private String matchURIPatterns(PageSpec aPageSpec) {
        String[] lResult = new String[]{"", ""};
        List lList = this.uriPatternsMap.keyList();
        for (int i = 0; i < this.uriPatternsMap.size(); ++i) {
            Pattern key = (Pattern)lList.get(i);
            if (!RegExp.match((Pattern)key, (String)aPageSpec.getBaseURI().getFullFileURI()) || key.getInput().length() <= lResult[0].length()) continue;
            lResult[0] = key.getInput();
            lResult[1] = this.uriPatternsMap.get((Object)key).toString();
        }
        if (lResult[0].length() > 0) {
            return lResult[1];
        }
        return null;
    }

    private String matchDomains(PageSpec aPageSpec) {
        String hostName = aPageSpec.getBaseURI().getHost().toLowerCase();
        while (true) {
            Object ruleSetID;
            if ((ruleSetID = this.domainMap.get((Object)hostName)) != null) {
                return ruleSetID.toString();
            }
            int dotIndex = hostName.indexOf(46);
            if (dotIndex == -1) break;
            hostName = hostName.substring(dotIndex + 1);
        }
        return null;
    }
}

