/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocketFactory;
import com.sun.portal.rproxy.connectionhandler.SocketCache;
import com.sun.portal.rproxy.connectionhandler.Timer;
import com.sun.portal.rproxy.connectionhandler.TimerClient;
import com.sun.portal.util.GWDebug;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLSocket;

public class CachedSocket
implements TimerClient {
    public static final int IDLE = 0;
    public static final int ACTIVE = 1;
    public static final int CLOSED = 2;
    private static final int KEEP_ALIVE_TIMEOUT = 15000;
    private int _state = 0;
    private CSBufferedInputStream _inputStream = null;
    private SocketCache _socketCache = null;
    private Socket _socket = null;
    private String _socketType;
    private Timer _timer = null;
    private int _timeout = 0;

    public CachedSocket(Socket socket) throws IOException {
        this._socket = socket;
        this._inputStream = new CSBufferedInputStream(this._socket.getInputStream());
        this._inputStream.setSocket(this);
    }

    public synchronized void setIdle() {
        this._timeout = CachedSocketFactory._timeout;
        if (this._timer != null) {
            this._timer.stopTimer();
            this._timer = null;
        }
        this._timer = new Timer(this, this._timeout);
        this._state = 0;
    }

    public synchronized void setActive() {
        this._state = 1;
        this._timeout = 0;
        if (this._timer != null) {
            this._timer.stopTimer();
            this._timer = null;
        }
    }

    public synchronized void setClosed() {
        this._state = 2;
    }

    public synchronized void timeOut() {
        block5: {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("CachedSocket[" + this.toString() + "] timer timed out");
            }
            this._timer = null;
            try {
                if (this._state == 0 || this._state == 2) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("CachedSocket[" + this.toString() + "]: Timer closing socket " + this._state);
                    }
                    this.close();
                }
            }
            catch (IOException ioe) {
                if (!GWDebug.debug.messageEnabled()) break block5;
                GWDebug.debug.message("Exception when CachedSocket[" + this.toString() + "] timedout", ioe);
            }
        }
    }

    public synchronized int getState() {
        return this._state;
    }

    public CSBufferedInputStream getInputStream() {
        return this._inputStream;
    }

    public void setSocketCache(SocketCache socketCache) {
        this._socketCache = socketCache;
    }

    public SocketCache getSocketCache() {
        return this._socketCache;
    }

    public void setType(String socketType) {
        this._socketType = socketType;
    }

    public String getType() {
        return this._socketType;
    }

    public synchronized void setTimeout(int timeout) {
        this._timeout = timeout * 1000;
    }

    public OutputStream getOutputStream() throws IOException {
        return this._socket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this._state != 2) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Closing CachedSocket[" + this.toString() + "]");
            }
            this.setClosed();
            if (this._inputStream != null) {
                this._inputStream.close();
                this._inputStream = null;
            }
            if (this._timer != null) {
                this._timer.stopTimer();
            }
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this._socket = null;
                }
            }
            if (PerfContextObject.ENABLE_PERF) {
                if (this._socket instanceof SSLSocket) {
                    SocketCount.decrementSSLSockets();
                } else {
                    SocketCount.decrementPlainSockets();
                }
            }
            if (this._socketCache != null) {
                this._socketCache.removeSocket(this);
            }
        }
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public String toString() {
        return this._socket.toString();
    }

    public Socket getSocket() {
        return this._socket;
    }
}

