/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.AddRootCA;
import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminException;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.CertContext;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.CreateSelfSignedCertificate;
import com.sun.portal.cli.cert.DeleteCertificate;
import com.sun.portal.cli.cert.Exit;
import com.sun.portal.cli.cert.GenerateCSR;
import com.sun.portal.cli.cert.InstallCertificate;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSContextImpl;
import com.sun.portal.cli.cert.ListCACertificates;
import com.sun.portal.cli.cert.ListCertificates;
import com.sun.portal.cli.cert.ModifyTrustAttributes;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.PasswordContextImpl;
import com.sun.portal.cli.cert.PrintCertificate;
import com.sun.portal.cli.cert.SystemProperties;
import java.util.ResourceBundle;

public class CertAdminFactory {
    public static PasswordContext CreatePasswordContext() {
        return new PasswordContextImpl();
    }

    public static JSSContext CreateJSSContext(String inst, String basedir, String dsameLocaledir) throws CertAdminException {
        String platformFile = basedir + CertAdminConstants.SEPERATOR + "platform.conf" + "." + inst;
        if (!CertAdminUtil.fileExist(platformFile)) {
            throw new CertAdminException(CertAdminLocale.getPFString("m2", "Error!, Cannot locate Platform file"));
        }
        SystemProperties.init(platformFile);
        String certdir = SystemProperties.get("gateway.certdir");
        String fqdn = SystemProperties.get("gateway.host");
        String dsameLocaleFile = dsameLocaledir + CertAdminConstants.SEPERATOR + "AMConfig.properties";
        ResourceBundle amConfigProps = ResourceBundle.getBundle("AMConfig");
        String locale = "en_US";
        try {
            locale = amConfigProps.getString("com.iplanet.am.locale");
        }
        catch (Exception ex) {
            locale = "en_US";
        }
        JSSContextImpl jsscntx = new JSSContextImpl(certdir, fqdn, locale);
        jsscntx.setPasswordContext(CertAdminFactory.CreatePasswordContext());
        if (!jsscntx.init()) {
            throw new CertAdminException(CertAdminLocale.getPFString("m1", "Error!, Initialization failed"));
        }
        return jsscntx;
    }

    public static CertContext CreateCertificateContext(String fqdn, String o, String ou, String l, String s, String c, String token, String nick, int val) {
        CertContext certcntx = new CertContext();
        certcntx.fqdn = fqdn;
        certcntx.o = o;
        certcntx.ou = ou;
        certcntx.l = l;
        certcntx.s = s;
        certcntx.c = c;
        certcntx.token = token;
        certcntx.nick = nick;
        certcntx.val = val;
        return certcntx;
    }

    public static Command CreateCommand(int cid) {
        switch (cid) {
            case 1: {
                return new CreateSelfSignedCertificate();
            }
            case 2: {
                return new GenerateCSR();
            }
            case 3: {
                return new AddRootCA();
            }
            case 4: {
                return new InstallCertificate();
            }
            case 5: {
                return new DeleteCertificate();
            }
            case 6: {
                return new ModifyTrustAttributes();
            }
            case 7: {
                return new ListCACertificates();
            }
            case 8: {
                return new ListCertificates();
            }
            case 9: {
                return new PrintCertificate();
            }
        }
        return new Exit();
    }
}

