/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util;

import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.xml.Document;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public final class Resource {
    private static final String[] messages = new String[]{"Unable to Read inFull\n"};
    static /* synthetic */ Class class$com$sun$portal$rewriter$util$Resource;

    public static String read(String aFileName) {
        return Resource.read(aFileName, (Class)null);
    }

    public static String read(String aFileName, Class aClass) {
        return Resource.read(aFileName, aClass, null);
    }

    public static String read(String aFileName, String aCharSetID) {
        return Resource.read(aFileName, null, aCharSetID);
    }

    public static String read(String aFileName, Class aClass, String aCharSetID) {
        try {
            String data = "";
            InputStream in = Resource.getInputStream(aClass, aFileName);
            data = aCharSetID == null ? Resource.read(new InputStreamReader(in)) : Resource.read(new InputStreamReader(in, aCharSetID));
            in.close();
            return data;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String read(Reader aReader) {
        String lResult = "";
        try {
            BufferedReader buffReader = aReader instanceof BufferedReader ? (BufferedReader)aReader : new BufferedReader(aReader);
            lResult = Resource.read(buffReader);
            aReader.close();
        }
        catch (IOException e) {
            Debug.warning(messages[0], e);
        }
        return lResult;
    }

    private static final String read(BufferedReader aReader) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] data = new char[2048];
        int count = 0;
        while ((count = aReader.read(data)) != -1) {
            sb.append(data, 0, count);
        }
        aReader.close();
        return sb.toString();
    }

    public static boolean save(String aFileName, byte[] aContentArray) {
        try {
            FileOutputStream fOut = new FileOutputStream(aFileName);
            ((OutputStream)fOut).write(aContentArray);
            fOut.flush();
            ((OutputStream)fOut).close();
            return true;
        }
        catch (Exception e) {
            Debug.warning("Unable to Save File: " + aFileName, e);
            return false;
        }
    }

    public static boolean save(String aFileName, String aContent) {
        return Resource.save(aFileName, aContent.getBytes());
    }

    public static boolean saveXML(String aFileName, String aContent) {
        try {
            return Resource.save(aFileName, aContent.getBytes(Document.parseEncoding(aContent)));
        }
        catch (Exception e) {
            Debug.warning("Unable to Save XML File: " + aFileName, e);
            return false;
        }
    }

    public static String readXML(String aResourceLocation) {
        return Resource.readXML(aResourceLocation, null);
    }

    public static String readXML(String aResourceLocation, Class aClass) {
        byte[] byteData = Resource.readBytes(aResourceLocation, aClass);
        if (byteData.length != 0) {
            try {
                return new String(byteData, Document.parseEncoding(byteData));
            }
            catch (UnsupportedEncodingException e) {
                Debug.warning("encoding issue..", e);
            }
        }
        return new String(byteData);
    }

    public static byte[] readBytes(String aResourceLocation) {
        return Resource.readBytes(aResourceLocation, null);
    }

    public static byte[] readBytes(String aResourceLocation, Class aClass) {
        try {
            InputStream in = Resource.getInputStream(aClass, aResourceLocation);
            byte[] data = new byte[2048];
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            int count = 0;
            while ((count = in.read(data)) != -1) {
                bOut.write(data, 0, count);
            }
            data = bOut.toByteArray();
            bOut.close();
            in.close();
            return data;
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    private static InputStream getInputStream(Class aClass, String aResourceLocation) throws IOException {
        InputStream in;
        if (aClass == null) {
            Class clazz = aClass = class$com$sun$portal$rewriter$util$Resource == null ? (class$com$sun$portal$rewriter$util$Resource = Resource.class$("com.sun.portal.rewriter.util.Resource")) : class$com$sun$portal$rewriter$util$Resource;
        }
        if ((in = aClass.getResourceAsStream(aResourceLocation)) == null) {
            try {
                in = new FileInputStream(aResourceLocation);
            }
            catch (FileNotFoundException e) {
                String directoryURL = aClass.getProtectionDomain().getCodeSource().getLocation().toString();
                String fileURL = directoryURL + aResourceLocation;
                URL url = new URL(fileURL);
                in = url.openStream();
            }
        }
        if (in != null) {
            return in;
        }
        Debug.warning("Unable to read the resource : " + aResourceLocation + " \nUsing ClassLoader: " + aClass.getName());
        throw new FileNotFoundException("Resource Name: " + aResourceLocation);
    }

    public static void main(String[] args) {
        System.out.println(Resource.read(args[0]));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

