/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.js;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.js.JSDataRule;
import com.sun.portal.rewriter.rom.js.Variable;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Node;

public final class VariableRule
extends JSDataRule {
    public static final int ANY = 0;
    private final Variable variable;

    public VariableRule(Variable aVariable) {
        super(aVariable);
        this.variable = aVariable;
    }

    public VariableRule(Node aNode) {
        this(VariableRule.createVariable(aNode));
    }

    private static Variable createVariable(Node aNode) {
        String varName = aNode.getAttributeValue("name");
        if (StringHelper.normalize(varName).length() == 0) {
            varName = aNode.getPCData();
        }
        return new Variable(varName, aNode.getAttributeValue("type"), aNode.getAttributeValue("source"));
    }

    public Variable getVariable() {
        return this.variable;
    }

    public boolean plugableMatch(Data aMache) {
        if (!(aMache instanceof Variable)) {
            return false;
        }
        Variable valueObject = (Variable)aMache;
        if (valueObject.getTypeCode() == 0) {
            return this.matchCommon(valueObject);
        }
        if (this.variable.getTypeCode() == valueObject.getTypeCode()) {
            return this.matchCommon(valueObject);
        }
        return false;
    }

    public boolean isValid() {
        return VariableRule.doBasicValidation(new String[]{this.variable.getName()});
    }

    public static void main(String[] args) {
        VariableRule[] variables = SampleRuleObjects.defaultJSVariables;
        for (int i = 0; i < variables.length; ++i) {
            Debug.println(variables[i].toXML());
        }
    }
}

