/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js.parser;

import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.js.JSRewriter;
import com.sun.portal.rewriter.engines.js.parser.JavaScriptException;
import com.sun.portal.rewriter.engines.js.parser.LineBuffer;
import com.sun.portal.rewriter.engines.js.parser.TokenStream;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetHelper;
import com.sun.portal.rewriter.rom.js.Function;
import com.sun.portal.rewriter.rom.js.FunctionRule;
import com.sun.portal.rewriter.rom.js.Variable;
import com.sun.portal.rewriter.rom.js.VariableRule;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import java.io.IOException;

public final class JSParser {
    public static final String PROPERTY_IS_REWRITE_VARS_IN_DHTML = "IS_REWRITE_VARS_IN_DHTML";
    private static final boolean REWRITE_VARS_IN_DHTML = ConfigManager.getBoolean("IS_REWRITE_VARS_IN_DHTML", true);
    private final Function functionMatche;
    private final Variable variableMatche;
    private final PageContent pageContent;
    private final RuleSet ruleSet;
    private final Translator translator;
    private final StringBuffer resultBuffer;
    private final LineBuffer lineBuffer;
    private final TokenStream tokenStream;
    private final JSRewriter jsRewriter;
    private int lastExprEndLine;
    private boolean ok;
    private static final boolean implementsCatchCond = false;

    public JSParser(PageContent aPageContent, RuleSet aRuleSet, Translator aTranslator, JSRewriter aJSRewriter) {
        this.pageContent = aPageContent;
        this.ruleSet = aRuleSet;
        this.translator = aTranslator;
        this.jsRewriter = aJSRewriter;
        this.resultBuffer = this.pageContent.getResultBuffer();
        this.lineBuffer = new LineBuffer(aPageContent, this.translator.getPageSpec().getInputString());
        this.tokenStream = new TokenStream(this.lineBuffer);
        String source = aTranslator.getPageSpec().getPageURI().getFullFileURI();
        this.functionMatche = new Function("xxyyzz", null, null, source);
        this.variableMatche = new Variable("xxyyzz", null, source);
    }

    private void mustMatchToken(int toMatch, String messageId) throws IOException, JavaScriptException {
        int tt = this.tokenStream.getToken();
        if (tt != toMatch) {
            this.reportError(messageId);
            this.tokenStream.ungetToken(tt);
        }
    }

    private void reportError(String messageId) throws JavaScriptException {
        String message = messageId;
        if (this.ok) {
            this.ok = false;
            if ((this.tokenStream.flags & 1) == 0) {
                message = JSParser.getMessage(messageId, null);
            }
        }
        throw new JavaScriptException(message, this.lineBuffer);
    }

    public void parse() {
        try {
            this.ok = true;
            while (this.ok) {
                this.tokenStream.flags |= 0x200;
                int tt = this.tokenStream.getToken();
                this.tokenStream.flags &= 0xFFFFFDFF;
                if (tt > 0) {
                    if (tt == 109) {
                        try {
                            this.function();
                            this.wellTerminated(109);
                        }
                        catch (JavaScriptException e) {
                            this.ok = false;
                            JSParser.recordWarning(e);
                        }
                        continue;
                    }
                    this.tokenStream.ungetToken(tt);
                    this.statement();
                    continue;
                }
                break;
            }
        }
        catch (JavaScriptException je) {
            JSParser.recordWarning(je);
        }
        catch (IOException e) {
            this.pageContent.enableExceptionFlag();
            Debug.error("Bug in JSParser", e);
        }
        try {
            this.lineBuffer.readRemaining();
        }
        catch (Exception e) {
            this.pageContent.enableExceptionFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFunctionBody() throws IOException, JavaScriptException {
        int oldflags = this.tokenStream.flags;
        this.tokenStream.flags &= 0xFFFFFFCF;
        this.tokenStream.flags |= 8;
        try {
            this.statements();
        }
        finally {
            this.tokenStream.flags = oldflags;
        }
    }

    private void function() throws IOException, JavaScriptException {
        if (this.tokenStream.matchesToken(44)) {
            while (this.tokenStream.matchesToken(107) && this.tokenStream.matchesToken(44)) {
            }
        }
        this.mustMatchToken(93, "msg.no.paren.parms");
        if (!this.tokenStream.matchesToken(94)) {
            do {
                this.mustMatchToken(44, "msg.no.parm");
            } while (this.tokenStream.matchesToken(95));
            this.mustMatchToken(94, "msg.no.paren.after.parms");
        }
        this.mustMatchToken(91, "msg.no.brace.body");
        this.parseFunctionBody();
        this.mustMatchToken(92, "msg.no.brace.after.body");
    }

    private void statements() throws IOException, JavaScriptException {
        int tt;
        while ((tt = this.tokenStream.peekToken()) > 0 && tt != 92) {
            this.statement();
        }
    }

    private void condition() throws IOException, JavaScriptException {
        this.mustMatchToken(93, "msg.no.paren.cond");
        this.expr(false);
        this.mustMatchToken(94, "msg.no.paren.after.cond");
    }

    private boolean wellTerminated(int lastExprType) throws IOException, JavaScriptException {
        int tt = this.tokenStream.peekTokenSameLine();
        if (tt == -1) {
            this.reportError("msg.scanner.caught.error");
            return false;
        }
        if (tt != 0 && tt != 1 && tt != 88 && tt != 92) {
            if (tt == 109 || lastExprType == 109) {
                return true;
            }
            this.reportError("msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel() throws IOException, JavaScriptException {
        String label = null;
        int tt = this.tokenStream.peekTokenSameLine();
        if (tt == 44) {
            this.tokenStream.getToken();
            label = this.tokenStream.getString();
        }
        return label;
    }

    private void statement() throws IOException, JavaScriptException {
        try {
            this.statementHelper();
        }
        catch (JavaScriptException e) {
            int t;
            JSParser.recordWarning(e);
            while ((t = this.tokenStream.getToken()) != 88 && t != 1 && t != 0 && t != -1) {
            }
        }
    }

    private void statementHelper() throws IOException, JavaScriptException {
        int lastExprType = 0;
        int tt = this.tokenStream.getToken();
        switch (tt) {
            case 112: {
                this.condition();
                this.statement();
                if (!this.tokenStream.matchesToken(113)) break;
                this.statement();
                break;
            }
            case 114: {
                this.mustMatchToken(93, "msg.no.paren.switch");
                this.expr(false);
                this.mustMatchToken(94, "msg.no.paren.after.switch");
                this.mustMatchToken(91, "msg.no.brace.switch");
                while ((tt = this.tokenStream.getToken()) != 92 && tt != 0) {
                    switch (tt) {
                        case 115: {
                            this.expr(false);
                            break;
                        }
                        case 116: {
                            break;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(98, "msg.no.colon.case");
                    while ((tt = this.tokenStream.peekToken()) != 92 && tt != 115 && tt != 116 && tt != 0) {
                        this.statement();
                    }
                }
                break;
            }
            case 117: {
                this.condition();
                this.statement();
                break;
            }
            case 118: {
                this.statement();
                this.mustMatchToken(117, "msg.no.while.do");
                this.condition();
                break;
            }
            case 119: {
                this.mustMatchToken(93, "msg.no.paren.for");
                tt = this.tokenStream.peekToken();
                if (tt != 88) {
                    if (tt == 122) {
                        this.tokenStream.getToken();
                        this.variables(true);
                    } else {
                        this.expr(true);
                    }
                }
                if ((tt = this.tokenStream.peekToken()) == 102 && this.tokenStream.getOp() == 63) {
                    this.tokenStream.matchesToken(102);
                    this.expr(false);
                } else {
                    this.mustMatchToken(88, "msg.no.semi.for");
                    if (this.tokenStream.peekToken() != 88) {
                        this.expr(false);
                    }
                    this.mustMatchToken(88, "msg.no.semi.for.cond");
                    if (this.tokenStream.peekToken() != 94) {
                        this.expr(false);
                    }
                }
                this.mustMatchToken(94, "msg.no.paren.for.ctrl");
                this.statement();
                break;
            }
            case 75: {
                this.statement();
                int peek = this.tokenStream.peekToken();
                if (peek == 124) {
                    while (this.tokenStream.matchesToken(124)) {
                        this.mustMatchToken(93, "msg.no.paren.catch");
                        this.mustMatchToken(44, "msg.bad.catchcond");
                        this.mustMatchToken(94, "msg.bad.catchcond");
                        this.mustMatchToken(91, "msg.no.brace.catchblock");
                        this.statements();
                        this.tokenStream.matchesToken(92);
                    }
                } else if (peek != 125) {
                    this.mustMatchToken(125, "msg.try.no.catchfinally");
                }
                if (!this.tokenStream.matchesToken(125)) break;
                this.statement();
                break;
            }
            case 62: {
                int lineno = this.tokenStream.getLineNo();
                this.expr(false);
                if (lineno != this.tokenStream.getLineNo()) break;
                this.wellTerminated(-1);
                break;
            }
            case 120: {
                this.matchLabel();
                break;
            }
            case 121: {
                this.matchLabel();
                break;
            }
            case 123: {
                this.mustMatchToken(93, "msg.no.paren.with");
                this.expr(false);
                this.mustMatchToken(94, "msg.no.paren.after.with");
                this.statement();
                break;
            }
            case 122: {
                this.variables(false);
                break;
            }
            case 5: {
                this.tokenStream.flags |= 0x200;
                tt = this.tokenStream.peekTokenSameLine();
                this.tokenStream.flags &= 0xFFFFFDFF;
                if (tt != 0 && tt != 1 && tt != 88 && tt != 92) {
                    this.expr(false);
                    this.tokenStream.flags |= 0x10;
                    break;
                }
                this.tokenStream.flags |= 0x20;
                break;
            }
            case 91: {
                this.statements();
                this.mustMatchToken(92, "msg.no.brace.block");
                break;
            }
            case -1: {
                this.reportError("msg.scanner.caught.error");
            }
            case 1: 
            case 88: {
                break;
            }
            default: {
                lastExprType = tt;
                int tokenno = this.tokenStream.getTokenNo();
                this.tokenStream.ungetToken(tt);
                this.expr(false);
                if (this.tokenStream.peekToken() == 98) {
                    if (lastExprType != 44 || this.tokenStream.getTokenNo() != tokenno) {
                        this.reportError("msg.bad.label");
                    }
                    this.tokenStream.getToken();
                    return;
                }
                int tmpToken = this.tokenStream.getToken();
                this.tokenStream.ungetToken(tmpToken);
                if (lastExprType != 109 || this.tokenStream.getLineNo() != this.lastExprEndLine) break;
                this.wellTerminated(lastExprType);
                break;
            }
        }
        this.tokenStream.matchesToken(88);
    }

    private void variables(boolean inForInit) throws IOException, JavaScriptException {
        do {
            this.mustMatchToken(44, "msg.bad.var");
            this.handleVariableMatch(this.tokenStream.getString(), inForInit, false);
        } while (this.tokenStream.matchesToken(95));
    }

    private void expr(boolean inForInit) throws IOException, JavaScriptException {
        this.assignExpr(inForInit, 0);
        while (this.tokenStream.matchesToken(95)) {
            this.assignExpr(inForInit, 0);
        }
    }

    private void assignExpr(boolean inForInit, int aType) throws IOException, JavaScriptException {
        StringBuffer vname = new StringBuffer();
        this.condExpr(inForInit, vname, aType);
        this.handleVariableMatch(vname.toString(), inForInit, false);
    }

    private void condExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.orExpr(inForInit, vname, aType);
        if (this.tokenStream.matchesToken(97)) {
            this.assignExpr(false, aType);
            this.mustMatchToken(98, "msg.no.colon.cond");
            this.assignExpr(inForInit, aType);
        }
    }

    private void orExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.andExpr(inForInit, vname, aType);
        if (this.tokenStream.matchesToken(99)) {
            this.orExpr(inForInit, null, 0);
        }
    }

    private void andExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.bitOrExpr(inForInit, vname, aType);
        if (this.tokenStream.matchesToken(100)) {
            this.andExpr(inForInit, null, 0);
        }
    }

    private void bitOrExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.bitXorExpr(inForInit, vname, aType);
        while (this.tokenStream.matchesToken(11)) {
            this.bitXorExpr(inForInit, null, 0);
        }
    }

    private void bitXorExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.bitAndExpr(inForInit, vname, aType);
        while (this.tokenStream.matchesToken(12)) {
            this.bitAndExpr(inForInit, null, 0);
        }
    }

    private void bitAndExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.eqExpr(inForInit, vname, aType);
        while (this.tokenStream.matchesToken(13)) {
            this.eqExpr(inForInit, null, 0);
        }
    }

    private void eqExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.relExpr(inForInit, vname, aType);
        while (this.tokenStream.matchesToken(101)) {
            this.relExpr(inForInit, null, 0);
        }
    }

    private void relExpr(boolean inForInit, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.shiftExpr(vname, aType);
        while (this.tokenStream.matchesToken(102)) {
            int op = this.tokenStream.getOp();
            if (inForInit && op == 63) {
                this.tokenStream.ungetToken(102);
                break;
            }
            this.shiftExpr(null, 0);
        }
    }

    private void shiftExpr(StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.addExpr(vname, aType);
        while (this.tokenStream.matchesToken(103)) {
            this.addExpr(null, 0);
        }
    }

    private void addExpr(StringBuffer vname, int aType) throws IOException, JavaScriptException {
        int tt;
        this.mulExpr(vname, aType);
        while ((tt = this.tokenStream.getToken()) == 23 || tt == 24) {
            if (tt == 24 || aType == 1) {
                this.mulExpr(null, 0);
                continue;
            }
            this.mulExpr(null, aType);
        }
        this.tokenStream.ungetToken(tt);
    }

    private void mulExpr(StringBuffer vname, int aType) throws IOException, JavaScriptException {
        int tt;
        this.unaryExpr(vname, aType);
        while ((tt = this.tokenStream.peekToken()) == 25 || tt == 26 || tt == 27) {
            this.tokenStream.getToken();
            this.unaryExpr(null, 0);
        }
    }

    private void unaryExpr(StringBuffer vname, int aType) throws IOException, JavaScriptException {
        this.tokenStream.flags |= 0x200;
        int tt = this.tokenStream.getToken();
        this.tokenStream.flags &= 0xFFFFFDFF;
        switch (tt) {
            case 104: {
                this.unaryExpr(vname, 0);
                return;
            }
            case 23: 
            case 24: {
                this.unaryExpr(null, 0);
                return;
            }
            case 105: 
            case 106: {
                this.memberExpr(true, vname, 0);
                return;
            }
            case 31: {
                this.unaryExpr(null, 0);
                return;
            }
            case -1: {
                this.reportError("msg.scanner.caught.error");
                break;
            }
            default: {
                this.tokenStream.ungetToken(tt);
                this.memberExpr(true, vname, aType);
                tt = this.tokenStream.peekToken();
                if (!this.tokenStream.matchesToken(105)) {
                    this.tokenStream.matchesToken(106);
                }
                return;
            }
        }
    }

    private void argumentList(String fname) throws IOException, JavaScriptException {
        this.tokenStream.flags |= 0x200;
        boolean matched = this.tokenStream.matchesToken(94);
        this.tokenStream.flags &= 0xFFFFFDFF;
        if (!matched) {
            FunctionRule f = this.findFunctionMatch(fname, 10);
            if (f == null) {
                do {
                    this.assignExpr(false, 0);
                } while (this.tokenStream.matchesToken(95));
            } else {
                String[] bParamSpec = f.getParamSpec(10);
                int bType = f.getFunction().getTypeCode();
                int argCount = 0;
                do {
                    if (bParamSpec[argCount].equalsIgnoreCase("y")) {
                        if (bType == 2 || bType == 5) {
                            this.handleExpression(bType);
                        } else {
                            this.assignExpr(false, bType);
                        }
                    } else {
                        this.assignExpr(false, 0);
                    }
                    ++argCount;
                } while (this.tokenStream.matchesToken(95));
            }
            this.mustMatchToken(94, "msg.no.paren.arg");
        }
    }

    private void memberExpr(boolean allowCallSyntax, StringBuffer vname, int aType) throws IOException, JavaScriptException {
        StringBuffer lFunName = new StringBuffer();
        boolean lFuncNameSupported = true;
        this.tokenStream.flags |= 0x200;
        int tt = this.tokenStream.peekToken();
        this.tokenStream.flags &= 0xFFFFFDFF;
        if (tt == 30) {
            this.tokenStream.getToken();
            StringBuffer obj_name = new StringBuffer();
            this.memberExpr(false, obj_name, 0);
            if (this.tokenStream.matchesToken(93)) {
                this.argumentList(obj_name.toString());
            }
        } else {
            this.primaryExpr(lFunName, aType);
        }
        int mark = this.tokenStream.getMark() - lFunName.length();
        this.lastExprEndLine = this.tokenStream.getLineNo();
        boolean isVariable = true;
        while ((tt = this.tokenStream.getToken()) > 0) {
            if (tt == 107) {
                isVariable = true;
                this.mustMatchToken(44, "msg.no.name.after.dot");
                lFunName.append(".").append(this.tokenStream.getString());
                this.lastExprEndLine = this.tokenStream.getLineNo();
                continue;
            }
            if (tt == 89) {
                lFuncNameSupported = false;
                this.expr(false);
                this.mustMatchToken(90, "msg.no.bracket.index");
                this.lastExprEndLine = this.tokenStream.getLineNo();
                continue;
            }
            if (allowCallSyntax && tt == 93) {
                isVariable = false;
                String ss = lFuncNameSupported ? lFunName.toString() : null;
                this.argumentList(ss);
                this.lastExprEndLine = this.tokenStream.getLineNo();
                continue;
            }
            this.tokenStream.ungetToken(tt);
            break;
        }
        if (tt == -1) {
            this.reportError("msg.scanner.caught.error");
            return;
        }
        if ((allowCallSyntax || isVariable) && vname != null) {
            vname.append(lFunName.toString());
        }
        int nextToken = this.tokenStream.peekToken();
        if (nextToken != 96 && isVariable && lFunName.toString().trim().length() > 0) {
            VariableRule bMatch = RuleSetHelper.findJSSystemVariableMatch(this.ruleSet, this.variableMatche.recycleMatchee(lFunName.toString(), 7));
            if (bMatch != null) {
                this.handleVariableToken(mark, 7);
            } else if (REWRITE_VARS_IN_DHTML && aType == 4 && (bMatch = RuleSetHelper.findJSNonSystemVariableMatch(this.ruleSet, this.variableMatche.recycleMatchee(lFunName.toString(), 2))) != null) {
                this.handleVariableToken(mark, 2);
            }
        }
    }

    private void primaryExpr(StringBuffer fname, int aType) throws IOException, JavaScriptException {
        this.tokenStream.flags |= 0x200;
        int tt = this.tokenStream.getToken();
        this.tokenStream.flags &= 0xFFFFFDFF;
        switch (tt) {
            case 109: {
                this.function();
                return;
            }
            case 89: {
                this.tokenStream.flags |= 0x200;
                boolean matched = this.tokenStream.matchesToken(90);
                this.tokenStream.flags &= 0xFFFFFDFF;
                if (!matched) {
                    do {
                        this.tokenStream.flags |= 0x200;
                        tt = this.tokenStream.peekToken();
                        this.tokenStream.flags &= 0xFFFFFDFF;
                        if (tt == 90) break;
                        if (tt == 95) continue;
                        this.assignExpr(false, 0);
                    } while (this.tokenStream.matchesToken(95));
                    this.mustMatchToken(90, "msg.no.bracket.arg");
                }
                return;
            }
            case 91: {
                if (!this.tokenStream.matchesToken(92)) {
                    block18: do {
                        tt = this.tokenStream.getToken();
                        switch (tt) {
                            case 44: 
                            case 45: 
                            case 46: {
                                break;
                            }
                            case 92: {
                                this.tokenStream.ungetToken(tt);
                                break block18;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block18;
                            }
                        }
                        this.mustMatchToken(98, "msg.no.colon.prop");
                        this.handleVariableMatch(this.tokenStream.getString(), false, true);
                    } while (this.tokenStream.matchesToken(95));
                    this.mustMatchToken(92, "msg.no.brace.prop");
                }
                return;
            }
            case 93: {
                this.expr(false);
                this.mustMatchToken(94, "msg.no.paren");
                return;
            }
            case 44: {
                String name = this.tokenStream.getString();
                fname.append(name);
                return;
            }
            case 45: {
                return;
            }
            case 46: {
                if (aType != 0) {
                    this.handleStringTokens(aType);
                }
                return;
            }
            case 56: {
                return;
            }
            case 108: {
                String primaryStr = this.tokenStream.getString();
                if (primaryStr.equals("this") || primaryStr.equals("super")) {
                    fname.append(primaryStr);
                }
                return;
            }
            case 126: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                this.reportError("msg.scanner.caught.error");
                break;
            }
            default: {
                if (tt == 102) {
                    return;
                }
                this.reportError("msg.syntax");
            }
        }
    }

    private void handleVariableMatch(String aVariableName, boolean inForInit, boolean isObjectProperty) throws IOException, JavaScriptException {
        if (isObjectProperty || this.tokenStream.matchesToken(96)) {
            int aType = 0;
            VariableRule v = this.findVariableMatch(aVariableName);
            if (v != null) {
                aType = v.getVariable().getTypeCode();
                if ((aType == 1 || aType == 2) && this.tokenStream.getOp() != 127) {
                    this.assignExpr(inForInit, 0);
                    return;
                }
                if (aType == 2 || aType == 5) {
                    this.handleExpression(aType);
                    return;
                }
            }
            this.assignExpr(inForInit, aType);
        }
    }

    private VariableRule findVariableMatch(String aVariableName) {
        if (aVariableName == null || aVariableName.length() == 0) {
            return null;
        }
        return RuleSetHelper.findJSNonSystemVariableMatch(this.ruleSet, this.variableMatche.recycleMatchee(aVariableName, 0));
    }

    private FunctionRule findFunctionMatch(String aFunctionName, int aParamCount) {
        if (aFunctionName == null || aFunctionName.length() == 0) {
            return null;
        }
        return RuleSetHelper.findJSFunctionMatch(this.ruleSet, this.functionMatche.recycleMatchee(aFunctionName, aParamCount));
    }

    private void handleVariableToken(int mark, int aType) {
        int mark2 = this.tokenStream.getMark();
        this.doRewrite(mark, mark2, aType);
    }

    private void doRewrite(int aMark1, int aMark2, int aType) {
        String value2Rewrite;
        String rewrittenContent = value2Rewrite = this.resultBuffer.substring(aMark1, aMark2);
        if (value2Rewrite.trim().length() != 0) {
            rewrittenContent = this.rewriteByType(value2Rewrite, aType);
            this.resultBuffer.replace(aMark1, aMark2, rewrittenContent);
        }
        this.tokenStream.updateMark(aMark2 + rewrittenContent.length() - value2Rewrite.length());
    }

    private void handleExpression(int aType) throws IOException, JavaScriptException {
        int mark1 = this.tokenStream.getMark();
        this.assignExpr(false, 0);
        int mark2 = this.tokenStream.getMark();
        this.doRewrite(mark1, mark2, aType);
    }

    private void handleStringTokens(int aType) {
        int[] spec = this.tokenStream.getStringSpec();
        String value2Rewrite = this.resultBuffer.substring(spec[4], spec[5]);
        if (spec[2] > spec[0]) {
            value2Rewrite = StringHelper.searchAndReplace(value2Rewrite, "\\\n", "");
        }
        this.resultBuffer.replace(spec[4], spec[5], this.rewriteByType(value2Rewrite, aType));
    }

    private final String rewriteByType(String aValue2Rewrite, int aType) {
        String trimmedValue = aValue2Rewrite.trim();
        if (trimmedValue.length() == 0) {
            return aValue2Rewrite;
        }
        switch (aType) {
            case 1: {
                return this.jsRewriter.translateURL(aValue2Rewrite, this.translator);
            }
            case 2: {
                return this.jsRewriter.translateEXPRESSION(aValue2Rewrite, this.translator);
            }
            case 4: {
                return this.jsRewriter.translateDHTML(aValue2Rewrite, this.translator);
            }
            case 5: {
                return this.jsRewriter.translateDJS(aValue2Rewrite, this.translator);
            }
            case 7: {
                return this.jsRewriter.translateSYSTEM(aValue2Rewrite, this.translator);
            }
        }
        return null;
    }

    static String getMessage(String aMessageID, Object[] aArgs) {
        return "JavaScript compile error: id = " + aMessageID + ", args = " + aArgs;
    }

    public static void recordWarning(JavaScriptException e) {
        if (Debug.isWarningEnabled()) {
            Debug.recordOriginalPageWarning("Unable to Translate JS:", e);
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

