/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.QueryStringParser;
import java.io.BufferedReader;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletHTTPRequest
implements HttpServletRequest {
    private HTTPRequest req = null;
    private String _crlf = new String(new byte[]{13, 10});
    private char lf = (char)10;
    private boolean _firstLine = true;
    private boolean _headerComplete = false;
    private List _headerLines = new ArrayList();
    private String _httpVersion = "";
    private String _method = null;
    private String _path = "";
    private HashMap headerMap = new HashMap();

    public ServletHTTPRequest(HTTPRequest req) {
        this.req = req;
        this.parseHeaders(new String(req.getRequestHeaderBytes()));
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object value) {
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        throw new UnsupportedOperationException("getContextPath() not supported");
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException("getDateHeader() not supported");
    }

    public String getHeader(String header) {
        return this.req.getRequestHeader(header);
    }

    public Enumeration getHeaderNames() {
        Vector<String> headers = new Vector<String>();
        int numHeaders = this._headerLines.size();
        for (int i = 0; i < numHeaders; ++i) {
            String s = (String)this._headerLines.get(i);
            int headerOffset = s.indexOf(58);
            headers.add(headerOffset == -1 ? s : s.substring(0, headerOffset).trim());
        }
        return headers.elements();
    }

    public Enumeration getHeaders(String header) {
        Vector<String> headers = new Vector<String>();
        int headerLen = header.length();
        int numHeaders = this._headerLines.size();
        for (int i = 0; i < numHeaders; ++i) {
            String s = (String)this._headerLines.get(i);
            if (!s.regionMatches(true, 0, header, 0, headerLen)) continue;
            int headerOffset = s.indexOf(58);
            headers.add(headerOffset == -1 ? s : s.substring(0, headerOffset).trim());
        }
        return headers.elements();
    }

    public int getIntHeader(String name) {
        String value = this.headerMap.get(name).toString();
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public String getMethod() {
        return this._method;
    }

    public String getPathInfo() {
        throw new UnsupportedOperationException("getPathInfo() not supported");
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("getPathTranslated() not supported");
    }

    public String getQueryString() {
        String URI2 = this.getRequestURI();
        int queryIndex = URI2.indexOf("?");
        if (queryIndex == -1) {
            return null;
        }
        return URI2.substring(queryIndex + 1);
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException("getRemoteUser() not supported");
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("getRequestedSessionId() not supported");
    }

    public String getRequestURI() {
        String decodedPath = URLDecoder.decode(this._path);
        return decodedPath;
    }

    public String getServletPath() {
        throw new UnsupportedOperationException("getServletPath() not supported");
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("getSession() not supported");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("getSession() not supported");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("getUserPrincipal() not supported");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromCookie() not supported");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromUrl() not supported");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("isRequestedSessionIdFromURL() not supported");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("isRequestedSessionIdValid() not supported");
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException("isUserInRole() not supported");
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        return 0;
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException("getInputStream() not supported");
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return new Vector().elements();
    }

    public String getParameter(String name) {
        QueryStringParser qP = new QueryStringParser(this.getQueryString());
        Map map = qP.getParamMap();
        Object param = map.get(name);
        if (param == null) {
            return null;
        }
        return param.toString();
    }

    public Enumeration getParameterNames() {
        return new Vector().elements();
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public String getProtocol() {
        return this._httpVersion;
    }

    public BufferedReader getReader() {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return -1;
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException("isSecure() not supported");
    }

    public String getContentType() {
        return null;
    }

    private void addHeaderLine(String s) {
        if (this._firstLine) {
            if (s.equals(this._crlf)) {
                return;
            }
            int strLength = s.length();
            if (strLength > 0) {
                if (!s.endsWith(this._crlf)) {
                    s = s.substring(0, strLength - 1) + this._crlf;
                }
                if (s.startsWith(this._crlf)) {
                    s = s.substring(2);
                } else if (s.charAt(0) == this.lf) {
                    s = s.substring(1);
                }
                if (s.equals(this._crlf)) {
                    return;
                }
                this._firstLine = false;
                StringTokenizer st = new StringTokenizer(s);
                this._method = st.nextToken();
                this._path = st.nextToken();
                try {
                    this._httpVersion = st.nextToken();
                }
                catch (NoSuchElementException ex) {
                    this._httpVersion = "HTTP/0.9";
                    this._headerComplete = true;
                }
            }
        } else {
            int strLength = s.length();
            if (!s.endsWith(this._crlf) && strLength > 0) {
                int colIndex = (s = s.substring(0, strLength - 1) + this._crlf).indexOf(":");
                if (colIndex != -1) {
                    String name = s.substring(0, colIndex);
                    String value = s.substring(colIndex + 1, s.length());
                    this.headerMap.put(name.trim(), value.trim());
                } else {
                    this.headerMap.put(s.trim(), null);
                }
            }
            if (s.equals(this._crlf)) {
                this._headerComplete = true;
            } else {
                this._headerLines.add(s);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this._headerLines.iterator();
        sb.append(this._method).append(" ").append(this._path).append(" ").append(this._httpVersion).append("\r\n");
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    private void parseHeaders(String headers) {
        StringTokenizer stz = new StringTokenizer(headers, "\n");
        while (stz.hasMoreElements()) {
            this.addHeaderLine(stz.nextToken());
        }
    }
}

