/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.InternalCookie;
import com.sun.portal.util.GWDebug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class CookieList {
    private Hashtable existingCookies = new Hashtable();
    private long time = System.currentTimeMillis() / 1000L;
    private String encodedValue = "";
    private boolean hasBeenModified = false;

    public CookieList() {
    }

    public CookieList(String encodedCookieList) {
        this();
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("encodedCookieList : " + encodedCookieList);
        }
        this.encodedValue = encodedCookieList;
        StringTokenizer st = new StringTokenizer(encodedCookieList, "|");
        while (st.hasMoreTokens()) {
            InternalCookie internalCookie;
            String cookie = st.nextToken();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("CookieList : cookie " + cookie);
            }
            if ((internalCookie = new InternalCookie(cookie)).shouldRemove()) {
                this.hasBeenModified = true;
                this.encodedValue = null;
                continue;
            }
            this.existingCookies.put(internalCookie.getName(), internalCookie);
        }
    }

    public void processCookie(String cookie, String host) {
        InternalCookie intCookie = new InternalCookie(cookie, host, this.time);
        String name = intCookie.getName();
        InternalCookie tableValue = (InternalCookie)this.existingCookies.get(name);
        if (tableValue == null) {
            if (intCookie.shouldRemove()) {
                return;
            }
        } else if (intCookie.shouldRemove()) {
            this.existingCookies.remove(name);
            this.hasBeenModified = true;
            this.encodedValue = null;
            return;
        }
        this.hasBeenModified = true;
        this.encodedValue = null;
        this.existingCookies.put(name, intCookie);
    }

    public boolean isModified() {
        return this.hasBeenModified;
    }

    public int length() {
        return this.existingCookies.size();
    }

    public Enumeration enumerate() {
        return this.existingCookies.elements();
    }

    public String getEncodedValue() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        Set keys = this.existingCookies.keySet();
        Iterator iter = keys.iterator();
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        while (iter.hasNext()) {
            String name = iter.next().toString();
            InternalCookie intCookie = (InternalCookie)this.existingCookies.get(name);
            if (isFirst) {
                sb.append(intCookie.getEncodedValue());
                isFirst = false;
                continue;
            }
            sb.append(" | ").append(intCookie.getEncodedValue());
        }
        this.encodedValue = sb.toString();
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("encodedValue : " + this.encodedValue);
        }
        return this.encodedValue;
    }
}

