/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.ServerCertApprovalCallback;
import com.sun.portal.util.SystemProperties;
import java.net.InetAddress;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

public class CachedSSLSocketFactory {
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    private static int _timeout = GatewayProfile.getInt("BlockedSocketTimeout", 200000);

    public static CachedSocket createSocket(String host, int port, String socketType, Integer logId, ServerCertApprovalCallback approvalCB) {
        CachedSocket cachedSocket;
        block14: {
            SSLSocket sslSocket;
            block13: {
                cachedSocket = null;
                sslSocket = null;
                try {
                    sslSocket = approvalCB == null ? new SSLSocket(host, port) : new SSLSocket(InetAddress.getByName(host), port, null, 0, (SSLCertificateApprovalCallback)approvalCB, null);
                }
                catch (Exception se) {
                    String retryTimes;
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("CachedSSLSocketFactory cannot open connection to " + host + ":" + port, se);
                    }
                    if ((retryTimes = SystemProperties.get("gateway.sockretries")) == null) {
                        return null;
                    }
                    int retries = Integer.parseInt(retryTimes);
                    for (int i = 1; i <= retries; ++i) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        try {
                            if (GWDebug.debug.warningEnabled()) {
                                GWDebug.debug.warning("CachedSSLSocketFactory: Open new socket; retry #" + i);
                            }
                            if ((sslSocket = approvalCB == null ? new SSLSocket(host, port) : new SSLSocket(InetAddress.getByName(host), port, null, 0, (SSLCertificateApprovalCallback)approvalCB, null)) == null) continue;
                            break;
                        }
                        catch (Exception rse) {
                            if (!GWDebug.debug.errorEnabled()) continue;
                            GWDebug.debug.error("CachedSSLSocketFactory cannot open connection to " + host + ":" + port, rse);
                        }
                    }
                    if (sslSocket != null) break block13;
                    return null;
                }
            }
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("RProxy", GWLocale.getPFString("csslsf1", new Object[]{logId, host, new Integer(sslSocket.getPort())}));
            }
            try {
                sslSocket.setUseClientMode(true);
                sslSocket.setSoTimeout(_timeout);
                sslSocket.enableSSL2(true);
                sslSocket.enableSSL3(true);
                cachedSocket = new CachedSocket((Socket)sslSocket);
            }
            catch (Exception e) {
                if (!GWDebug.debug.errorEnabled()) break block14;
                GWDebug.debug.error("CachedSSLSocketFactory socket error", e);
            }
        }
        return cachedSocket;
    }
}

