/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.perf.rproxy;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.util.PerfProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketCount {
    private static int numPlainSockets = 0;
    private static int numSSLSockets = 0;
    private static int numServerSockets = 0;
    private static int PERF_PORT;

    private SocketCount() {
    }

    public static synchronized void incrementPlainSockets() {
        ++numPlainSockets;
    }

    public static synchronized void decrementPlainSockets() {
        --numPlainSockets;
    }

    public static int getPlainSockets() {
        return numPlainSockets;
    }

    public static synchronized void incrementSSLSockets() {
        ++numSSLSockets;
    }

    public static synchronized void decrementSSLSockets() {
        --numSSLSockets;
    }

    public static int getSSLSockets() {
        return numSSLSockets;
    }

    public static synchronized void incrementServerSockets() {
        ++numServerSockets;
    }

    public static synchronized void decrementServerSockets() {
        --numServerSockets;
    }

    public static int getServerSockets() {
        return numServerSockets;
    }

    public static synchronized void reset() {
        numPlainSockets = 0;
        numSSLSockets = 0;
        numServerSockets = 0;
    }

    static {
        if (PerfContextObject.ENABLE_PERF) {
            SocketCount inst;
            try {
                PERF_PORT = Integer.parseInt(PerfProperties.get("gateway.perf.serversocket", "12345"));
            }
            catch (Exception ex) {
                PERF_PORT = 12345;
            }
            SocketCount socketCount = inst = new SocketCount();
            socketCount.getClass();
            SocketCountServer servr = socketCount.new SocketCountServer(PERF_PORT);
            Thread thr = new Thread(servr);
            thr.start();
        }
    }

    private class SocketCountServer
    implements Runnable {
        ServerSocket ss = null;

        public SocketCountServer(int ssPort) {
            try {
                this.ss = new ServerSocket(ssPort);
            }
            catch (IOException ex) {
                this.ss = null;
            }
        }

        public void run() {
            while (this.ss != null) {
                try {
                    Socket sock = this.ss.accept();
                    OutputStream outStream = sock.getOutputStream();
                    outStream.write(this.getOutputString().toString().getBytes());
                    outStream.flush();
                    sock.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public StringBuffer getOutputString() {
            StringBuffer sb = new StringBuffer().append("Number of Plain socket : ").append(SocketCount.getPlainSockets()).append("\nNumber of SSL socket : ").append(SocketCount.getSSLSockets()).append("\nNumber of ServerSockets : ").append(SocketCount.getServerSockets()).append('\n');
            return sb;
        }
    }
}

