/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.rom.html;

import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.DataRule;
import com.sun.portal.rewriter.rom.html.Applet;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.xml.Node;

public final class AppletRule
extends DataRule {
    private final Applet applet;
    private final Pattern[] codeSpec;
    private final Pattern[] paramSpec;
    private final Pattern[] valuePatternSpec;

    public AppletRule(Applet aApplet) {
        super(aApplet);
        this.applet = aApplet;
        this.codeSpec = AppletRule.createAttributeSpec(this.applet.getCode());
        this.paramSpec = AppletRule.createAttributeSpec(this.applet.getParam(), true);
        this.valuePatternSpec = AppletRule.createValuePatternSpec(this.applet.getValuePatterns());
    }

    public AppletRule(Node aNode) {
        this(new Applet(aNode.getAttributeValue("code"), aNode.getAttributeValue("param"), aNode.getAttributeValue("valuePatterns"), aNode.getAttributeValue("source")));
    }

    public Pattern[] getParsedPatterns() {
        return this.valuePatternSpec;
    }

    public boolean plugableMatch(Data aMache) {
        if (!(aMache instanceof Applet)) {
            return false;
        }
        Applet valueObject = (Applet)aMache;
        return AppletRule.match(this.codeSpec, valueObject.getCode()) && AppletRule.match(this.paramSpec, valueObject.getParam());
    }

    public boolean isValid() {
        return AppletRule.doBasicValidation(new String[]{this.applet.getSource(), this.applet.getCode(), this.applet.getParam()});
    }

    public static void main(String[] args) {
        AppletRule[] applets = SampleRuleObjects.defaultHTMLApplets;
        for (int i = 0; i < applets.length; ++i) {
            Debug.println(applets[i].toXML());
        }
    }
}

