/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.SRADecoder;
import com.sun.portal.cli.cert.SRADecoderException;
import com.sun.portal.cli.cert.SRAPBEImpl;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CertificateFactory;
import java.util.StringTokenizer;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.primitive.Name;

public class JSSUtil {
    private static SRADecoder defPassDecoder = null;

    public static void setDefaultDecoder(String certdir) throws SRADecoderException {
        if (defPassDecoder == null) {
            defPassDecoder = new SRAPBEImpl(certdir);
            defPassDecoder.init();
        }
    }

    public static SRADecoder getDefaultDecoder() {
        return defPassDecoder;
    }

    public static boolean certExist(JSSContext cntx, String nickname) {
        try {
            cntx.getCryptoManager().findCertByNickname(nickname);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static X509Certificate getCertByNickname(JSSContext cntx, String nickname) throws Exception {
        return cntx.getCryptoManager().findCertByNickname(nickname);
    }

    public static X509Certificate addCertificate(JSSContext cntx, File certfile, String nick, boolean isCACert) throws Exception {
        FileInputStream fis = new FileInputStream(certfile);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.Certificate jcert = cf.generateCertificate(fis);
        byte[] dercert = jcert.getEncoded();
        if (isCACert) {
            return cntx.getCryptoManager().importCACertPackage(dercert);
        }
        return cntx.getCryptoManager().importCertPackage(dercert, nick);
    }

    public static void verifyCertificate(Certificate cert) {
        try {
            cert.verify();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CertAdminUtil.println(CertAdminLocale.getPFString("m49", "Could not verify the certificate!") + CertAdminConstants.newline + ex);
        }
    }

    public static X509Certificate changeCertificateTrust(X509Certificate cert, String ssl, String email, String objsign) throws Exception {
        int ssltrust = JSSUtil.getTrust(ssl);
        int emailtrust = JSSUtil.getTrust(email);
        int objtrust = JSSUtil.getTrust(objsign);
        try {
            InternalCertificate ic = (InternalCertificate)cert;
            ic.setSSLTrust(ssltrust);
            ic.setEmailTrust(emailtrust);
            ic.setObjectSigningTrust(objtrust);
            return ic;
        }
        catch (Exception ex) {
            return cert;
        }
    }

    public static String getTrust(X509Certificate cert) {
        try {
            InternalCertificate ic = (InternalCertificate)cert;
            return JSSUtil.getTrustStr(ic.getSSLTrust(), true) + "," + JSSUtil.getTrustStr(ic.getEmailTrust()) + "," + JSSUtil.getTrustStr(ic.getObjectSigningTrust());
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static int getTrust(String trusttype) {
        char[] trusttokens = new char[trusttype.length()];
        trusttype.getChars(0, trusttype.length(), trusttokens, 0);
        int trustval = 0;
        String truststr = "";
        for (int i = 0; i < trusttokens.length; ++i) {
            int trust;
            truststr = new Character(trusttokens[i]).toString();
            if (truststr.equals("p")) {
                trust = 1;
            } else if (truststr.equals("P")) {
                trust = 2;
            } else if (truststr.equals("c")) {
                trust = 8;
            } else if (truststr.equals("T")) {
                trust = 136;
            } else if (truststr.equals("C")) {
                trust = 24;
            } else if (truststr.equals("u")) {
                trust = 64;
            } else {
                if (!truststr.equals("N")) continue;
                trust = 0;
            }
            if (i == 0) {
                trustval = trust;
                continue;
            }
            trustval |= trust;
        }
        return trustval;
    }

    public static String getTrustStr(int trust) {
        return JSSUtil.getTrustStr(trust, false);
    }

    public static String getTrustStr(int trust, boolean isSSLTrust) {
        boolean isTrustedCA = false;
        boolean isTrustedClientCA = false;
        boolean isTrustedPeer = false;
        String truststr = "";
        if ((0x10 & trust) == 16) {
            truststr = truststr + "C";
            isTrustedCA = true;
        }
        if ((0x80 & trust) == 128) {
            truststr = truststr + "T";
            if (isSSLTrust) {
                isTrustedClientCA = true;
            }
        }
        if ((2 & trust) == 2) {
            truststr = truststr + "P";
            isTrustedPeer = false;
        }
        if ((0x40 & trust) == 64) {
            truststr = truststr + "u";
        }
        if ((8 & trust) == 8 && !isTrustedCA && !isTrustedClientCA) {
            truststr = truststr + "c";
        }
        if ((1 & trust) == 1 && !isTrustedPeer) {
            truststr = truststr + "p";
        }
        return truststr;
    }

    public static String[][] getNameDS(String issuerName) {
        StringTokenizer fields = new StringTokenizer(issuerName, ",");
        int tokens = fields.countTokens();
        String[][] nameDataStructure = new String[tokens][2];
        int i = 0;
        while (fields.hasMoreTokens()) {
            StringTokenizer field = new StringTokenizer(fields.nextToken(), "=");
            if (field.countTokens() == 2) {
                nameDataStructure[i][0] = field.nextToken().trim();
                nameDataStructure[i][1] = field.nextToken().trim();
            }
            ++i;
        }
        return nameDataStructure;
    }

    public static Name getIssuer(String issuerName) throws Exception {
        String[][] nameDS = JSSUtil.getNameDS(issuerName);
        Name issuer = new Name();
        for (int i = nameDS.length - 1; i >= 0; --i) {
            String type = nameDS[i][0];
            String val = nameDS[i][1];
            if (type.equals("C")) {
                issuer.addCountryName(val);
                continue;
            }
            if (type.equals("L")) {
                issuer.addLocalityName(val);
                continue;
            }
            if (type.equals("ST")) {
                issuer.addStateOrProvinceName(val);
                continue;
            }
            if (type.equals("O")) {
                issuer.addOrganizationName(val);
                continue;
            }
            if (type.equals("OU")) {
                issuer.addOrganizationalUnitName(val);
                continue;
            }
            if (!type.equals("CN")) continue;
            issuer.addCommonName(val);
        }
        return issuer;
    }

    public static String getCertWithSubject(CryptoToken tok, Name subject) throws Exception {
        String sub = subject.getRFC1485();
        X509Certificate[] certs = tok.getCryptoStore().getCertificates();
        for (int i = 0; i < certs.length; ++i) {
            X509Certificate x509Cert = certs[i];
            Certificate certificate = (Certificate)ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])x509Cert.getEncoded());
            CertificateInfo cert = certificate.getInfo();
            Name certSubject = cert.getSubject();
            if (!sub.equalsIgnoreCase(certSubject.getRFC1485())) continue;
            return x509Cert.getNickname();
        }
        return null;
    }

    public static Password decryptPassword(String password) throws SRADecoderException {
        return JSSUtil.decryptPassword(JSSUtil.getDefaultDecoder(), password);
    }

    public static String encryptPassword(String password) throws SRADecoderException {
        return JSSUtil.encryptPassword(JSSUtil.getDefaultDecoder(), password);
    }

    public static boolean isPasswordEncrypted(String password) {
        return JSSUtil.isPasswordEncrypted(JSSUtil.getDefaultDecoder(), password);
    }

    public static Password decryptPassword(SRADecoder passDecoder, String password) throws SRADecoderException {
        String encryptedData;
        String decryptedData;
        String newDigest;
        String oldDigest;
        if (password == null) {
            return null;
        }
        Password pass = new Password();
        pass.setEncrypted(false);
        pass.setPassword(password);
        StringTokenizer st = new StringTokenizer(password, " ");
        if (st.countTokens() == 2 && (oldDigest = st.nextToken()).equals(newDigest = passDecoder.digest(decryptedData = passDecoder.decrypt(encryptedData = st.nextToken())))) {
            pass.setEncrypted(true);
            pass.setPassword(decryptedData);
            return pass;
        }
        return pass;
    }

    public static String encryptPassword(SRADecoder passDecoder, String password) throws SRADecoderException {
        if (password == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String encryptedData = passDecoder.encrypt(password);
        String digest = passDecoder.digest(password);
        sb.append(digest);
        sb.append(" ");
        sb.append(encryptedData);
        return sb.toString();
    }

    public static boolean isPasswordEncrypted(SRADecoder passDecoder, String password) {
        if (password == null) {
            return false;
        }
        try {
            String encryptedData;
            String decryptedData;
            String newDigest;
            String oldDigest;
            StringTokenizer st = new StringTokenizer(password, " ");
            if (st.countTokens() == 2 && (oldDigest = st.nextToken()).equals(newDigest = passDecoder.digest(decryptedData = passDecoder.decrypt(encryptedData = st.nextToken())))) {
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }
}

