/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.CertContext;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class CreateSelfSignedCertificate
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext cntx) {
        int val;
        this.cntx = cntx;
        CertAdminUtil.println(CertAdminConstants.newline);
        String tmpfqdn = cntx.getHost();
        CertAdminUtil.println(CertAdminHelpText.getDNHelpText());
        String fqdn = CertAdminUtil.question(CertAdminLocale.getPFString("q2", "What is the fully-qualified DNS name of this host? [") + tmpfqdn + CertAdminLocale.getPFString("q1", "]"));
        if (fqdn.equals("")) {
            fqdn = tmpfqdn;
        }
        String o = CertAdminUtil.question(CertAdminLocale.getPFString("q3", "What is the name of your organization (ex: Company)? [") + CertAdminLocale.getPFString("q1", "]"));
        String ou = CertAdminUtil.question(CertAdminLocale.getPFString("q4", "What is the name of your organizational unit (ex: division)? [") + CertAdminLocale.getPFString("q1", "]"));
        String l = CertAdminUtil.question(CertAdminLocale.getPFString("q5", "What is the name of your City or Locality? [") + CertAdminLocale.getPFString("q1", "]"));
        String s = CertAdminUtil.question(CertAdminLocale.getPFString("q6", "What is the name (no abbreviation please) of your State or Province? [") + CertAdminLocale.getPFString("q1", "]"));
        String c = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        while (c.trim().length() != 2) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m9", "Enter a valid country code!"));
            c = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        }
        CertAdminUtil.println(CertAdminHelpText.getTokenHelpText());
        String token = CertAdminUtil.question(CertAdminLocale.getPFString("q8", "Enter the token name []"));
        String tmpnick = "server-cert";
        String nick = CertAdminUtil.question(CertAdminLocale.getPFString("q9", "Enter the name you like for this certificate [") + tmpnick + CertAdminLocale.getPFString("q1", "]"));
        if (nick.equals("")) {
            nick = tmpnick;
        }
        if (JSSUtil.certExist(cntx, nick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m10", "Certificate with the specified nickname already exist!"));
            return false;
        }
        int tmpval = 6;
        String validity = CertAdminUtil.question(CertAdminLocale.getPFString("q10", "Enter the validity period for the certificate (months) [") + tmpval + CertAdminLocale.getPFString("q1", "]"));
        if (validity.trim().equals("")) {
            val = tmpval;
        }
        try {
            val = new Integer(validity);
        }
        catch (Exception ex) {
            val = tmpval;
        }
        try {
            CertAdminPasswordCallback password;
            Name issuer = new Name();
            if (!fqdn.equals("")) {
                issuer.addCommonName(fqdn);
            }
            if (!l.equals("")) {
                issuer.addLocalityName(l);
            }
            if (!s.equals("")) {
                issuer.addStateOrProvinceName(s);
            }
            issuer.addCountryName(c);
            if (!o.equals("")) {
                issuer.addOrganizationName(o);
            }
            if (!ou.equals("")) {
                issuer.addOrganizationalUnitName(ou);
            }
            SecureRandom rng = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            int rand = this.nextRandInt(rng);
            String passphrase = cntx.getPasswordContext().generatePassphrase(cntx);
            CryptoToken tok = null;
            if (token.trim().equals("")) {
                tok = cntx.getCryptoManager().getInternalKeyStorageToken();
                password = new CertAdminPasswordCallback(passphrase);
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            } else {
                tok = cntx.getCryptoManager().getTokenByName(token);
                password = new ConsolePasswordCallback();
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            }
            tok.login((PasswordCallback)password);
            String certWithSameDN = JSSUtil.getCertWithSubject(tok, issuer);
            if (certWithSameDN != null) {
                CertAdminUtil.println();
                CertAdminUtil.println(CertAdminLocale.getPFString("m63", "Certificate with the specified Subject DN already exist!"));
                CertAdminUtil.println(CertAdminLocale.getPFString("m64", "Certificate Nickname:") + " " + certWithSameDN);
                CertAdminUtil.println(CertAdminLocale.getPFString("m65", "Certificate Subject DN:") + " " + issuer.getRFC1485());
                CertAdminUtil.println(CertAdminLocale.getPFString("m66", "Retry deleting the certificate or change the Subject DN for the new certificate"));
                CertAdminUtil.question(CertAdminLocale.getPFString("m67", "Hit Return to continue!!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                return false;
            }
            CertAdminUtil.println(CertAdminLocale.getPFString("m11", "Generating self-signed certificate..."));
            CertAdminUtil.println(CertAdminLocale.getPFString("m12", "Generating key.  This may take a few moments..."));
            KeyPairGenerator kpg = tok.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            kpg.initialize(1024);
            KeyPair serverPair = kpg.genKeyPair();
            Certificate serverCert = this.makeCert(issuer, issuer, rand, serverPair.getPrivate(), serverPair.getPublic(), null, val);
            JSSUtil.verifyCertificate(serverCert);
            cntx.getCryptoManager().importCertPackage(ASN1Util.encode((ASN1Value)serverCert), nick);
            String nickfile = cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".nickname";
            if (CertAdminUtil.fileExist(nickfile) && !CertAdminUtil.delete(nickfile)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m46", "Could not delete the .nickname file!"));
            }
            if (!CertAdminUtil.writeLine(nick, nickfile)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m47", "Could not update .nickname file. Please update it manually!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                CertAdminUtil.println(CertAdminLocale.getPFString("m48", ".nickname file location : "));
            }
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m13", "Could not generate the self signed certificate!"));
            ex.printStackTrace();
            return false;
        }
        CertAdminUtil.println(CertAdminLocale.getPFString("m14", "Generated 1024-bit RSA KeyPair"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m15", "Self-signed certificate generated"));
        return true;
    }

    public boolean execute(JSSContext cntx, CertContext certcntx) {
        this.cntx = cntx;
        if (JSSUtil.certExist(cntx, certcntx.nick)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m10", "Certificate with the specified nickname already exist!"));
            return false;
        }
        try {
            CertAdminPasswordCallback password;
            Name issuer = new Name();
            if (!certcntx.fqdn.equals("")) {
                issuer.addCommonName(certcntx.fqdn);
            }
            if (!certcntx.l.equals("")) {
                issuer.addLocalityName(certcntx.l);
            }
            if (!certcntx.s.equals("")) {
                issuer.addStateOrProvinceName(certcntx.s);
            }
            issuer.addCountryName(certcntx.c);
            if (!certcntx.o.equals("")) {
                issuer.addOrganizationName(certcntx.o);
            }
            if (!certcntx.ou.equals("")) {
                issuer.addOrganizationalUnitName(certcntx.ou);
            }
            SecureRandom rng = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            int rand = this.nextRandInt(rng);
            String passphrase = cntx.getPasswordContext().generatePassphrase(cntx);
            CryptoToken tok = null;
            if (certcntx.token.trim().equals("")) {
                tok = cntx.getCryptoManager().getInternalKeyStorageToken();
                password = new CertAdminPasswordCallback(passphrase);
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            } else {
                tok = cntx.getCryptoManager().getTokenByName(certcntx.token);
                password = new ConsolePasswordCallback();
                if (!tok.passwordIsInitialized()) {
                    tok.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)password);
                }
            }
            tok.login((PasswordCallback)password);
            String certWithSameDN = JSSUtil.getCertWithSubject(tok, issuer);
            if (certWithSameDN != null) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m63", "Certificate with the specified Subject DN already exist!"));
                CertAdminUtil.println(CertAdminLocale.getPFString("m64", "Certificate Nickname:") + " " + certWithSameDN);
                CertAdminUtil.println(CertAdminLocale.getPFString("m65", "Certificate Subject DN:") + " " + issuer.getRFC1485());
                CertAdminUtil.println(CertAdminLocale.getPFString("m66", "Retry deleting the certificate or change the Subject DN for the new certificate"));
                CertAdminUtil.question(CertAdminLocale.getPFString("m67", "Hit Return to continue!!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                return false;
            }
            KeyPairGenerator kpg = tok.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            kpg.initialize(1024);
            KeyPair serverPair = kpg.genKeyPair();
            Certificate serverCert = this.makeCert(issuer, issuer, rand, serverPair.getPrivate(), serverPair.getPublic(), null, certcntx.val);
            JSSUtil.verifyCertificate(serverCert);
            cntx.getCryptoManager().importCertPackage(ASN1Util.encode((ASN1Value)serverCert), certcntx.nick);
            String nickfile = cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".nickname";
            if (CertAdminUtil.fileExist(nickfile) && !CertAdminUtil.delete(nickfile)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m46", "Could not delete the .nickname file!"));
            }
            if (!CertAdminUtil.writeLine(certcntx.nick, nickfile)) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m47", "Could not update .nickname file. Please update it manually!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                CertAdminUtil.println(CertAdminLocale.getPFString("m48", ".nickname file location : "));
            }
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m13", "Could not generate the self signed certificate!"));
            ex.printStackTrace();
            return false;
        }
        CertAdminUtil.println(CertAdminLocale.getPFString("m14", "Generated 1024-bit RSA KeyPair"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m15", "Self-signed certificate generated"));
        return true;
    }

    protected Certificate makeCert(Name issuer, Name subject, int serialNumber, PrivateKey privKey, PublicKey pubKey, SEQUENCE extensions, int months) throws Exception {
        AlgorithmIdentifier sigAlgID = new AlgorithmIdentifier(this.cntx.getSigAlg().toOID());
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(2, months);
        Date notAfter = cal.getTime();
        SubjectPublicKeyInfo.Template spkiTemp = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ASN1Util.decode((ASN1Template)spkiTemp, (byte[])pubKey.getEncoded());
        CertificateInfo info = new CertificateInfo(CertificateInfo.v3, new INTEGER((long)serialNumber), sigAlgID, issuer, notBefore, notAfter, subject, spki);
        if (extensions != null) {
            info.setExtensions(extensions);
        }
        return new Certificate(info, privKey, this.cntx.getSigAlg());
    }

    protected Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE bc = new SEQUENCE();
        bc.addElement((ASN1Value)new BOOLEAN(true));
        OBJECT_IDENTIFIER bcOID = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING enc = new OCTET_STRING(ASN1Util.encode((ASN1Value)bc));
        return new Extension(bcOID, true, enc);
    }

    protected int nextRandInt(SecureRandom rand) throws Exception {
        byte[] bytes = new byte[4];
        rand.nextBytes(bytes);
        return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3];
    }
}

