/*
 * Decompiled with CFR 0.152.
 */
package migration_is60.modules.srap.netfile;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import migration_is60.modules.srap.netfile.DataHolder;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFRecord;

public class NetfileDynamicMigration {
    private static final char c_eol = '\n';
    private String s_empty_string = "";
    private ResourceBundle nfRes = null;
    private String inputFile;
    private String outputFile;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage : <input ldiff file> , <output xml file>");
            System.exit(0);
        }
        NetfileDynamicMigration mig = new NetfileDynamicMigration(args[0], args[1]);
        mig.migrate();
        System.exit(0);
    }

    public NetfileDynamicMigration(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        try {
            this.nfRes = ResourceBundle.getBundle("srapNetfileDynamicMigration");
        }
        catch (MissingResourceException mrbEx) {
            System.out.println("Unable to lead resource bundle : srapNetfileDynamicMigration");
            mrbEx.printStackTrace();
            System.exit(0);
        }
    }

    void migrate() {
        int count = 0;
        try {
            LDIF l1 = new LDIF(this.inputFile);
            FileWriter outFile = new FileWriter(this.outputFile);
            LDIFRecord tmp = l1.nextRecord();
            NetfileDynamicMigration.printHeader(outFile);
            while (tmp != null) {
                System.out.println("\n # Entry id:" + count);
                ++count;
                DataHolder data = this.ConvertRecord(tmp);
                try {
                    this.OutputRecord(outFile, data);
                }
                catch (Exception e) {
                    System.out.println("Error writing to output file:" + this.outputFile);
                    e.printStackTrace();
                }
                tmp = l1.nextRecord();
            }
            outFile.write("\n</Requests>");
            outFile.close();
            System.out.println("Processed " + count + " entries");
            System.out.println("Output available in file " + this.outputFile);
        }
        catch (IOException e) {
            System.out.println("Error:" + e.toString());
            e.printStackTrace();
        }
    }

    DataHolder ConvertRecord(LDIFRecord toConvert) {
        DataHolder dataHolder = new DataHolder(toConvert.getDN());
        LDIFAttributeContent ldifAttrContent = (LDIFAttributeContent)toConvert.getContent();
        LDAPAttribute[] attrList = ldifAttrContent.getAttributes();
        LDAPAttributeSet theAttrSet = new LDAPAttributeSet(attrList);
        ArrayList data = new ArrayList();
        for (int i = 0; i < attrList.length; ++i) {
            String attrName = attrList[i].getName();
            if (!attrName.equalsIgnoreCase("sunPortalNetFileCommonHostData")) continue;
            String[] allValues = theAttrSet.getAttribute(attrName).getStringValueArray();
            for (int tmpcount = 0; tmpcount < allValues.length; ++tmpcount) {
                List list = this.parseCommonHostsData(allValues[tmpcount]);
                data.addAll(list);
            }
        }
        dataHolder.setData(data);
        return dataHolder;
    }

    static void printHeader(FileWriter outFile) throws IOException {
        ResourceBundle ambundle = ResourceBundle.getBundle("AMConfig");
        String IDSAMEBaseDir = new String();
        if (ambundle.getObject("com.iplanet.am.installdir") != null) {
            IDSAMEBaseDir = (String)ambundle.getObject("com.iplanet.am.installdir");
            IDSAMEBaseDir = IDSAMEBaseDir.substring(0, IDSAMEBaseDir.indexOf("SUNWam"));
        }
        outFile.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        outFile.write("\n<!--  PROPRIETARY/CONFIDENTIAL/ Use of this product is subject");
        outFile.write("\n to license terms. Copyright 2001 Sun Microsystems Inc.");
        outFile.write("Some preexisting portions Copyright 2001 Netscape");
        outFile.write("Communications Corp. All rights reserved. -->");
        outFile.write("\n<!DOCTYPE Requests PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN \" ");
        outFile.write("\"file:" + IDSAMEBaseDir + "SUNWam/dtd/amAdmin.dtd\">");
        outFile.write("\n<Requests>");
    }

    void writeData(FileWriter outFile, DataHolder data) throws IOException {
        Iterator iter = data.data.iterator();
        while (iter.hasNext()) {
            outFile.write("\n        <Value>");
            outFile.write(iter.next().toString());
            outFile.write("\n        </Value>");
        }
    }

    void OutputRecord(FileWriter outFile, DataHolder data) throws IOException {
        if (data.isNull()) {
            return;
        }
        if (data.dataType == data.ORG_DATA_TYPE) {
            outFile.write("\n<OrganizationRequests DN=\"" + data.dn + "\">");
            outFile.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"Dynamic\">");
            outFile.write("\n       <AttributeValuePair>");
            outFile.write("\n           <Attribute name=\"sunPortalNetFileCommonHostData\"/>");
            outFile.write("\n        ");
            this.writeData(outFile, data);
            outFile.write("\n       </AttributeValuePair>");
            outFile.write("\n    </ModifyServiceTemplate>");
            outFile.write("\n</OrganizationRequests>");
        } else if (data.dataType == data.ROLE_DATA_TYPE) {
            outFile.write("\n<RoleRequests DN=\"" + data.dn + "\">");
            outFile.write("\n    <ModifyServiceTemplate serviceName=\"srapNetFileService\" schemaType=\"1.0\">");
            outFile.write("\n       <AttributeValuePair>");
            outFile.write("\n           <Attribute name=\"sunPortalNetFileCommonHostData\"/>");
            this.writeData(outFile, data);
            outFile.write("\n       </AttributeValuePair>");
            outFile.write("\n    </ModifyServiceTemplate>");
            outFile.write("\n</RoleRequests>");
        } else {
            outFile.write("\n<PeopleContainerRequests DN=\"" + data.dn.substring(data.dn.indexOf(44) + 1) + "\">");
            outFile.write("\n    <ModifyUser modifyDN=\"" + data.dn + "\" >");
            outFile.write("\n       <AttributeValuePair>");
            outFile.write("\n           <Attribute name=\"sunPortalNetFileCommonHostData\"/>");
            this.writeData(outFile, data);
            outFile.write("\n       </AttributeValuePair>");
            outFile.write("\n    </ModifyUser>");
            outFile.write("\n</PeopleContainerRequests>");
        }
    }

    List parseCommonHostsData(String szCommonHosts) {
        StringTokenizer tokens = new StringTokenizer(szCommonHosts, "\n");
        ArrayList<String> listComHosts = new ArrayList<String>();
        StringBuffer sbHostData = null;
        while (tokens.hasMoreTokens()) {
            String szToken = tokens.nextToken();
            if (szToken.startsWith("machine_name=")) {
                if (sbHostData != null) {
                    listComHosts.add(sbHostData.toString());
                }
                sbHostData = new StringBuffer();
                sbHostData.append(szToken).append('\n');
                continue;
            }
            sbHostData.append(szToken).append('\n');
        }
        if (sbHostData != null) {
            listComHosts.add(sbHostData.toString());
        }
        for (int i = 0; i < listComHosts.size(); ++i) {
            try {
                String s_common_host_data = (String)listComHosts.get(i);
                HashMap ht_s_common_host_data = this.parseHost(s_common_host_data, "\n");
                ht_s_common_host_data = this.verifyHostData(ht_s_common_host_data);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Unable to parse common host data " + e.getMessage());
                listComHosts.remove(i);
            }
        }
        return listComHosts;
    }

    HashMap parseHost(String s_user_added_host_share, String separator) throws Exception {
        StringTokenizer st_tokens = new StringTokenizer(s_user_added_host_share, separator);
        HashMap<String, Object> ht_host = new HashMap<String, Object>(st_tokens.countTokens() + 2);
        try {
            ArrayList<String> v_shares = new ArrayList<String>();
            ArrayList<String> v_share_passwords = new ArrayList<String>();
            ht_host.put("shares", v_shares);
            ht_host.put("share_passwords", v_share_passwords);
            String s_name = null;
            while (st_tokens.hasMoreTokens()) {
                String token = st_tokens.nextToken();
                if (token.startsWith("machine_name=")) {
                    s_name = this.removePrefix("machine_name=", token);
                    if (s_name == null || s_name.equals("")) {
                        throw new Exception("illegal_machine_name");
                    }
                    ht_host.put("machine_name", s_name);
                    continue;
                }
                if (token.startsWith("machine_type=")) {
                    s_name = this.removePrefix("machine_type=", token);
                    if (s_name == null || s_name.equals("")) {
                        throw new Exception("illegal_machine_type");
                    }
                    ht_host.put("machine_type", s_name);
                    continue;
                }
                if (token.startsWith("machine_encoding=")) {
                    s_name = this.removePrefix("machine_encoding=", token);
                    ht_host.put("machine_encoding", s_name);
                    continue;
                }
                if (token.startsWith("machine_domain=")) {
                    s_name = this.removePrefix("machine_domain=", token);
                    ht_host.put("machine_domain", s_name);
                    continue;
                }
                if (token.startsWith("machine_password=")) {
                    s_name = this.removePrefix("machine_password=", token);
                    ht_host.put("machine_password", s_name);
                    continue;
                }
                if (token.startsWith("machine_user_name=")) {
                    s_name = this.removePrefix("machine_user_name=", token);
                    ht_host.put("machine_user_name", s_name);
                    continue;
                }
                if (!token.startsWith("share_name=")) continue;
                s_name = this.removePrefix("share_name=", token);
                v_shares.add(s_name);
                String s_password = st_tokens.nextToken();
                v_share_passwords.add(this.removePrefix("share_password=", s_password));
            }
        }
        catch (Exception e) {
            System.out.println("Unable to parse host data " + e);
            throw new Exception("Illegal data format for common host ");
        }
        return ht_host;
    }

    String removePrefix(String prefix, String szValue) throws Exception {
        if (!szValue.startsWith(prefix)) {
            throw new Exception("illegal_machine_data_format");
        }
        szValue = szValue.substring(prefix.length(), szValue.length());
        return this.removeCtrlMChar(szValue);
    }

    void removeCtrlMChar(String szPrefix, String szValue, StringBuffer sbHostInfo) {
        int i = szValue.lastIndexOf(10);
        int j = szValue.lastIndexOf(13);
        if (i < 0 && j < 0) {
            sbHostInfo.append(szPrefix).append(szValue).append('\n');
        } else if (j < 0 && i >= 0) {
            sbHostInfo.append(szPrefix).append(szValue.substring(0, i)).append('\n');
        } else {
            System.out.println("i is " + i + " j is " + j + " value is " + szValue.substring(0, j));
            sbHostInfo.append(szPrefix).append(szValue.substring(0, j)).append('\n');
        }
    }

    String removeCtrlMChar(String szValue) {
        int i = szValue.lastIndexOf(10);
        int j = szValue.lastIndexOf(13);
        if (i < 0 && j < 0) {
            return szValue + '\n';
        }
        if (j < 0 && i >= 0) {
            return szValue.substring(0, i) + '\n';
        }
        return szValue.substring(0, j) + '\n';
    }

    HashMap verifyHostData(HashMap ht_s_common_host_data) throws Exception {
        if (ht_s_common_host_data.get("machine_name") == null) {
            throw new Exception("illegal_machine_name");
        }
        ht_s_common_host_data = this.verifyCharacterEncoding(ht_s_common_host_data);
        this.verifyMachineType(ht_s_common_host_data);
        if (ht_s_common_host_data.get("machine_domain") == null) {
            ht_s_common_host_data.put("machine_domain", this.s_empty_string);
        }
        if (ht_s_common_host_data.get("machine_password") == null) {
            ht_s_common_host_data.put("machine_password", this.s_empty_string);
        }
        if (ht_s_common_host_data.get("machine_user_name") == null) {
            ht_s_common_host_data.put("machine_user_name", this.s_empty_string);
        }
        return ht_s_common_host_data;
    }

    void verifyMachineType(HashMap ht_s_common_host_data) throws Exception {
        Object o_type = ht_s_common_host_data.get("machine_type");
        if (o_type == null) {
            throw new Exception("illegal_machine_type");
        }
        String s_type = (String)o_type;
        if (!((s_type = s_type.trim()).equals("FTP") || s_type.equals("NETWARE") || s_type.equals("NFS") || s_type.equals("NT") || s_type.equals("WIN"))) {
            throw new Exception("illegal_machine_type");
        }
        System.out.println("Machine Type verified is " + (String)o_type);
    }

    HashMap verifyCharacterEncoding(HashMap ht_host) throws Exception {
        int index;
        Object o_encoding = ht_host.remove("machine_encoding");
        String s_encoding = this.s_empty_string;
        if (o_encoding != null) {
            s_encoding = (String)o_encoding;
            s_encoding = s_encoding.trim();
        }
        if ((index = s_encoding.indexOf(40)) == -1) {
            throw new Exception("Bad encoding : " + s_encoding);
        }
        int index1 = s_encoding.indexOf(41, index);
        if (index1 == -1) {
            throw new Exception("Bad encoding : " + s_encoding);
        }
        s_encoding = s_encoding.substring(index + 1, index1);
        String s_encoding_display_name = this.nfRes.getString("encoding_" + s_encoding);
        if (s_encoding_display_name == null || s_encoding_display_name.trim().equals(this.s_empty_string) || s_encoding_display_name.trim().equals("encoding_" + s_encoding)) {
            throw new Exception("Unknown encoding : " + s_encoding);
        }
        System.out.println("Machine encoding being placed is " + s_encoding_display_name);
        return ht_host;
    }
}

