/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.util.GWDebug;
import java.net.URLDecoder;

public class SSOUtil {
    public static SSOToken getSSOToken(String strSessionId) throws Exception {
        return SSOUtil.getSSOTokenNoDecode(URLDecoder.decode(strSessionId));
    }

    public static SSOToken getSSOTokenNoDecode(String strSessionId) throws Exception {
        SSOToken ssoToken = null;
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        try {
            ssoToken = ssoTokenManager.createSSOToken(strSessionId);
            if (!ssoTokenManager.isValidToken(ssoToken)) {
                throw new SSOException("SSOToken creation suceeded , but it is not valid");
            }
        }
        catch (SSOException ssoEx) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SSOUtil: Unable to create SSOToken -> ", ssoEx);
            }
            throw ssoEx;
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("SSOUtil: Unable to decode the SessionID -> ", e);
            }
            throw e;
        }
        return ssoToken;
    }
}

