/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.HostAvailabilityEventImpl;
import com.sun.portal.util.HostAvailabilityMediator;
import com.sun.portal.util.PingServiceRequest;
import com.sun.portal.util.ProxyAuthFailedException;
import com.sun.portal.util.ProxyAuthNeededException;
import com.sun.portal.util.ProxyUnreachableException;
import com.sun.portal.util.watch_unavailable;
import java.io.IOException;
import java.net.URL;
import sun.misc.BASE64Decoder;

public class HostChecker {
    private static int _retry = GatewayProfile.getInt("ServerRetryInterval", 5) * 60;
    private static final int PROXY_HTTP_PORT = 8080;

    public static boolean isHostAvailable(URL host, int hostType) {
        block20: {
            try {
                String proxyHost;
                String proxy = DomainWebProxyConfig.getWebProxy(host.getProtocol(), host.getHost());
                String proxyAuth = null;
                if (proxy != null) {
                    proxyHost = null;
                    int portIndex = proxy.indexOf(58);
                    proxyHost = portIndex == -1 ? proxy : proxy.substring(0, proxy.indexOf(58));
                    proxyAuth = DomainWebProxyConfig.getProxyPassword(proxyHost);
                }
                proxyHost = null;
                int proxyPort = -1;
                String proxyUser = null;
                PingServiceRequest psr = null;
                String proxyPassword = null;
                if (proxy == null) {
                    psr = new PingServiceRequest(host);
                } else {
                    block19: {
                        int portIndex = proxy.indexOf(58);
                        if (portIndex == -1) {
                            proxyPort = 8080;
                            proxyHost = proxy;
                        } else {
                            proxyHost = proxy.substring(0, proxy.indexOf(58));
                            proxyPort = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                        }
                        BASE64Decoder decoder = new BASE64Decoder();
                        if (proxyAuth != null) {
                            try {
                                proxyAuth = new String(decoder.decodeBuffer(proxyAuth));
                            }
                            catch (IOException ioe) {
                                if (!GWDebug.debug.errorEnabled()) break block19;
                                GWDebug.debug.error("Password decode failed:", ioe);
                            }
                        }
                    }
                    if (proxyAuth == null) {
                        psr = new PingServiceRequest(host, proxyHost, proxyPort);
                    } else {
                        proxyUser = proxyAuth.substring(0, proxyAuth.indexOf(58)).trim();
                        proxyPassword = proxyAuth.substring(proxyAuth.indexOf(58) + 1).trim();
                        psr = new PingServiceRequest(host, proxyHost, proxyPort, proxyUser, proxyPassword);
                    }
                }
                boolean isAlive = psr.isServiceAlive();
                if (!isAlive) {
                    HostAvailabilityEventImpl event = new HostAvailabilityEventImpl();
                    event.setHost(host.toString());
                    event.setHostStatus(2);
                    event.setHostType(hostType);
                    HostAvailabilityMediator.getHostAvailabilityMediator();
                    HostAvailabilityMediator.notifyListeners(event);
                    watch_unavailable wus = new watch_unavailable(host.toString(), _retry, proxyHost, proxyPort, proxyUser, proxyPassword, hostType);
                    wus.start();
                }
                return isAlive;
            }
            catch (NumberFormatException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Bad Proxy Port", e);
                }
            }
            catch (ProxyUnreachableException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Proxy used for reaching Portal Server Proxy is down:", e);
                }
            }
            catch (ProxyAuthNeededException e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Proxy password not found for authentication", e);
                }
            }
            catch (ProxyAuthFailedException e) {
                if (!GWDebug.debug.errorEnabled()) break block20;
                GWDebug.debug.error("Proxy Authentication Failed", e);
            }
        }
        return false;
    }
}

