/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.SessionCipherMsg;
import java.io.DataInputStream;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class SessionRequest
extends SessionCipherMsg {
    private String sessionID;
    private String algo;

    public SessionRequest() {
    }

    public SessionRequest(byte[] sid, int sidlen) {
        super(sid, sidlen);
        this.sessionID = new String(this.sessId);
    }

    public SessionRequest(String sid) {
        super(sid.getBytes(), sid.getBytes().length);
        this.sessionID = new String(sid);
    }

    public int readMsg(DataInputStream in) {
        int rc = super.readMsg(in);
        if (rc == 0) {
            this.sessionID = new String(this.sessId);
            StringTokenizer stz = new StringTokenizer(this.sessionID, "|");
            try {
                this.sessionID = stz.nextToken();
                this.algo = stz.nextToken();
            }
            catch (NoSuchElementException ne) {
                this.sessionID = new String(this.sessId);
            }
        } else {
            this.sessionID = null;
            rc = -1;
        }
        return rc;
    }

    public void setSessionID(String sid) {
        this.sessionID = new String(sid);
        this.sessId = sid.getBytes();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getAlgorithm() {
        if (this.algo == null) {
            return "SSL_RSA_WITH_RC4_128_MD5";
        }
        return this.algo;
    }

    public Properties getNetworkInfo() {
        return null;
    }

    public byte[] getCertificate() {
        return null;
    }

    public byte[] getSessionIDBytes() {
        return super.getSessionId();
    }

    public void setSessionIDBytes(byte[] id, int id_len) {
        super.setSessionId(id, id_len);
        this.sessionID = new String(this.sessId);
    }
}

