/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterDecrypt;
import com.sun.portal.netlet.econnection.ReaderWriterEncrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.SystemProperties;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupFtp
extends ReaderWriterLock {
    public boolean done;
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterDecrypt src_to_dst;
    private ReaderWriterEncrypt dst_to_src;
    private SessionAuthenticator sessionAuth;
    private SessionRequest sessionReq;
    private static int ip_part1;
    private static int ip_part2;
    private static int ip_part3;
    private static int ip_part4;
    private long startTime;

    public RWGroupFtp(Socket in, SessionAuthenticator sa, SessionRequest rq) {
        block19: {
            block18: {
                this.done = false;
                this.fromClient = in;
                this.sessionAuth = sa;
                this.sessionReq = rq;
                ServerSocket ss = null;
                try {
                    ss = new ServerSocket(0);
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.incrementServerSockets();
                    }
                }
                catch (IOException ex) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("RWGroupFtp: unable to create server socket for ftp." + ex);
                    }
                    return;
                }
                String ipaddr = null;
                try {
                    ipaddr = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
                }
                catch (Exception ex) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("RWGroupFtp: Unable to get IP address");
                    }
                    return;
                }
                int listenPort = ss.getLocalPort();
                String reply = ipaddr + "," + listenPort / 256 + "," + listenPort % 256;
                System.out.println("Reply " + reply);
                try {
                    DataOutputStream dos = new DataOutputStream(in.getOutputStream());
                    dos.writeInt(ip_part1);
                    dos.writeInt(ip_part2);
                    dos.writeInt(ip_part3);
                    dos.writeInt(ip_part4);
                    dos.writeInt(listenPort / 256);
                    dos.writeInt(listenPort % 256);
                    dos.flush();
                }
                catch (Exception ex) {
                    return;
                }
                boolean isHTTPS = ss instanceof SSLServerSocket;
                try {
                    this.toServer = ss.accept();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (isHTTPS) {
                            SocketCount.incrementSSLSockets();
                        } else {
                            SocketCount.incrementPlainSockets();
                        }
                    }
                }
                catch (Exception ex) {
                    if (!GWDebug.debug.errorEnabled()) break block18;
                    GWDebug.debug.error("RWGroupCrypt: ftp data server socket can't accept. " + ex);
                }
            }
            try {
                this.src_to_dst = new ReaderWriterDecrypt(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
                this.dst_to_src = new ReaderWriterEncrypt(this, this.toServer.getInputStream(), this.fromClient.getOutputStream(), this.getNetletKeepAliveInterval(rq));
            }
            catch (Exception ex) {
                System.out.println("Unable to create ReaderWriter threads.");
                ex.printStackTrace();
            }
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException e) {
                if (!GWDebug.debug.errorEnabled()) break block19;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", e);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    this.fromClient.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (this.fromClient instanceof SSLSocket) {
                            SocketCount.decrementSSLSockets();
                        } else {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                }
                catch (Exception e) {
                }
                finally {
                    this.fromClient = null;
                }
            }
            if (this.toServer != null) {
                try {
                    this.toServer.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        if (this.toServer instanceof SSLSocket) {
                            SocketCount.decrementSSLSockets();
                        } else {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.toServer = null;
                }
            }
            Object var5_5 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.src_to_dst = null;
            this.dst_to_src = null;
            this.done = true;
            throw throwable;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getAppletSrcPort() {
        return -1;
    }

    private int getNetletKeepAliveInterval(SessionRequest rq) {
        try {
            String sid = rq.getSessionID();
            NetletProfile profile = new NetletProfile(sid);
            return NetletProfile.getInt("KeepAliveInterval", 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    static {
        block2: {
            String tmpip = SystemProperties.get("gateway.external.ip");
            StringTokenizer stnm = new StringTokenizer(tmpip, ".");
            String part1 = stnm.nextToken();
            String part2 = stnm.nextToken();
            String part3 = stnm.nextToken();
            String part4 = stnm.nextToken();
            try {
                ip_part1 = Integer.parseInt(part1);
                ip_part2 = Integer.parseInt(part2);
                ip_part3 = Integer.parseInt(part3);
                ip_part4 = Integer.parseInt(part4);
            }
            catch (NumberFormatException n) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("RWGroupFtp: invalid ip in platform.conf");
            }
        }
    }
}

