/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import java.io.FileNotFoundException;
import java.lang.reflect.Method;

public class BrowserType {
    private String browserName;
    private boolean netscapeBrowser = true;
    private boolean appleBrowser = false;
    private boolean ieBrowser = false;
    private boolean privDenied;
    private int version = 1;
    public static final int NETSCAPE_UNIVERSAL_CONNECT = 0;
    public static final int NETSCAPE_UNIVERSAL_LISTEN = 1;
    public static final int NETSCAPE_UNIVERSAL_ACCEPT = 3;
    public static final int NETSCAPE_UNIVERSAL_PREFERENCES_READ = 4;
    public static final int NETSCAPE_UNIVERSAL_PREFERENCES_WRITE = 5;
    public static final int NETSCAPE_UNIVERSAL_FILE_ACCESS = 6;
    public static final int NETSCAPE = 50;
    public static final int MICROSOFT = 51;
    public static final int OTHER = 52;
    static /* synthetic */ Class class$java$lang$String;

    public BrowserType() {
        String vendor;
        char VMVersion = System.getProperty("java.version").charAt(0);
        if (VMVersion > '1') {
            this.version = 2;
        }
        if ((VMVersion = System.getProperty("java.version").charAt(2)) > '2') {
            this.version = 2;
        }
        if ((vendor = System.getProperty("java.vendor").toUpperCase()).startsWith("APPLE")) {
            this.browserName = new String("MRJ");
            this.appleBrowser = true;
            this.netscapeBrowser = false;
        } else if (vendor.startsWith("NETSCAPE")) {
            this.browserName = new String("Netscape");
            this.netscapeBrowser = true;
        } else if (vendor.startsWith("MICROSOFT")) {
            this.browserName = new String("IE");
            this.ieBrowser = true;
            this.netscapeBrowser = false;
        } else {
            this.netscapeBrowser = false;
            if (this.version == 2) {
                this.browserName = "Java 2 Enabled browser";
            }
        }
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public boolean getNetscapeBrowser() {
        return this.netscapeBrowser;
    }

    public boolean getAppleBrowser() {
        return this.appleBrowser;
    }

    public boolean getIEBrowser() {
        return this.ieBrowser;
    }

    public boolean getPrivEnabled() {
        return this.privDenied;
    }

    public int getJavaVMVersion() {
        return this.version;
    }

    public SecurityCall enablePermission(int perm) throws Exception {
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
            return new SecurityCall(52);
        }
        if (this.version == 2) {
            return new SecurityCall(52);
        }
        try {
            Method meth = null;
            if (this.getNetscapeBrowser()) {
                Class<?> classPM = Class.forName("netscape.security.PrivilegeManager");
                meth = classPM.getMethod("enablePrivilege", class$java$lang$String == null ? (class$java$lang$String = BrowserType.class$("java.lang.String")) : class$java$lang$String);
                String strPerm = null;
                switch (perm) {
                    case 0: {
                        strPerm = "UniversalConnect";
                        break;
                    }
                    case 1: {
                        strPerm = "UniversalListen";
                        break;
                    }
                    case 3: {
                        strPerm = "UniversalAccept";
                        break;
                    }
                    case 4: {
                        strPerm = "UniversalPreferencesRead";
                        break;
                    }
                    case 5: {
                        strPerm = "UniversalPreferencesWrite";
                        break;
                    }
                    case 6: {
                        strPerm = "UniversalFileAccess";
                        break;
                    }
                    default: {
                        strPerm = "UniversalConnect";
                    }
                }
                return new SecurityCall(50, meth, new String[]{strPerm});
            }
            return new SecurityCall();
        }
        catch (Exception e) {
            if (!(e instanceof ClassNotFoundException) && !(e instanceof FileNotFoundException)) {
                throw e;
            }
            return new SecurityCall();
        }
        catch (NoClassDefFoundError n) {
            return new SecurityCall();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SecurityCall {
        private int vendor;
        private Method method;
        private Object[] args;

        public SecurityCall() {
            this.vendor = 52;
            this.method = null;
            this.args = null;
        }

        public SecurityCall(int avendor) {
            this.vendor = avendor;
            this.method = null;
            this.args = null;
        }

        public SecurityCall(int avendor, Method amethod, Object[] aargs) {
            this.vendor = avendor;
            this.method = amethod;
            this.args = aargs;
        }

        public int getVendor() {
            return this.vendor;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }
}

