/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.Base64;
import com.sun.portal.cli.cert.SRADecoderContext;
import com.sun.portal.cli.cert.SRADecoderException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public abstract class SRADecoder {
    protected Cipher cipher;
    protected MessageDigest digest;
    protected PBEParameterSpec paramSpec;
    protected SecretKey secretKey;
    protected SRADecoderContext decoderCntx;

    public abstract void init() throws SRADecoderException;

    protected abstract SRADecoderContext getDecoderContext();

    public String encrypt(String data) throws SRADecoderException {
        try {
            return this.getEncodedStr(this.encrypt(data.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            return this.getEncodedStr(this.encrypt(data.getBytes()));
        }
    }

    public String decrypt(String data) throws SRADecoderException {
        try {
            return new String(this.decrypt(this.decode(data.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception ex) {
            return new String(this.decrypt(this.decode(data.getBytes())));
        }
    }

    public byte[] encrypt(byte[] data) throws SRADecoderException {
        try {
            this.cipher.init(1, (Key)this.secretKey, this.paramSpec);
            return this.cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new SRADecoderException(ex.toString());
        }
    }

    public byte[] decrypt(byte[] data) throws SRADecoderException {
        try {
            this.cipher.init(2, (Key)this.secretKey, this.paramSpec);
            return this.cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new SRADecoderException(ex.toString());
        }
    }

    public String digest(String data) throws SRADecoderException {
        try {
            return this.getEncodedStr(this.digest(data.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            return this.getEncodedStr(this.digest(data.getBytes()));
        }
    }

    public byte[] digest(byte[] data) throws SRADecoderException {
        try {
            return this.digest.digest(data);
        }
        catch (Exception ex) {
            throw new SRADecoderException(ex.toString());
        }
    }

    protected byte[] encode(byte[] data) {
        return Base64.encode(data);
    }

    protected byte[] decode(byte[] data) {
        return Base64.decode(data);
    }

    public String getEncodedStr(byte[] data) {
        try {
            return new String(this.encode(data), "UTF-8");
        }
        catch (Exception ex) {
            return new String(this.encode(data));
        }
    }

    public String getDecodeStr(byte[] data) {
        try {
            return new String(this.decode(data), "UTF-8");
        }
        catch (Exception ex) {
            return new String(this.decode(data));
        }
    }
}

