/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.MaskingThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CertAdminUtil {
    static void showMenu() {
        CertAdminUtil.println(CertAdminLocale.getPFString("m7", "************************************************************************"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m71", "*********             Certificate Administration               *********"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m7", "************************************************************************"));
        CertAdminUtil.println();
        CertAdminUtil.println(CertAdminLocale.getPFString("m72", "1)  Generate Self-Signed Certificate"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m73", "2)  Generate Certificate Signing Request (CSR)"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m74", "3)  Add Root CA Certificate"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m75", "4)  Install Certificate From Certificate Authority (CA)"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m76", "5)  Delete Certificate"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m77", "6)  Modify Trust Attributes of Certificate (e.g., for PDC)"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m78", "7)  List Root CA Certificates"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m79", "8)  List All Certificates"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m711", "9)  Print Certificate content"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m712", "10) Quit"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m713", "----------------------------"));
        CertAdminUtil.print(CertAdminLocale.getPFString("m714", "choice: [10]"));
    }

    static int processMenuOption() {
        CertAdminUtil.println(CertAdminConstants.newline);
        CertAdminUtil.showMenu();
        String input = CertAdminUtil.readConsoleInput();
        int inputval = 99;
        try {
            inputval = Integer.parseInt(input);
        }
        catch (Exception ex) {
            // empty catch block
        }
        while (!(input.equals("") || inputval >= 1 && inputval <= 10)) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m8", "Invalid Option!"));
            CertAdminUtil.print(CertAdminLocale.getPFString("m714", "choice: [10]"));
            input = CertAdminUtil.readConsoleInput();
            try {
                inputval = Integer.parseInt(input);
            }
            catch (Exception exception) {}
        }
        CertAdminUtil.println(CertAdminConstants.newline);
        return inputval;
    }

    static boolean yesno(String msg) {
        String input = CertAdminUtil.question(msg);
        return input.equalsIgnoreCase("Y") || input.equals("");
    }

    static String question(String msg) {
        CertAdminUtil.print(msg);
        return CertAdminUtil.readConsoleInput();
    }

    static String questionMasked(String msg) {
        MaskingThread maskingthread = new MaskingThread(msg);
        Thread thread = new Thread(maskingthread);
        thread.start();
        String maskedInput = CertAdminUtil.readConsoleInput();
        maskingthread.stopMasking();
        return maskedInput;
    }

    static boolean fileExist(String file) {
        return new File(file).exists();
    }

    static String readLine(String infile) {
        try {
            File file = new File(infile);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            return br.readLine();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static boolean writeLine(String data, String outfile, boolean append) {
        try {
            FileOutputStream fos = new FileOutputStream(outfile, append);
            PrintWriter pw = new PrintWriter(fos, true);
            pw.print(data);
            pw.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static boolean writeLine(String data, String outfile) {
        return CertAdminUtil.writeLine(data, outfile, false);
    }

    static boolean delete(String file) {
        try {
            new File(file).delete();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static boolean rename(String src, String dest) {
        try {
            File srcf = new File(src);
            File destf = new File(dest);
            srcf.renameTo(destf);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static boolean mkdir(String dir) {
        try {
            File directory = new File(dir);
            return directory.mkdir();
        }
        catch (Exception ex) {
            return false;
        }
    }

    static String[] list(String dir) {
        try {
            File file = new File(dir);
            if (!file.isDirectory()) {
                String[] list = new String[]{dir};
                return list;
            }
            return file.list();
        }
        catch (Exception ex) {
            return new String[0];
        }
    }

    static void exitOnError() {
        CertAdminUtil.println(CertAdminLocale.getPFString("m45", "Usage: java certadmin <config-name> <basedir> <idsame-locale-dir>"));
        System.exit(0);
    }

    static void println(String msg) {
        System.out.println(msg);
    }

    static void println() {
        CertAdminUtil.println("");
    }

    static void print(String msg) {
        System.out.print(msg);
    }

    static void print() {
        CertAdminUtil.print("");
    }

    static String readConsoleInput() {
        String input;
        try {
            input = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (Exception ex) {
            input = "";
        }
        return input.trim();
    }

    static String getCurrentDateTime() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("MMddyykkmmss");
        String sDate = sdf.format(date);
        return sDate.trim();
    }
}

