/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.File;
import org.mozilla.jss.crypto.X509Certificate;

public class AddRootCA
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext cntx) {
        this.cntx = cntx;
        CertAdminUtil.println(CertAdminHelpText.getDNHelpText());
        String cacertfile = CertAdminUtil.question(CertAdminLocale.getPFString("q14", "What is the name (including path) of file that contains the root") + CertAdminConstants.newline + CertAdminLocale.getPFString("q141", "certificate that you would like to add to your database ?"));
        File file = new File(cacertfile);
        if (!file.exists()) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m23", "Certificate file") + " " + cacertfile + " " + CertAdminLocale.getPFString("m231", "doesn't exist!"));
            return false;
        }
        try {
            X509Certificate cert = this.addCACertificate(file);
            String certnick = cert.getNickname();
            X509Certificate updatedCert = JSSUtil.changeCertificateTrust(cert, "CT", "CT", "c");
            cntx.getCryptoManager().importCertToPerm(updatedCert, certnick);
            CertAdminUtil.println(CertAdminConstants.newline);
            CertAdminUtil.println(CertAdminLocale.getPFString("m24", "Certificate file"));
            return true;
        }
        catch (Exception ex) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m25", "Added the Root CA certificate successfully"));
            ex.printStackTrace();
            return false;
        }
    }

    private X509Certificate addCACertificate(File certfile) throws Exception {
        return JSSUtil.addCertificate(this.cntx, certfile, null, true);
    }
}

