/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class VerifyCertificate
implements Command {
    private JSSContext cntx;
    private String msg;

    public boolean execute(JSSContext cntx) {
        this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + CertAdminLocale.getPFString("m57", "Could not verify,") + " " + CertAdminLocale.getPFString("m56", "Insufficient command parameters");
        return false;
    }

    public String getMessage() {
        return this.msg;
    }

    public boolean execute(JSSContext cntx, String nick) {
        this.cntx = cntx;
        if (!JSSUtil.certExist(cntx, nick)) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + nick + " " + CertAdminLocale.getPFString("m31", "Specified certificate does not exist!");
            return false;
        }
        X509Certificate cert = null;
        try {
            org.mozilla.jss.crypto.X509Certificate certificate = JSSUtil.getCertByNickname(cntx, nick);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(certificate.getEncoded());
            cert = (X509Certificate)cf.generateCertificate(bais);
            cert.checkValidity();
            this.msg = ((Object)cert.getIssuerDN()).toString().equalsIgnoreCase(((Object)cert.getSubjectDN()).toString()) ? CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + nick + " " + CertAdminLocale.getPFString("m60", "is a self signed certificate!") : CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + nick + " " + CertAdminLocale.getPFString("m62", "is valid!");
        }
        catch (CertificateExpiredException ex) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + nick + " " + CertAdminLocale.getPFString("m59", "has already expired!") + " " + ex.getMessage();
            return false;
        }
        catch (CertificateNotYetValidException ex) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + nick + " " + CertAdminLocale.getPFString("m61", "is invalid!") + " " + ex.getMessage();
            return false;
        }
        catch (Exception ex) {
            this.msg = CertAdminLocale.getPFString("m58", "Gateway certficate status:") + " " + CertAdminLocale.getPFString("m57", "Could not verify,") + nick + " " + ex.getMessage();
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

