/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.Password;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.SRADecoderException;

public class PasswordContextImpl
implements PasswordContext {
    public String generatePassphrase(JSSContext cntx) {
        String passphrase = "";
        boolean flag = true;
        if (!cntx.isDBFileExist() || !cntx.isPassFileExist()) {
            while (flag) {
                CertAdminUtil.println(CertAdminHelpText.getPassphraseHelpText());
                passphrase = CertAdminUtil.questionMasked(CertAdminLocale.getPFString("q20", "Enter passphrase ?"));
                while (passphrase.trim().equals("")) {
                    CertAdminUtil.println(CertAdminLocale.getPFString("m40", "Passphrase cannot be blank!"));
                    passphrase = CertAdminUtil.questionMasked(CertAdminLocale.getPFString("q20", "Enter passphrase ?"));
                }
                String confirmPassphrase = CertAdminUtil.questionMasked(CertAdminLocale.getPFString("q21", "Verify (re-enter) passphrase ?"));
                CertAdminUtil.println(CertAdminConstants.newline);
                if (passphrase.equals(confirmPassphrase)) {
                    CertAdminUtil.println(CertAdminLocale.getPFString("m41", "Passphrase accepted"));
                    boolean stored = false;
                    if (cntx.isPasswordEcrypted()) {
                        try {
                            stored = CertAdminUtil.writeLine(JSSUtil.encryptPassword(passphrase), cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
                        }
                        catch (SRADecoderException ex) {
                            CertAdminUtil.println(CertAdminLocale.getPFString("m55", "Error!, Could not encode|decode the JSS engine password") + CertAdminConstants.newline + ex);
                            return null;
                        }
                    } else {
                        stored = CertAdminUtil.writeLine(passphrase, cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
                    }
                    if (!stored) {
                        CertAdminUtil.println(CertAdminLocale.getPFString("m42", "Could not store the password!"));
                    }
                    flag = false;
                    continue;
                }
                CertAdminUtil.println(CertAdminLocale.getPFString("m43", "Passwords don't match!"));
            }
        } else {
            passphrase = CertAdminUtil.readLine(cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
            if (cntx.isPasswordEcrypted()) {
                try {
                    Password pass = JSSUtil.decryptPassword(passphrase);
                    passphrase = pass.getPassword();
                }
                catch (SRADecoderException ex) {
                    CertAdminUtil.println(CertAdminLocale.getPFString("m55", "Error!, Could not encode|decode the JSS engine password") + CertAdminConstants.newline + ex);
                    return null;
                }
            }
        }
        return passphrase;
    }
}

