/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.util.SystemProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class ApprovalCallback
implements SSLCertificateApprovalCallback {
    private String reqHost = null;
    private static ApprovalCallback theInstance = null;
    public static boolean trustAllServerCerts = false;
    protected static List srapGateway_trustedSSLDomainList = new ArrayList();

    private ApprovalCallback() {
    }

    public ApprovalCallback(String host) {
        if (host != null) {
            this.reqHost = host.toLowerCase();
        }
    }

    public static ApprovalCallback getInstance() {
        if (theInstance == null) {
            theInstance = new ApprovalCallback();
        }
        return theInstance;
    }

    public boolean approve(X509Certificate cert, SSLCertificateApprovalCallback.ValidityStatus status) {
        JSSDebug.debug.message("ApprovalCallback: SubjectDN = " + cert.getSubjectDN().getName());
        Enumeration errors = status.getReasons();
        String certHost = ApprovalCallback.getCertHost(cert.getSubjectDN().getName());
        if (this.reqHost == null) {
            int numReasons = 0;
            while (errors.hasMoreElements()) {
                SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
                int reason = item.getReason();
                JSSDebug.debug.message("ApprovalCallback: reason " + reason);
                if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                    if (trustAllServerCerts) continue;
                    ++numReasons;
                    continue;
                }
                if (reason == -12276) {
                    if (ApprovalCallback.isTrustedDomain(certHost)) continue;
                    ++numReasons;
                    continue;
                }
                ++numReasons;
            }
            return numReasons == 0;
        }
        boolean trust = true;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            int reason = item.getReason();
            JSSDebug.debug.message("ApprovalCallback: reason " + reason);
            if (reason == -8172 || reason == -8171 || reason == -8156 || reason == -8179) {
                if (trustAllServerCerts) continue;
                trust = false;
                continue;
            }
            if (reason != -12276) {
                trust = false;
                continue;
            }
            if (ApprovalCallback.isTrustedDomain(certHost) || certHost.equalsIgnoreCase(this.reqHost)) continue;
            trust = false;
        }
        return trust;
    }

    private static boolean isTrustedDomain(String host) {
        if (trustAllServerCerts) {
            return false;
        }
        host = host.toLowerCase();
        if (srapGateway_trustedSSLDomainList == null || srapGateway_trustedSSLDomainList.size() < 1) {
            return false;
        }
        if (srapGateway_trustedSSLDomainList.contains(host)) {
            return true;
        }
        Iterator it = srapGateway_trustedSSLDomainList.iterator();
        while (it.hasNext()) {
            String next = it.next().toString().trim();
            int indx = next.indexOf("*");
            if (indx == -1 || !(indx == 0 ? host.endsWith(next.substring(1, next.length())) : host.startsWith(next.substring(0, indx)) && host.endsWith(next.substring(indx + 1, next.length())))) continue;
            return true;
        }
        return false;
    }

    private static String getCertHost(String subjectDN) {
        StringTokenizer st = new StringTokenizer(subjectDN, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim().toLowerCase();
            if (!token.startsWith("cn=")) continue;
            return token.substring(3);
        }
        return "";
    }

    static {
        String tmp = SystemProperties.get("gateway.trust_all_server_certs");
        trustAllServerCerts = tmp != null && tmp.equals("true");
        Iterator it = GatewayProfile.getStringList("TrustedSSLDomainList").iterator();
        while (it.hasNext()) {
            srapGateway_trustedSSLDomainList.add(it.next().toString().toLowerCase());
        }
    }
}

