/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.util.GWDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;

public final class SocketCache {
    private HashSet _socketCache = new HashSet();
    private static int _max_sockets;
    private static int socketCount;
    private static final int DEFAULT_MAX_SOCKETS = 2000;

    public SocketCache() {
        socketCount = 0;
    }

    public synchronized CachedSocket getSocket(String host, int port, String socketType) {
        block7: {
            CachedSocket cachedSocket = null;
            if (this._socketCache.isEmpty()) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("SocketCache is empty");
                }
            } else {
                try {
                    String inetName = InetAddress.getByName(host).getHostAddress();
                    Iterator iterator = this._socketCache.iterator();
                    while (iterator.hasNext()) {
                        cachedSocket = (CachedSocket)iterator.next();
                        if (cachedSocket.getState() != 0) continue;
                        cachedSocket.setActive();
                        return cachedSocket;
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!GWDebug.debug.warningEnabled()) break block7;
                    GWDebug.debug.warning("Exception when getting CachedSocket", uhe);
                }
            }
        }
        if (GWDebug.debug.warningEnabled()) {
            GWDebug.debug.warning("SocketCache cannot find matching socket for " + host + ":" + port);
        }
        return null;
    }

    public synchronized void putSocket(CachedSocket cachedSocket) {
        ++socketCount;
        this._socketCache.add(cachedSocket);
    }

    public synchronized void removeSocket(CachedSocket hashKey) {
        if (socketCount > 0) {
            --socketCount;
        }
        if (!this._socketCache.remove(hashKey) && GWDebug.debug.errorEnabled()) {
            GWDebug.debug.error("Failed to remove " + hashKey + " from SocketCache");
        }
    }
}

