/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.Base64;
import java.util.StringTokenizer;

class InternalCookie {
    private long timestamp = -1L;
    private String host = null;
    private String encodedForm = null;
    private String name = null;
    private String domain = null;
    private String path = null;
    private String nameValue = null;
    private String setCookie = null;
    private int max_age = -1;

    InternalCookie(String cookie) {
        this.encodedForm = cookie;
        StringTokenizer st = new StringTokenizer(cookie, "^");
        this.setCookie = st.nextToken().trim();
        try {
            this.timestamp = Integer.parseInt(st.nextToken().trim());
        }
        catch (NumberFormatException nfex) {
            this.timestamp = 0L;
        }
        this.host = st.nextToken();
        this.setCookie = new String(Base64.decode(this.setCookie.getBytes()));
        this.setCookie = this.setCookie.trim();
        this.parseSetCookie();
    }

    InternalCookie(String cookie, String host, long timestamp) {
        this.host = host;
        this.timestamp = timestamp;
        this.setCookie = cookie = cookie.substring(cookie.indexOf(58) + 1).trim();
        this.parseSetCookie();
    }

    private void parseSetCookie() {
        StringTokenizer st = new StringTokenizer(this.setCookie, ";");
        this.nameValue = st.nextToken();
        int indx = this.nameValue.indexOf(61);
        this.name = this.setCookie.substring(0, indx);
        while (st.hasMoreTokens()) {
            String value;
            String attr;
            String str = st.nextToken();
            indx = str.indexOf(61);
            if (indx == -1) {
                attr = str;
                value = null;
            } else {
                attr = str.substring(0, indx).trim();
                value = str.substring(indx + 1).trim();
            }
            if (attr.equalsIgnoreCase("domain")) {
                this.domain = value;
                continue;
            }
            if (attr.equalsIgnoreCase("path")) {
                this.path = value;
                continue;
            }
            if (!attr.equalsIgnoreCase("max-age")) continue;
            try {
                this.max_age = Integer.parseInt(value);
            }
            catch (NumberFormatException nfex) {
                this.max_age = 0;
            }
        }
    }

    public int getMaxAge() {
        return this.max_age;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public boolean shouldRemove() {
        return this.max_age >= 0 ? System.currentTimeMillis() / 1000L - this.timestamp <= (long)this.max_age : false;
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getHost() {
        return this.host;
    }

    public String getNameValue() {
        return this.nameValue;
    }

    public String getPath() {
        return this.path;
    }

    public String getEncodedValue() {
        if (this.encodedForm != null) {
            return this.encodedForm;
        }
        this.encodedForm = Base64.encode(this.setCookie) + " ^ " + this.timestamp + " ^ " + this.host;
        return this.encodedForm;
    }
}

