/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CookieList;
import com.sun.portal.rproxy.connectionhandler.HTTPRequest;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.InternalCookie;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.util.ServiceIdentifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CookieManager {
    public static final boolean isCookieManager = GatewayProfile.getBoolean("EnableCookieManager", true);
    private static final String sessionCookieName = SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro");
    private static final String SRAP_SET_COOKIE_PROPERTY = "internalSRAPSetCookieProperty";
    private static boolean cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();

    private static String getReqSessionCookie(Request req) {
        String s = req.getRequestHeader("Cookie");
        if (s == null) {
            return null;
        }
        String cookies = s.substring(s.indexOf(58) + 1);
        String result = null;
        StringTokenizer st = new StringTokenizer(cookies, ";");
        while (st.hasMoreTokens() && result == null) {
            String curCookie = st.nextToken().trim();
            int indx = curCookie.indexOf(61);
            if (indx == -1 || !curCookie.substring(0, indx).trim().equals(sessionCookieName)) continue;
            result = curCookie.substring(indx + 1).trim();
        }
        return result;
    }

    public static SSOToken getUserSession(Request req, HTTPResponse res) {
        SSOToken token;
        String sessid;
        block16: {
            sessid = null;
            token = null;
            sessid = req instanceof HTTPRequest ? ((HTTPRequest)req).getSessionID() : CookieManager.getReqSessionCookie(req);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("getUserSession :: sessid : " + sessid);
            }
            if (sessid != null) {
                try {
                    token = SSOUtil.getSSOToken(sessid);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Cookie Manager -> token " + token);
                    }
                }
                catch (Exception ex) {
                    token = null;
                    if (!GWDebug.debug.messageEnabled()) break block16;
                    GWDebug.debug.message("Cookie Manager -> Exception ", ex);
                }
            }
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager -> token1 " + token);
        }
        if (token != null) {
            return token;
        }
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager -> Trying Response ");
        }
        List list = res.getHeaderAttributeList("set-cookie");
        Iterator iter = list.iterator();
        sessid = null;
        while (iter.hasNext()) {
            String name;
            String cookie = iter.next().toString();
            int indx = cookie.indexOf(58);
            if (indx == -1 || (indx = (cookie = cookie.substring(indx + 1).trim()).indexOf(61)) == -1 || !(name = cookie.substring(0, indx).trim()).equals(sessionCookieName)) continue;
            int indx1 = cookie.indexOf(59, indx);
            indx1 = indx1 == -1 ? cookie.length() : indx1;
            sessid = cookie.substring(indx + 1, indx1).trim();
            break;
        }
        if (sessid != null) {
            try {
                token = SSOUtil.getSSOToken(sessid);
            }
            catch (Exception ex) {
                token = null;
            }
        }
        if (token == null) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie Manager -> got SSOToken " + sessid);
            }
        } else if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager -> DID NOT GET SSOToken " + sessid);
        }
        return token;
    }

    public static void processSetCookieHeaders(Request req, HTTPResponse res) {
        List list = res.getHeaderAttributeList("set-cookie");
        Iterator iter = list.iterator();
        boolean sessionCookieDone = false;
        boolean haveUserSession = false;
        SSOToken ssotoken = null;
        CookieList cookieList = null;
        while (iter.hasNext()) {
            String cookie = iter.next().toString();
            int indx = cookie.indexOf(sessionCookieName);
            if (indx != -1) {
                boolean thisSessionCookie = false;
                int indx1 = cookie.indexOf("=", indx);
                if (indx1 != -1 && cookie.substring(indx, indx1).trim().equals(sessionCookieName)) {
                    thisSessionCookie = true;
                }
                if (thisSessionCookie) {
                    if (sessionCookieDone) continue;
                    String sessionValue = null;
                    indx = cookie.indexOf(";", indx1 + 1);
                    if (indx == -1) {
                        indx = cookie.length();
                    }
                    sessionValue = cookie.substring(indx1 + 1, indx).trim();
                    req.setSessionValue(sessionValue);
                    sessionCookieDone = true;
                    continue;
                }
            }
            if (!isCookieManager) continue;
            if (!haveUserSession) {
                String savedCookies;
                block23: {
                    ssotoken = CookieManager.getUserSession(req, res);
                    if (ssotoken == null) {
                        if (!GWDebug.debug.messageEnabled()) continue;
                        GWDebug.debug.message("Cookie Manager unable to set Cookies : No valid Session.");
                        continue;
                    }
                    haveUserSession = true;
                    savedCookies = null;
                    try {
                        savedCookies = ssotoken.getProperty(SRAP_SET_COOKIE_PROPERTY);
                    }
                    catch (Exception ex) {
                        if (!GWDebug.debug.messageEnabled()) break block23;
                        GWDebug.debug.message("Unable to get Cookie Manager properties", ex);
                    }
                }
                if (savedCookies != null) {
                    cookieList = new CookieList(savedCookies);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Cookie Manager stored cookies : " + savedCookies);
                    }
                } else {
                    cookieList = new CookieList();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Cookie Manager properties -> no saved cookeis.");
                    }
                }
            }
            cookieList.processCookie(cookie, req.getHost());
        }
        if (cookieList != null && cookieList.isModified()) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie Manager : Saving cookies");
            }
            try {
                ssotoken.setProperty(SRAP_SET_COOKIE_PROPERTY, cookieList.getEncodedValue());
            }
            catch (SSOException ex) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Unable to set Cookie Manager properties");
                }
            }
        } else if (cookieList != null) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie Manager : No modifications");
            }
        } else if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("Cookie Manager : cookieList == null !!");
        }
    }

    public static void processCookies(Request req) {
        CookieList cookieList;
        block20: {
            String savedCookies;
            SSOToken ssotoken;
            block19: {
                if (!ServiceIdentifier.isGateway()) {
                    return;
                }
                if (!isCookieManager) {
                    return;
                }
                String session = req.getSessionID();
                ssotoken = null;
                try {
                    ssotoken = SSOUtil.getSSOToken(session);
                }
                catch (Exception ex) {
                    ssotoken = null;
                }
                if (ssotoken == null) {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("No session !!");
                    }
                    return;
                }
                savedCookies = null;
                try {
                    savedCookies = ssotoken.getProperty(SRAP_SET_COOKIE_PROPERTY);
                }
                catch (SSOException ex) {
                    if (!GWDebug.debug.messageEnabled()) break block19;
                    GWDebug.debug.message("Unable to get Cookie Manager properties");
                }
            }
            if (savedCookies == null || savedCookies.trim().length() == 0) {
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("savedCookies ==  !!" + savedCookies);
                }
                return;
            }
            cookieList = new CookieList(savedCookies);
            if (cookieList.isModified()) {
                try {
                    ssotoken.setProperty(SRAP_SET_COOKIE_PROPERTY, cookieList.getEncodedValue());
                }
                catch (SSOException ex) {
                    if (!GWDebug.debug.messageEnabled()) break block20;
                    GWDebug.debug.message("Unable to set Cookie Manager properties");
                }
            }
        }
        Hashtable table = CookieManager.getCookiesAsHashtable(req.getRequestHeader("Cookie"));
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("From Request : " + table);
        }
        if (CookieManager.processRequestCookieList(table, cookieList, req.getHost(), req.getObject())) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie changed to " + table);
            }
            Enumeration enumeration = table.elements();
            StringBuffer sb = new StringBuffer().append("Cookie : ").append(enumeration.nextElement().toString());
            while (enumeration.hasMoreElements()) {
                sb.append(" ; ").append(enumeration.nextElement().toString());
            }
            req.setRequestHeader("Cookie", sb.toString());
        } else if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("No cookie change " + table);
        }
    }

    private static boolean processRequestCookieList(Hashtable table, CookieList cookieList, String host, String path) {
        boolean changed = false;
        if (cookieList == null || cookieList.length() == 0) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("processRequestCookieList :: cookieList : " + cookieList);
                if (cookieList != null) {
                    GWDebug.debug.message("processRequestCookieList :: cookieList length : " + cookieList.length());
                }
            }
            return changed;
        }
        if (cookie_management) {
            Enumeration enumeration = cookieList.enumerate();
            InternalCookie cookie = null;
            while (enumeration.hasMoreElements()) {
                cookie = (InternalCookie)enumeration.nextElement();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Cookie from Session : : " + cookie);
                }
                table.put(cookie.getName(), cookie.getNameValue());
            }
            return true;
        }
        if (host == null) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("processRequestCookieList :: host : " + host + " returning");
            }
            return changed;
        }
        host = host.trim().toLowerCase();
        if (path != null) {
            path = path.trim();
        }
        Enumeration enumeration = cookieList.enumerate();
        InternalCookie cookie = null;
        while (enumeration.hasMoreElements()) {
            cookie = (InternalCookie)enumeration.nextElement();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie from Session : : " + cookie);
            }
            boolean checkPath = false;
            String cdomain = cookie.getDomain();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Cookie domain : " + cdomain);
                GWDebug.debug.message("Cookie domain : " + cookie.getPath());
            }
            if (cdomain == null) {
                if (host.equalsIgnoreCase(cookie.getHost())) {
                    checkPath = true;
                }
            } else if (host.endsWith(cdomain = cdomain.trim().toLowerCase())) {
                checkPath = true;
            }
            if (!checkPath) continue;
            String cpath = cookie.getPath();
            if (cpath == null) {
                table.put(cookie.getName(), cookie.getNameValue());
                changed = true;
                continue;
            }
            if (!path.startsWith(cpath.trim())) continue;
            table.put(cookie.getName(), cookie.getNameValue());
            changed = true;
        }
        return changed;
    }

    private static Hashtable getCookiesAsHashtable(String cookieHeader) {
        Hashtable<String, String> retval = new Hashtable<String, String>();
        if (cookieHeader == null || cookieHeader.trim().length() == 0) {
            return retval;
        }
        int indx = cookieHeader.indexOf(58);
        if (indx == -1) {
            return retval;
        }
        cookieHeader = cookieHeader.substring(indx + 1).trim();
        StringTokenizer st = new StringTokenizer(cookieHeader, ";");
        while (st.hasMoreTokens()) {
            String cookie = st.nextToken();
            indx = cookie.indexOf(61);
            if (indx == -1) continue;
            retval.put(cookie.substring(0, indx).trim(), cookie);
        }
        return retval;
    }
}

