/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.SystemProperties;
import java.io.IOException;
import java.net.Socket;

public class CachedSocketFactory {
    private static final String BLOCKED_SOCKET_TIMEOUT = "BlockedSocketTimeout";
    private static final int DEFAULT_SOCKET_TIMEOUT = 200000;
    public static int _timeout = GatewayProfile.getInt("BlockedSocketTimeout", 200000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedSocket createSocket(String host, int port, String socketType, Integer logId) {
        CachedSocket cachedSocket;
        block24: {
            Socket socket;
            block23: {
                cachedSocket = null;
                socket = null;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Connecting to " + host + ":" + port);
                }
                try {
                    socket = new Socket(host, port);
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.incrementPlainSockets();
                    }
                }
                catch (Exception se) {
                    String retryTimes;
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("CachedSocketFactory cannot open connection to " + host + ":" + port, se);
                    }
                    if ((retryTimes = SystemProperties.get("gateway.sockretries")) == null) {
                        return null;
                    }
                    int retries = Integer.parseInt(retryTimes);
                    for (int i = 1; i <= retries; ++i) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        try {
                            if (GWDebug.debug.warningEnabled()) {
                                GWDebug.debug.warning("CachedSocketFactory: Open new socket; retry #" + i);
                            }
                            socket = new Socket(host, port);
                            if (PerfContextObject.ENABLE_PERF) {
                                SocketCount.incrementPlainSockets();
                            }
                            if (socket == null) continue;
                            break;
                        }
                        catch (Exception rse) {
                            if (!GWDebug.debug.errorEnabled()) continue;
                            GWDebug.debug.error("CachedSocketFactory cannot open connection to " + host + ":" + port, rse);
                        }
                    }
                    if (socket != null) break block23;
                    return null;
                }
            }
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("RProxy", GWLocale.getPFString("csf1", new Object[]{logId, host, new Integer(socket.getPort())}));
            }
            try {
                socket.setSoTimeout(_timeout);
                socket.setTcpNoDelay(true);
                cachedSocket = new CachedSocket(socket);
            }
            catch (Exception e) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("CachedSocketFactory socket error", e);
                }
                if (socket == null) break block24;
                try {
                    socket.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (IOException e1) {
                }
                finally {
                    socket = null;
                }
            }
        }
        return cachedSocket;
    }

    public static CachedSocket getCachedSocket(String host, int port, String socketType, Integer logId) {
        return CachedSocketFactory.createSocket(host, port, socketType, logId);
    }

    public static CachedSocket getNewCachedSocket(String host, int port, String socketType, Integer logId) {
        return CachedSocketFactory.createSocket(host, port, socketType, logId);
    }
}

