/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ProxyCipherMsg;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletAccessController;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.netlet.eproxy.NetletProxyRouter;
import com.sun.portal.netlet.eproxy.RWGroupCrypt;
import com.sun.portal.netlet.eproxy.RWGroupForward;
import com.sun.portal.netlet.eproxy.RWGroupFtp;
import com.sun.portal.netlet.eproxy.Redirect;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.rproxy.connectionhandler.Session;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.ServiceIdentifier;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLSocket;

public class ESession
implements KeyConstants,
Runnable {
    protected SessionRequest sessReq = null;
    protected NetletProfile userProfile;
    protected ProxyCipherMsg pMsg;
    protected RWGroupCrypt rwg = null;
    protected RWGroupForward rwgf = null;
    protected RWGroupFtp rwgcf = null;
    protected Socket fromSock;
    protected DataInputStream fromClient;
    protected Integer logId;
    protected SessionAuthenticator sessionAuth;
    protected static boolean useNetletProxy = false;
    protected String netletProxyHost = null;
    protected int netletProxyPort = 10555;
    protected Hashtable cipherList = new Hashtable();
    public static final String NETLET_PROXY = "__sra_netlet_proxy__";
    private boolean validatePDC = false;
    private String digest = null;

    public ESession(Socket s, Integer _logId) {
        try {
            this.fromClient = new DataInputStream(s.getInputStream());
        }
        catch (IOException e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ESession: Unable to create DataInputStream -> ", e);
            }
            return;
        }
        this.logId = _logId;
        this.fromSock = s;
        this.sessionAuth = new SessionAuthenticator();
    }

    public void run() {
        SSOToken ssoToken;
        block56: {
            ssoToken = null;
            if (!this.readClientCertificate()) {
                this.cleanUp();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("Unable to read Client Certificate: Closing Netlet Connections");
                }
                return;
            }
            if (this.readSessionId() != 0) {
                this.cleanUp();
                return;
            }
            if (this.sessionAuth.authenticate(this.sessReq) != 0) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: invalid session id");
                }
                this.cleanUp();
                return;
            }
            try {
                SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                ssoToken = ssoTokenManager.createSSOToken(this.sessReq.getSessionID());
                ssoTokenManager.refreshSession(ssoToken);
                if (this.validatePDC && !this.verifyClientCertificate(ssoToken)) {
                    this.cleanUp();
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("Unable to verify Client Certificate: Closing Netlet Connections");
                    }
                    return;
                }
                this.userProfile = new NetletProfile(ssoToken.getTokenID().toString());
                List algoEnum = NetletProfile.getStringList("Ciphers");
                StringBuffer algoList = new StringBuffer();
                for (int x = 0; x < algoEnum.size(); ++x) {
                    algoList.append((String)algoEnum.get(x)).append("|");
                }
                StringTokenizer algoSplitter = new StringTokenizer(algoList.toString(), "|");
                while (algoSplitter.hasMoreElements()) {
                    this.cipherList.put(algoSplitter.nextToken(), algoSplitter.nextToken());
                }
            }
            catch (SSOException se) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + (Object)((Object)se));
                }
            }
            catch (GetResponseException gre) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + gre);
                }
            }
            catch (SendRequestException sre) {
                if (!GWDebug.debug.errorEnabled()) break block56;
                GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + sre);
            }
        }
        if (useNetletProxy) {
            String sessionId;
            block57: {
                sessionId = this.sessReq.getSessionID();
                try {
                    this.netletProxyHost = this.getAssociatedNetletProxy(ssoToken);
                }
                catch (SSOException soe) {
                    soe.printStackTrace();
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Invalid SSOToken while looking op NLP -> " + (Object)((Object)soe));
                    }
                    return;
                }
                URL nlp_url = null;
                try {
                    nlp_url = new URL(this.netletProxyHost);
                }
                catch (MalformedURLException me) {
                    me.printStackTrace();
                }
                this.netletProxyHost = nlp_url.getHost();
                int nlp_Port = nlp_url.getPort();
                if (nlp_Port != -1) {
                    this.netletProxyPort = nlp_Port;
                }
                nlp_url = null;
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("ESession: Netlet proxy host -> " + this.netletProxyHost + " port -> " + this.netletProxyPort);
                }
                this.rwgf = new RWGroupForward(this.fromSock, this.netletProxyHost, this.netletProxyPort, sessionId);
                try {
                    NetletGroupManager.getNetletGroupManager();
                    NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgf, sessionId);
                }
                catch (SSOException se) {
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.unregister(sessionId);
                    }
                    catch (Exception e) {
                        if (!GWDebug.debug.errorEnabled()) break block57;
                        GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                    }
                }
            }
            String logmsg = GWLocale.getPFString("es1", new Object[]{this.logId, new String(GWLogManager.getUserId(sessionId)), this.netletProxyHost, new Integer(this.netletProxyPort)});
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("netlet", logmsg);
            }
        } else {
            NetletAccessController netletAccessCheck = new NetletAccessController(this.userProfile);
            try {
                this.pMsg = new ProxyCipherMsg();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.pMsg.readMsg(this.fromClient) == 0) {
                String logmsg;
                block58: {
                    Redirect rd;
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ESession: srcPort -> " + this.pMsg.getSrcPort());
                    }
                    if ((rd = new Redirect(this.pMsg.getSrcPort(), this.sessReq)).doRedirect()) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("ESession: redirect to -> " + rd.getDstPortList() + " " + rd.getDstHost());
                        }
                        logmsg = GWLocale.getPFString("es2", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), rd.getDstHost(), rd.getDstPortList()});
                        if (!netletAccessCheck.isAccessAllowed(rd.getDstHost())) {
                            this.cleanUp();
                            return;
                        }
                        this.rwg = new RWGroupCrypt(this.fromSock, this.pMsg.getSrcPort(), rd.getDstPortList(), rd.getDstHost(), this.sessionAuth, this.sessReq);
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                        }
                        catch (SSOException se) {
                            try {
                                NetletGroupManager.getNetletGroupManager();
                                NetletGroupManager.unregister(this.sessReq.getSessionID());
                                break block58;
                            }
                            catch (Exception e) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                                }
                                break block58;
                            }
                        }
                    }
                    if (this.pMsg.getDstPort().equals("-1")) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("ESession: FTP data connection to -> " + rd.getDstHost());
                        }
                        logmsg = GWLocale.getPFString("es4", new Object[]{this.logId, rd.getDstHost()});
                        this.rwgcf = new RWGroupFtp(this.fromSock, this.sessionAuth, this.sessReq);
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgcf, this.sessReq.getSessionID());
                        }
                        catch (SSOException se) {
                            try {
                                NetletGroupManager.getNetletGroupManager();
                                NetletGroupManager.unregister(this.sessReq.getSessionID());
                                break block58;
                            }
                            catch (Exception e) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                                }
                                break block58;
                            }
                        }
                    }
                    logmsg = GWLocale.getPFString("es3", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), this.pMsg.getHostName(), this.pMsg.getDstPort()});
                    if (!netletAccessCheck.isAccessAllowed(this.pMsg.getHostName())) {
                        this.cleanUp();
                        return;
                    }
                    this.rwg = new RWGroupCrypt(this.fromSock, this.pMsg.getSrcPort(), this.pMsg.getDstPort(), this.pMsg.getHostName(), this.sessionAuth, this.sessReq);
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                    }
                    catch (SSOException se) {
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.unregister(this.sessReq.getSessionID());
                        }
                        catch (Exception e) {
                            if (!GWDebug.debug.errorEnabled()) break block58;
                            GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                        }
                    }
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("netlet", logmsg);
                }
            } else if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ESession: unable to get proxy config!");
            }
            this.pMsg = null;
        }
    }

    public void stop() {
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        if (this.fromSock != null) {
            try {
                this.fromSock.close();
                if (PerfContextObject.ENABLE_PERF) {
                    SocketCount.decrementPlainSockets();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.fromSock = null;
            }
        }
    }

    public String getSessionID() {
        return this.sessReq.getSessionID();
    }

    public boolean isDone() {
        if (this.rwg != null) {
            return this.rwg.isDone();
        }
        if (this.rwgf != null) {
            return this.rwgf.isDone();
        }
        if (this.rwgcf != null) {
            return this.rwgcf.isDone();
        }
        return this.fromSock == null;
    }

    private int readSessionId() {
        if (this.sessReq == null) {
            this.sessReq = new SessionRequest();
        }
        if (this.sessReq.readMsg(this.fromClient) == 0) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ESession: sessId = " + this.sessReq.getSessionID());
            }
        } else {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ESession: negotiateSessionId IOException");
            }
            return -1;
        }
        return 0;
    }

    private String getAssociatedNetletProxy(SSOToken ssoToken) throws SSOException {
        String associatedNLP = ssoToken.getProperty(NETLET_PROXY);
        if (associatedNLP == null) {
            associatedNLP = NetletProxyRouter.getNetletProxyAlive();
            if (associatedNLP == null) {
                return NetletProxyRouter.getServer();
            }
            ssoToken.setProperty(NETLET_PROXY, associatedNLP);
            return associatedNLP;
        }
        if (NetletProxyRouter.isNetletProxyAlive(associatedNLP)) {
            return associatedNLP;
        }
        associatedNLP = NetletProxyRouter.getNetletProxyAlive();
        if (associatedNLP == null) {
            return NetletProxyRouter.getServer();
        }
        ssoToken.setProperty(NETLET_PROXY, associatedNLP);
        return associatedNLP;
    }

    private boolean readClientCertificate() {
        if (!(this.fromSock instanceof SSLSocket)) {
            return true;
        }
        if (!Session.doingPDC) {
            return true;
        }
        try {
            X509Certificate clientCert = ((SSLSocket)this.fromSock).getStatus().getPeerCertificate();
            byte[] certbyte = clientCert.getEncoded();
            String xxb64Cert = JSSUtil.getDefaultDecoder().getEncodedStr(certbyte);
            this.digest = JSSUtil.getDefaultDecoder().digest(xxb64Cert);
        }
        catch (Exception e) {
            GWDebug.debug.error("Netlet : Unable to get client cert");
            return false;
        }
        return false;
    }

    private boolean verifyClientCertificate(SSOToken ssoToken) {
        String pdcCertInfo = null;
        if (this.digest == null || this.digest.trim().length() == 0) {
            return false;
        }
        try {
            pdcCertInfo = ssoToken.getProperty("__sra_pdc_cert__");
        }
        catch (SSOException soe) {
            GWDebug.debug.error("Netlet : Unable to get certificate digest", soe);
            return false;
        }
        if (pdcCertInfo == null || pdcCertInfo.trim().length() == 0) {
            return false;
        }
        return this.digest.equals(pdcCertInfo);
    }

    static {
        useNetletProxy = GatewayProfile.getBoolean("UseNetletProxy", false) && ServiceIdentifier.isGateway();
    }
}

