/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.SRADecoderException;

public class InstallPasswordContextImpl
implements PasswordContext {
    private String jsspass;

    public InstallPasswordContextImpl(String jsspass) {
        this.jsspass = jsspass;
    }

    public String generatePassphrase(JSSContext cntx) {
        boolean stored = false;
        if (cntx.isPasswordEcrypted()) {
            try {
                stored = CertAdminUtil.writeLine(JSSUtil.encryptPassword(this.jsspass), cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
            }
            catch (SRADecoderException ex) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m55", "Error!, Could not encode|decode the JSS engine password") + CertAdminConstants.newline + ex);
                return null;
            }
        } else {
            stored = CertAdminUtil.writeLine(this.jsspass, cntx.getCertdir() + CertAdminConstants.SEPERATOR + ".jsspass");
        }
        if (!stored) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m42", "Could not store the password!"));
        }
        return this.jsspass;
    }
}

