/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.util.GWDebug;
import java.net.URL;
import java.util.Properties;

public class PropertiesFile
extends Properties {
    private String configURL;

    public PropertiesFile(String _URL) {
        try {
            this.load(new URL(_URL).openStream());
        }
        catch (Exception e) {
            System.out.println("Property file " + _URL + " not found!");
        }
    }

    public String getString(String property, String def) {
        StringBuffer sb = new StringBuffer();
        try {
            String string = (String)this.get(property);
            if (string == null) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("Couldn't find '" + property + "' returning default: " + def);
                }
                return def;
            }
            sb.setLength(0);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isISOControl(c)) continue;
                sb.append(c);
            }
        }
        catch (Exception ex) {
            if (GWDebug.debug.warningEnabled()) {
                GWDebug.debug.warning("Couldn't find '" + property + "' returning default: " + def, ex);
            }
            return def;
        }
        return sb.toString();
    }

    public int getInt(String property, int def) {
        try {
            return Integer.parseInt(this.getString(property, Integer.toString(def)));
        }
        catch (Exception ex) {
            return def;
        }
    }
}

