/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.rproxy.https.JSSThreadPool;
import com.sun.portal.rproxy.https.ReaderWriter;
import com.sun.portal.rproxy.https.ReaderWriterClear;
import com.sun.portal.rproxy.https.ReaderWriterLock;
import java.net.Socket;

public class RWGroupJSSProxy
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean = false;
    private boolean dst_to_src_clean = false;

    public RWGroupJSSProxy(Socket fromSocket, Socket toSocket) {
        this.fromClient = fromSocket;
        this.toServer = toSocket;
        this.src_to_dst = new ReaderWriterClear(this, this.fromClient, this.toServer);
        this.dst_to_src = new ReaderWriterClear(this, this.toServer, this.fromClient);
        try {
            JSSThreadPool.run(this.src_to_dst);
            JSSThreadPool.run(this.dst_to_src);
        }
        catch (InterruptedException e) {
            JSSDebug.debug.message("Could not start ReaderWriterClear tasks", e);
        }
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fromClient != null) {
            try {
                this.fromClient.close();
            }
            catch (Exception e) {
            }
            finally {
                this.fromClient = null;
            }
        }
        if (this.toServer != null) {
            try {
                this.toServer.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.toServer = null;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }
}

