/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CSBufferedInputStream
extends BufferedInputStream {
    private CachedSocket _socket = null;
    private int _expectedLength = 0;
    private int _currentPos = 0;
    private boolean _keepAlive = false;

    public CSBufferedInputStream(InputStream in, CachedSocket socket, int length) {
        this(in);
        this._socket = socket;
        this._expectedLength = length;
    }

    public CSBufferedInputStream(InputStream in) {
        super(in);
    }

    public void setSocket(CachedSocket socket) {
        this._socket = socket;
    }

    public CachedSocket getSocket() {
        return this._socket;
    }

    public void setLength(int length) {
        this._expectedLength = length;
        this._currentPos = 0;
    }

    public int getLength() {
        return this._expectedLength;
    }

    public int getPos() {
        return this._currentPos;
    }

    public void setKeepAlive() {
        this._keepAlive = true;
    }

    public void setClosed() {
        this._keepAlive = false;
    }

    public synchronized int read() {
        int b = -1;
        try {
            if (this._expectedLength != -1) {
                if (this._currentPos == this._expectedLength && this._keepAlive) {
                    this.readToEnd();
                    this._currentPos = 0;
                    this._socket.setIdle();
                    b = -1;
                } else {
                    b = super.read();
                    ++this._currentPos;
                    if (b == -1) {
                        this._currentPos = 0;
                        this._socket.close();
                    }
                }
            } else {
                b = super.read();
                if (b == -1) {
                    this._socket.close();
                }
            }
        }
        catch (IOException ioe) {
            this._currentPos = 0;
            b = -1;
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return b;
    }

    public synchronized int read(byte[] b, int off, int len) {
        int c = -1;
        try {
            if (this._expectedLength != -1 && this._currentPos == this._expectedLength && this._keepAlive) {
                this.readToEnd();
                this._currentPos = 0;
                this._socket.setIdle();
                c = -1;
            } else if (this._expectedLength != -1) {
                if (this._currentPos + len > this._expectedLength) {
                    len = this._expectedLength - this._currentPos;
                }
                if (len == 0) {
                    this._socket.close();
                    c = -1;
                } else {
                    c = super.read(b, off, len);
                    if (c != -1) {
                        this._currentPos += c;
                    } else {
                        this._socket.close();
                    }
                }
            } else if (len == 0) {
                this._socket.close();
                c = -1;
            } else {
                c = super.read(b, off, len);
                if (c == -1) {
                    this._socket.close();
                }
            }
        }
        catch (IOException ioe) {
            this._currentPos = 0;
            c = -1;
            try {
                this._socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return c;
    }

    public synchronized long skip(long n) {
        long numSkipped = 0L;
        try {
            numSkipped = super.skip(n);
            this._currentPos = (int)((long)this._currentPos + numSkipped);
        }
        catch (IOException ioe) {
            try {
                this._socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return numSkipped;
    }

    public synchronized void readToEnd() {
        if (this._expectedLength != -1) {
            while (this._currentPos < this._expectedLength && this.read() != -1) {
            }
        }
    }
}

