/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.netlet.eproxy.RProxyConnection;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.rewriter.SRAPRewriterModule;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EProxy {
    public static boolean isNetletEnabled = true;
    public static boolean isProxyletEnabled = false;
    static final String watchdogInfoFileBase = "/var/opt/SUNWps/.gw.";

    private static void init() {
        StringBuffer logsb;
        GWDebug.createDefault("srapGateway");
        if (!GWNSSInit.initialize()) {
            System.exit(1);
        }
        ServiceIdentifier.createDefault("srapGateway");
        try {
            String profileName = System.getProperty("gateway.profilename", "default");
            GatewayProfile.init("this-should-be-sid", profileName);
            PlatformProfile.init("this-should-be-sid");
            SRAPRewriterModule.initIDSAME();
        }
        catch (Exception e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to initialize GatewayProfile/PlatformProfile", e);
            }
            System.exit(1);
        }
        GatewayContextFactory.init(1);
        GWLogManager.initialise();
        if (GWLogManager.loggingEnabled) {
            logsb = new StringBuffer();
            logsb.append("srapGateway_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            GWLogManager.createDefault(logsb.toString());
        }
        if (NetletLogMgr.loggingEnabled) {
            logsb = new StringBuffer();
            logsb.append("srapNetlet_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            NetletLogMgr.createDefault(logsb.toString());
        }
        GWLocale.createDefault();
        GWThreadPool.init();
    }

    public static void main(String[] argv) {
        EProxy.init();
        if (GWLogManager.loggingEnabled) {
            GWLogManager.write("EProxy", GWLocale.getPFString("StartEProxy"));
        }
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        boolean httpEnabled = gatewayContext.isHttpEnabled();
        boolean httpsEnabled = gatewayContext.isHttpsEnabled();
        if (!httpEnabled && !httpsEnabled) {
            return;
        }
        int httpPort = gatewayContext.getHttpPort();
        int httpsPort = gatewayContext.getHttpsPort();
        EProxy.writePortInfoForWatchdog(httpEnabled, httpPort, httpsEnabled, httpsPort);
        isNetletEnabled = gatewayContext.isEProxyEnabled();
        isProxyletEnabled = gatewayContext.isPProxyEnabled();
        EProxy.startRProxy(httpEnabled, httpPort, httpsEnabled, httpsPort);
    }

    private static void startRProxy(boolean httpEnabled, int httpPort, boolean httpsEnabled, int httpsPort) {
        int numberOfGatewayInstances = httpEnabled && httpsEnabled ? 2 : 1;
        GW.setNumberOfInstances(numberOfGatewayInstances);
        if (httpEnabled) {
            RProxyConnection.startHttp(httpPort);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Http is being initialised at port:" + httpPort);
            }
        }
        if (httpsEnabled) {
            RProxyConnection.startHttps(httpsPort);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Https is being initialised at port:" + httpsPort);
            }
        }
    }

    private static void writePortInfoForWatchdog(boolean httpEnabled, int httpPort, boolean httpsEnabled, int httpsPort) {
        block5: {
            File watchdogInfoFile = new File(watchdogInfoFileBase + System.getProperty("conf.suffix"));
            if (watchdogInfoFile.exists()) {
                watchdogInfoFile.delete();
            }
            try {
                FileWriter fw = new FileWriter(watchdogInfoFile);
                if (httpEnabled) {
                    fw.write(httpPort + "\n");
                }
                if (httpsEnabled) {
                    fw.write(httpsPort + "\n");
                }
                fw.flush();
                fw.close();
            }
            catch (IOException ex) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("Unable to enter information for watchdog information");
            }
        }
    }
}

