/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.uri;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.StandardURI;
import com.sun.portal.rewriter.util.uri.URIHelper;
import com.sun.portal.rewriter.util.uri.URIIntf;
import java.net.MalformedURLException;
import java.util.Map;

public abstract class AbstractURI
implements URIIntf {
    protected final String uriString;
    private boolean valid = false;
    private String fileURI;
    private String dirURI;
    private String fileName;
    private String fileExtension;

    protected AbstractURI(String aURIString) {
        this.uriString = StringHelper.normalize(aURIString);
    }

    public final int getDefaultPort() {
        return URIHelper.getDefaultPort(this.getProtocol());
    }

    private Map getQueryMap() {
        return URIHelper.parseQueryString(this.getQuery());
    }

    public final String getParameterValue(String aParamName) {
        Object value = this.getQueryMap().get(aParamName);
        if (value == null) {
            return "";
        }
        String[] lValueArray = (String[])value;
        return lValueArray[lValueArray.length - 1];
    }

    public final String getFileURI() {
        if (this.fileURI == null) {
            this.fileURI = this.getPath();
            if (this.fileURI.length() == 0 && this.uriString.length() != 0) {
                this.fileURI = "/";
            }
        }
        return this.fileURI;
    }

    public final String getDirURI() {
        if (this.dirURI == null) {
            int i;
            String temp = this.getFileURI();
            if (URIHelper.needsToAppendDirectorySeperator(temp)) {
                temp = temp + "/";
            }
            this.dirURI = (i = temp.lastIndexOf("/")) != -1 ? this.getFileURI().substring(0, i + 1) : temp;
        }
        return this.dirURI;
    }

    public final String getFileName() {
        if (this.fileName == null) {
            String lPath = this.getFileURI();
            this.fileName = lPath.substring(this.getDirURI().length());
        }
        return this.fileName;
    }

    public final String getFileExtension() {
        if (this.fileExtension == null) {
            String bFileName = this.getFileName();
            int i = bFileName.lastIndexOf(46);
            this.fileExtension = i != -1 ? bFileName.substring(i + 1) : "";
        }
        return this.fileExtension;
    }

    public final String getInputString() {
        return this.uriString;
    }

    public final String toExternalForm() {
        if (!this.isValid() & !this.isAbsolute()) {
            return this.uriString;
        }
        return this.getProtocol() + (this.getProtocol().length() != 0 ? "://" : "") + (this.getUserInfo().equals("") ? "" : this.getUserInfo() + "@") + this.getHost() + (this.getPort() != -1 ? ":" + this.getPort() : "") + this.getPath() + (this.getQuery().equals("") ? "" : "?" + this.getQuery()) + (this.getReference().equals("") ? "" : "#" + this.getReference());
    }

    protected final void setValid(boolean aBool) {
        this.valid = aBool;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public static final String appendParams(String aURI, Map aParams) {
        return URIHelper.parameterize(aURI, aParams);
    }

    public static URIIntf[] getAvailableURIImpl(String aURIString) throws MalformedURLException {
        return new URIIntf[]{new StandardURI(aURIString)};
    }
}

