/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js.parser;

import com.sun.portal.rewriter.engines.LanguageConstants;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.js.parser.BinaryDigitReader;
import com.sun.portal.rewriter.engines.js.parser.JSParser;
import com.sun.portal.rewriter.engines.js.parser.JavaScriptException;
import com.sun.portal.rewriter.engines.js.parser.LineBuffer;
import com.sun.portal.rewriter.util.Debug;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TokenStream {
    private static final double NaN = Double.NaN;
    public static final int TSF_ERROR = 1;
    public static final int TSF_NEWLINES = 4;
    public static final int TSF_FUNCTION = 8;
    public static final int TSF_RETURN_EXPR = 16;
    public static final int TSF_RETURN_VOID = 32;
    public static final int TSF_REGEXP = 512;
    private static final int EOF_CHAR = -1;
    public static final int ERROR = -1;
    public static final int EOF = 0;
    public static final int EOL = 1;
    public static final int POPV = 2;
    public static final int ENTERWITH = 3;
    public static final int LEAVEWITH = 4;
    public static final int RETURN = 5;
    public static final int IFEQ = 7;
    public static final int IFNE = 8;
    public static final int DUP = 9;
    public static final int SETNAME = 10;
    public static final int BITOR = 11;
    public static final int BITXOR = 12;
    public static final int BITAND = 13;
    public static final int EQ = 14;
    public static final int NE = 15;
    public static final int LT = 16;
    public static final int LE = 17;
    public static final int GT = 18;
    public static final int GE = 19;
    public static final int LSH = 20;
    public static final int RSH = 21;
    public static final int URSH = 22;
    public static final int ADD = 23;
    public static final int SUB = 24;
    public static final int MUL = 25;
    public static final int DIV = 26;
    public static final int MOD = 27;
    public static final int BITNOT = 28;
    public static final int NEG = 29;
    public static final int NEW = 30;
    public static final int DELPROP = 31;
    public static final int TYPEOF = 32;
    public static final int NAMEINC = 33;
    public static final int PROPINC = 34;
    public static final int ELEMINC = 35;
    public static final int NAMEDEC = 36;
    public static final int PROPDEC = 37;
    public static final int ELEMDEC = 38;
    public static final int GETPROP = 39;
    public static final int SETPROP = 40;
    public static final int GETELEM = 41;
    public static final int SETELEM = 42;
    public static final int CALL = 43;
    public static final int NAME = 44;
    public static final int NUMBER = 45;
    public static final int STRING = 46;
    public static final int ZERO = 47;
    public static final int ONE = 48;
    public static final int NULL = 49;
    public static final int THIS = 50;
    public static final int FALSE = 51;
    public static final int TRUE = 52;
    public static final int SHEQ = 53;
    public static final int SHNE = 54;
    public static final int CLOSURE = 55;
    public static final int OBJECT = 56;
    public static final int POP = 57;
    public static final int POS = 58;
    public static final int VARINC = 59;
    public static final int VARDEC = 60;
    public static final int BINDNAME = 61;
    public static final int THROW = 62;
    public static final int IN = 63;
    public static final int INSTANCEOF = 64;
    public static final int GOSUB = 65;
    public static final int RETSUB = 66;
    public static final int CALLSPECIAL = 67;
    public static final int GETTHIS = 68;
    public static final int NEWTEMP = 69;
    public static final int USETEMP = 70;
    public static final int GETBASE = 71;
    public static final int GETVAR = 72;
    public static final int SETVAR = 73;
    public static final int UNDEFINED = 74;
    public static final int TRY = 75;
    public static final int ENDTRY = 76;
    public static final int NEWSCOPE = 77;
    public static final int TYPEOFNAME = 78;
    public static final int ENUMINIT = 79;
    public static final int ENUMNEXT = 80;
    public static final int GETPROTO = 81;
    public static final int GETPARENT = 82;
    public static final int SETPROTO = 83;
    public static final int SETPARENT = 84;
    public static final int SCOPE = 85;
    public static final int GETSCOPEPARENT = 86;
    public static final int JTHROW = 87;
    public static final int SEMI = 88;
    public static final int LB = 89;
    public static final int RB = 90;
    public static final int LC = 91;
    public static final int RC = 92;
    public static final int LP = 93;
    public static final int RP = 94;
    public static final int COMMA = 95;
    public static final int ASSIGN = 96;
    public static final int HOOK = 97;
    public static final int COLON = 98;
    public static final int OR = 99;
    public static final int AND = 100;
    public static final int EQOP = 101;
    public static final int RELOP = 102;
    public static final int SHOP = 103;
    public static final int UNARYOP = 104;
    public static final int INC = 105;
    public static final int DEC = 106;
    public static final int DOT = 107;
    public static final int PRIMARY = 108;
    public static final int FUNCTION = 109;
    public static final int EXPORT = 110;
    public static final int IMPORT = 111;
    public static final int IF = 112;
    public static final int ELSE = 113;
    public static final int SWITCH = 114;
    public static final int CASE = 115;
    public static final int DEFAULT = 116;
    public static final int WHILE = 117;
    public static final int DO = 118;
    public static final int FOR = 119;
    public static final int BREAK = 120;
    public static final int CONTINUE = 121;
    public static final int VAR = 122;
    public static final int WITH = 123;
    public static final int CATCH = 124;
    public static final int FINALLY = 125;
    public static final int RESERVED = 126;
    public static final int NOP = 127;
    public static final int NOT = 128;
    public static final int PRE = 129;
    public static final int POST = 130;
    public static final int VOID = 131;
    public static final int BLOCK = 132;
    public static final int ARRAYLIT = 133;
    public static final int OBJLIT = 134;
    public static final int LABEL = 135;
    public static final int TARGET = 136;
    public static final int LOOP = 137;
    public static final int ENUMDONE = 138;
    public static final int EXPRSTMT = 139;
    public static final int PARENT = 140;
    public static final int CONVERT = 141;
    public static final int JSR = 142;
    public static final int NEWLOCAL = 143;
    public static final int USELOCAL = 144;
    public static final int SCRIPT = 145;
    public static final int NOT_UNDERSTOOD = 146;
    public static final int ENTITY = 147;
    private static final String[] names = new String[]{"error", "eof", "eol", "popv", "enterwith", "leavewith", "return", "ifeq", "ifne", "dup", "setname", "bitor", "bitxor", "bitand", "eq", "ne", "lt", "le", "gt", "ge", "lsh", "rsh", "ursh", "add", "sub", "mul", "div", "mod", "bitnot", "neg", "new", "delprop", "typeof", "nameinc", "propinc", "eleminc", "namedec", "propdec", "elemdec", "getprop", "setprop", "getelem", "setelem", "call", "name", "number", "string", "zero", "one", "null", "this", "false", "true", "sheq", "shne", "closure", "object", "pop", "pos", "varinc", "vardec", "bindname", "throw", "in", "instanceof", "gosub", "retsub", "callspecial", "getthis", "newtemp", "usetemp", "getbase", "getvar", "setvar", "undefined", "try", "endtry", "newscope", "typeofname", "enuminit", "enumnext", "getproto", "getparent", "setproto", "setparent", "scope", "getscopeparent", "jthrow", "semi", "lb", "rb", "lc", "rc", "lp", "rp", "comma", "assign", "hook", "colon", "or", "and", "eqop", "relop", "shop", "unaryop", "inc", "dec", "dot", "primary", "function", "export", "import", "if", "else", "switch", "case", "default", "while", "do", "for", "break", "continue", "var", "with", "catch", "finally", "reserved", "nop", "not", "pre", "post", "void", "block", "arraylit", "objlit", "label", "target", "loop", "enumdone", "exprstmt", "parent", "convert", "jsr", "newlocal", "uselocal", "script"};
    private static final Map keywords;
    private int pushbackToken;
    private int tokenNumber;
    private int op;
    private int pre_lineno = 0;
    private int pre_offset = 0;
    private int pre_mark = 0;
    private int cur_lineno = 0;
    private int cur_offset = 0;
    private int cur_mark = 0;
    private final LineBuffer lineBuffer;
    private final int[] stringSpec = new int[6];
    private String string = "";
    private Number number;
    public int flags;

    public TokenStream(LineBuffer aLineBuffer) {
        this.lineBuffer = aLineBuffer;
        this.pushbackToken = 0;
        this.flags = 0;
    }

    public String tokenToString(int token) {
        if (token + 1 >= names.length) {
            return null;
        }
        if (token == 104 || token == 96 || token == 108 || token == 101 || token == 103 || token == 102) {
            return names[token + 1] + " " + names[this.op + 1];
        }
        if (token == 46 || token == 56 || token == 44) {
            return names[token + 1] + " `" + this.string + "'";
        }
        if (token == 45) {
            return "NUMBER " + this.number;
        }
        return names[token + 1];
    }

    private int stringToKeyword(String name) {
        Integer result = (Integer)keywords.get(name);
        if (result == null) {
            return 0;
        }
        int x = result;
        this.op = x >> 8;
        return x & 0xFF;
    }

    int getInOffset() {
        return this.lineBuffer.getLineOffset();
    }

    public boolean matchesToken(int toMatch) throws IOException, JavaScriptException {
        int token = this.getToken();
        if (token == toMatch) {
            return true;
        }
        this.revertTokenStatus();
        this.pushbackToken = token;
        return false;
    }

    public void clearPushback() {
        this.pushbackToken = 0;
    }

    public void ungetToken(int tt) throws JavaScriptException {
        if (this.pushbackToken != 0 && tt != -1) {
            Object[] errArgs = new Object[]{this.tokenToString(tt), this.tokenToString(this.pushbackToken)};
            String message = JSParser.getMessage("msg.token.replaces.pushback", errArgs);
            throw new JavaScriptException(message, this.lineBuffer);
        }
        this.pushbackToken = tt;
        this.revertTokenStatus();
    }

    public int peekToken() throws IOException, JavaScriptException {
        int result;
        this.pushbackToken = result = this.getToken();
        this.revertTokenStatus();
        return result;
    }

    private void revertTokenStatus() {
        --this.tokenNumber;
        this.cur_lineno = this.pre_lineno;
        this.cur_offset = this.pre_offset;
        this.cur_mark = this.pre_mark;
    }

    public int peekTokenSameLine() throws IOException, JavaScriptException {
        this.flags |= 4;
        int result = this.peekToken();
        this.flags &= 0xFFFFFFFB;
        if (this.pushbackToken == 1) {
            this.pushbackToken = 0;
        }
        return result;
    }

    public int getToken() throws IOException, JavaScriptException {
        this.saveStatus();
        int token = this.getTokenO();
        this.updateStatus();
        return token;
    }

    private void saveStatus() {
        this.pre_lineno = this.cur_lineno;
        this.pre_offset = this.cur_offset;
        this.pre_mark = this.cur_mark;
    }

    private void updateStatus() {
        this.cur_lineno = this.lineBuffer.getLineNo();
        this.cur_offset = this.lineBuffer.getLineOffset();
        this.cur_mark = this.lineBuffer.getResultOffset();
    }

    public int getTokenO() throws IOException, JavaScriptException {
        int c;
        ++this.tokenNumber;
        if ((this.flags & 1) != 0) {
            return -1;
        }
        if (this.pushbackToken != 0) {
            int result = this.pushbackToken;
            this.pushbackToken = 0;
            return result;
        }
        while (!((c = this.lineBuffer.read()) == 10 && (this.flags & 4) != 0 || !TokenStream.isJSSpace(c) && c != 10)) {
        }
        if (c == -1) {
            return 0;
        }
        if (TokenStream.isJSIdentifierStart(c)) {
            this.lineBuffer.startString();
            while (TokenStream.isJSIdentifierPart(c = this.lineBuffer.read())) {
            }
            this.lineBuffer.unRead();
            String str = this.lineBuffer.getString();
            int result = this.stringToKeyword(str);
            if (result != 0) {
                this.string = str;
                return result;
            }
            this.string = str;
            return 44;
        }
        if (TokenStream.isDigit(c) || c == 46 && TokenStream.isDigit(this.lineBuffer.peek())) {
            int base = 10;
            this.lineBuffer.startString();
            double dval = Double.NaN;
            long longval = 0L;
            boolean isInteger = true;
            if (c == 48) {
                c = this.lineBuffer.read();
                if (c == 120 || c == 88) {
                    c = this.lineBuffer.read();
                    base = 16;
                    this.lineBuffer.startString();
                } else if (TokenStream.isDigit(c) && c < 56) {
                    base = 8;
                    this.lineBuffer.startString();
                }
            }
            while (TokenStream.isXDigit(c) && (base >= 16 || !TokenStream.isAlpha(c) && (base != 8 || c < 56))) {
                c = this.lineBuffer.read();
            }
            if (base == 10 && (c == 46 || c == 101 || c == 69)) {
                isInteger = false;
                if (c == 46) {
                    while (TokenStream.isDigit(c = this.lineBuffer.read())) {
                    }
                }
                if (c == 101 || c == 69) {
                    c = this.lineBuffer.read();
                    if (c == 43 || c == 45) {
                        c = this.lineBuffer.read();
                    }
                    if (!TokenStream.isDigit(c)) {
                        this.lineBuffer.getString();
                        this.reportError("msg.missing.exponent", null);
                        return -1;
                    }
                    while (TokenStream.isDigit(c = this.lineBuffer.read())) {
                    }
                }
            }
            this.lineBuffer.unRead();
            String numString = this.lineBuffer.getString();
            if (base == 10 && !isInteger) {
                try {
                    dval = Double.valueOf(numString);
                }
                catch (NumberFormatException ex) {
                    Object[] errArgs = new Object[]{ex.getMessage()};
                    this.reportError("msg.caught.nfe", errArgs);
                    return -1;
                }
            } else {
                dval = TokenStream.stringToNumber(numString, 0, base);
                longval = (long)dval;
                if ((double)longval != dval) {
                    isInteger = false;
                }
            }
            this.number = !isInteger ? (Number)new Double(dval) : (Number)(-128L <= longval && longval <= 127L ? (Number)new Byte((byte)longval) : (Number)(-32768L <= longval && longval <= 32767L ? (Number)new Short((short)longval) : (Number)(Integer.MIN_VALUE <= longval && longval <= Integer.MAX_VALUE ? (Number)new Integer((int)longval) : (Number)new Double(longval))));
            return 45;
        }
        int retValue = this.parseString(c, false);
        if (retValue != 146) {
            return retValue;
        }
        switch (c) {
            case 10: {
                return 1;
            }
            case 59: {
                return 88;
            }
            case 91: {
                return 89;
            }
            case 93: {
                return 90;
            }
            case 123: {
                return 91;
            }
            case 125: {
                return 92;
            }
            case 40: {
                return 93;
            }
            case 41: {
                return 94;
            }
            case 44: {
                return 95;
            }
            case 63: {
                return 97;
            }
            case 58: {
                return 98;
            }
            case 46: {
                return 107;
            }
            case 124: {
                if (this.lineBuffer.match('|')) {
                    return 99;
                }
                if (this.lineBuffer.match('=')) {
                    this.op = 11;
                    return 96;
                }
                return 11;
            }
            case 94: {
                if (this.lineBuffer.match('=')) {
                    this.op = 12;
                    return 96;
                }
                return 12;
            }
            case 38: {
                if (this.lineBuffer.match('&')) {
                    return 100;
                }
                if (this.lineBuffer.match('=')) {
                    this.op = 13;
                    return 96;
                }
                if (this.lineBuffer.match('#')) {
                    int entity = this.readEntity(c);
                    if (entity == -1) {
                        return -1;
                    }
                    return this.parseString(entity, true);
                }
                return 13;
            }
            case 61: {
                if (this.lineBuffer.match('=')) {
                    this.op = this.lineBuffer.match('=') ? 53 : 14;
                    return 101;
                }
                this.op = 127;
                return 96;
            }
            case 33: {
                if (this.lineBuffer.match('=')) {
                    this.op = this.lineBuffer.match('=') ? 54 : 15;
                    return 101;
                }
                this.op = 128;
                return 104;
            }
            case 60: {
                if (this.lineBuffer.match('!')) {
                    if (this.lineBuffer.match('-')) {
                        if (this.lineBuffer.match('-')) {
                            while ((c = this.lineBuffer.read()) != -1 && c != 10) {
                            }
                            this.lineBuffer.unRead();
                            return this.getToken();
                        }
                        this.lineBuffer.unRead();
                    }
                    this.lineBuffer.unRead();
                }
                if (this.lineBuffer.match('<')) {
                    if (this.lineBuffer.match('=')) {
                        this.op = 20;
                        return 96;
                    }
                    this.op = 20;
                    return 103;
                }
                if (this.lineBuffer.match('=')) {
                    this.op = 17;
                    return 102;
                }
                this.op = 16;
                return 102;
            }
            case 62: {
                if (this.lineBuffer.match('>')) {
                    if (this.lineBuffer.match('>')) {
                        if (this.lineBuffer.match('=')) {
                            this.op = 22;
                            return 96;
                        }
                        this.op = 22;
                        return 103;
                    }
                    if (this.lineBuffer.match('=')) {
                        this.op = 21;
                        return 96;
                    }
                    this.op = 21;
                    return 103;
                }
                if (this.lineBuffer.match('=')) {
                    this.op = 19;
                    return 102;
                }
                this.op = 18;
                return 102;
            }
            case 42: {
                if (this.lineBuffer.match('=')) {
                    this.op = 25;
                    return 96;
                }
                return 25;
            }
            case 47: {
                if (this.lineBuffer.match('/')) {
                    while ((c = this.lineBuffer.read()) != -1 && c != 10) {
                    }
                    this.lineBuffer.unRead();
                    return this.getToken();
                }
                if (this.lineBuffer.match('*')) {
                    while (!((c = this.lineBuffer.read()) == -1 || c == 42 && this.lineBuffer.match('/'))) {
                        if (c != 47 || !this.lineBuffer.match('*')) continue;
                        if (this.lineBuffer.match('/')) {
                            return this.getToken();
                        }
                        this.reportError("msg.nested.comment", null);
                        return -1;
                    }
                    if (c == -1) {
                        this.reportError("msg.unterminated.comment", null);
                        return -1;
                    }
                    return this.getToken();
                }
                if ((this.flags & 0x200) != 0) {
                    StringBuffer re = new StringBuffer();
                    while ((c = this.getNextUnEscaped(re)) != 47) {
                        if (c == 91) {
                            do {
                                re.append((char)c);
                            } while ((c = this.getNextUnEscaped(re)) != 93);
                        }
                        re.append((char)c);
                    }
                    while (this.lineBuffer.match('g') || this.lineBuffer.match('i') || this.lineBuffer.match('m')) {
                    }
                    if (TokenStream.isAlpha(this.lineBuffer.peek())) {
                        this.reportError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.string = re.toString();
                    return 56;
                }
                if (this.lineBuffer.match('=')) {
                    this.op = 26;
                    return 96;
                }
                return 26;
            }
            case 37: {
                this.op = 27;
                if (this.lineBuffer.match('=')) {
                    return 96;
                }
                return 27;
            }
            case 126: {
                this.op = 28;
                return 104;
            }
            case 43: 
            case 45: {
                if (this.lineBuffer.match('=')) {
                    if (c == 43) {
                        this.op = 23;
                        return 96;
                    }
                    this.op = 24;
                    return 96;
                }
                if (this.lineBuffer.match((char)c)) {
                    if (c == 43) {
                        return 105;
                    }
                    return 106;
                }
                if (c == 45) {
                    return 24;
                }
                return 23;
            }
        }
        this.reportError("msg.illegal.character", null);
        return -1;
    }

    private int getNextUnEscaped(StringBuffer aREStore) throws IOException, JavaScriptException {
        int lChar = this.readChar();
        while (lChar == 92) {
            aREStore.append('\\');
            lChar = this.readChar();
            aREStore.append((char)lChar);
            lChar = this.readChar();
        }
        return lChar;
    }

    private int readChar() throws IOException, JavaScriptException {
        int c = this.lineBuffer.read();
        if (c == 10 || c == -1) {
            this.lineBuffer.unRead();
            this.reportError("msg.unterminated.re.lit", null);
            return -1;
        }
        return c;
    }

    private void reportError(String messageProperty, Object[] args) throws JavaScriptException {
        this.flags |= 1;
        String message = JSParser.getMessage(messageProperty, args);
        throw new JavaScriptException(message, this.lineBuffer);
    }

    public int getOp() {
        return this.op;
    }

    public String getString() {
        return this.string;
    }

    public int[] getStringSpec() {
        return this.stringSpec;
    }

    public Number getNumber() {
        return this.number;
    }

    public String getLine() {
        return this.lineBuffer.getLine();
    }

    public int getLineNo() {
        return this.cur_lineno;
    }

    public int getOffset() {
        return this.cur_offset;
    }

    public int getMark() {
        return this.cur_mark;
    }

    public void updateMark(int length) {
        this.cur_mark = length;
    }

    public int getTokenNo() {
        return this.tokenNumber;
    }

    public boolean eof() {
        return this.lineBuffer.eof();
    }

    private static boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private static double stringToNumber(String s, int start, int radix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        int len = s.length();
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = start; end < len; ++end) {
            int newDigit;
            char c = s.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else {
                if ('A' > c || c >= upperCaseBound) break;
                newDigit = c - 65 + 10;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (start == end) {
            return Double.NaN;
        }
        if (sum >= 9.007199254740992E15) {
            if (radix == 10) {
                try {
                    return Double.valueOf(s.substring(start, end));
                }
                catch (NumberFormatException nfe) {
                    return Double.NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bit;
                BinaryDigitReader bdr = new BinaryDigitReader(radix, s, start, end);
                sum = 0.0;
                while ((bit = bdr.getNextBinaryDigit()) == 0) {
                }
                if (bit == 1) {
                    sum = 1.0;
                    for (int j = 52; j != 0; --j) {
                        bit = bdr.getNextBinaryDigit();
                        if (bit < 0) {
                            return sum;
                        }
                        sum = sum * 2.0 + (double)bit;
                    }
                    int bit54 = bdr.getNextBinaryDigit();
                    if (bit54 >= 0) {
                        int bit3;
                        double factor = 2.0;
                        int sticky = 0;
                        while ((bit3 = bdr.getNextBinaryDigit()) >= 0) {
                            sticky |= bit3;
                            factor *= 2.0;
                        }
                        sum += (double)(bit54 & (bit | sticky));
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    private static boolean isJSIdentifierPart(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 36;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isXDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static boolean isJSIdentifierStart(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 36;
    }

    private static boolean isJSSpace(int c) {
        return c == 9 || c == 11 || c == 12 || c == 32;
    }

    private int parseString(int c, boolean checkForEntity) throws IOException, JavaScriptException {
        boolean escapedString = false;
        if (c == 92 && this.lineBuffer.peek() == 34) {
            escapedString = true;
            c = this.lineBuffer.read();
        }
        if (c == 34 || c == 39) {
            StringBuffer stringBuf = null;
            int quoteChar = c;
            int val = 0;
            this.stringSpec[0] = this.lineBuffer.getLineNo();
            this.stringSpec[1] = this.lineBuffer.getLineOffset();
            this.stringSpec[4] = this.lineBuffer.getResultOffset();
            c = this.lineBuffer.read();
            this.lineBuffer.startString();
            while (c != quoteChar) {
                if (checkForEntity && c == 38 && this.lineBuffer.match('#')) {
                    int entity = this.readEntity(c);
                    if (entity == -1) {
                        return -1;
                    }
                    c = entity;
                    continue;
                }
                if (this.checkError(c) == -1) {
                    return -1;
                }
                if (!(c != 92 || escapedString && this.lineBuffer.peek() == 34)) {
                    if (stringBuf == null) {
                        this.lineBuffer.unRead();
                        stringBuf = new StringBuffer(this.lineBuffer.getString());
                        this.lineBuffer.read();
                    }
                    c = this.lineBuffer.read();
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        default: {
                            int c2;
                            int c1;
                            if (TokenStream.isDigit(c) && c < 56) {
                                val = c - 48;
                                c = this.lineBuffer.read();
                                if (TokenStream.isDigit(c) && c < 56) {
                                    val = 8 * val + c - 48;
                                    c = this.lineBuffer.read();
                                    if (TokenStream.isDigit(c) && c < 56) {
                                        val = 8 * val + c - 48;
                                        c = this.lineBuffer.read();
                                    }
                                }
                                this.lineBuffer.unRead();
                                if (val > 255) {
                                    this.reportError("msg.oct.esc.too.large", null);
                                    return -1;
                                }
                                c = val;
                                break;
                            }
                            if (c == 117) {
                                c1 = this.lineBuffer.read();
                                if (!TokenStream.isXDigit(c1)) {
                                    this.lineBuffer.unRead();
                                    c = 117;
                                    break;
                                }
                                val = Character.digit((char)c1, 16);
                                c2 = this.lineBuffer.read();
                                if (!TokenStream.isXDigit(c2)) {
                                    this.lineBuffer.unRead();
                                    stringBuf.append('u');
                                    c = c1;
                                    break;
                                }
                                val = 16 * val + Character.digit((char)c2, 16);
                                int c3 = this.lineBuffer.read();
                                if (!TokenStream.isXDigit(c3)) {
                                    this.lineBuffer.unRead();
                                    stringBuf.append('u');
                                    stringBuf.append((char)c1);
                                    c = c2;
                                    break;
                                }
                                val = 16 * val + Character.digit((char)c3, 16);
                                int c4 = this.lineBuffer.read();
                                if (!TokenStream.isXDigit(c4)) {
                                    this.lineBuffer.unRead();
                                    stringBuf.append('u');
                                    stringBuf.append((char)c1);
                                    stringBuf.append((char)c2);
                                    c = c3;
                                    break;
                                }
                                c = val = 16 * val + Character.digit((char)c4, 16);
                                break;
                            }
                            if (c != 120) break;
                            c1 = this.lineBuffer.read();
                            if (!TokenStream.isXDigit(c1)) {
                                this.lineBuffer.unRead();
                                c = 120;
                                break;
                            }
                            val = Character.digit((char)c1, 16);
                            c2 = this.lineBuffer.read();
                            if (!TokenStream.isXDigit(c2)) {
                                this.lineBuffer.unRead();
                                stringBuf.append('x');
                                c = c1;
                                break;
                            }
                            c = val = 16 * val + Character.digit((char)c2, 16);
                        }
                    }
                }
                if (stringBuf != null) {
                    stringBuf.append((char)c);
                }
                c = this.lineBuffer.read();
            }
            if (stringBuf != null) {
                this.string = stringBuf.toString();
            } else {
                this.lineBuffer.unRead();
                this.string = this.lineBuffer.getString();
                this.lineBuffer.read();
            }
            this.stringSpec[2] = this.lineBuffer.getLineNo();
            this.stringSpec[3] = this.lineBuffer.getLineOffset();
            this.stringSpec[5] = this.lineBuffer.getResultOffset() - 1;
            return 46;
        }
        return 146;
    }

    private int readEntity(int c) throws JavaScriptException, IOException {
        this.lineBuffer.unRead();
        StringBuffer sb = new StringBuffer();
        sb.append((char)c);
        do {
            if (this.checkError(c = this.lineBuffer.read()) == -1) {
                return -1;
            }
            sb.append((char)c);
        } while (c != 59);
        return TokenStream.resolveEntity(sb.toString());
    }

    private int checkError(int c) throws JavaScriptException {
        if (c == 10 || c == -1) {
            this.lineBuffer.unRead();
            this.lineBuffer.getString();
            this.reportError("msg.unterminated.string.lit", null);
            return -1;
        }
        return 146;
    }

    private static int resolveEntity(String s) {
        for (int i = 0; i < LanguageConstants.HTML_ENTITIES.length; ++i) {
            if (!s.equals(LanguageConstants.HTML_ENTITIES[i][0])) continue;
            return LanguageConstants.HTML_ENTITIES[i][1].charAt(0);
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        String[][] testCases = new String[][]{{"urlVariable", "urlVar = './abc.html';"}};
        for (int i = 0; i < testCases.length; ++i) {
            TokenStream ts = new TokenStream(new LineBuffer(new PageContent(testCases[i][1]), "Testcase"));
            while (!ts.eof()) {
                System.out.println("TokenNo: " + ts.getTokenNo() + " Line Number: " + ts.getLineNo() + " String:" + ts.tokenToString(ts.getToken()));
            }
            ts.ungetToken(ts.getToken());
            System.out.println("TokenNo: " + ts.getTokenNo() + " Line Number: " + ts.getLineNo() + " String:" + ts.tokenToString(ts.getToken()));
            ts.ungetToken(ts.getToken());
            System.out.println("TokenNo: " + ts.getTokenNo() + " Line Number: " + ts.getLineNo() + " String:" + ts.tokenToString(ts.getToken()));
            Debug.println("\n");
        }
    }

    static {
        String[] strings = new String[]{"break", "case", "continue", "default", "delete", "do", "else", "export", "false", "for", "function", "if", "in", "new", "null", "return", "switch", "this", "true", "typeof", "var", "void", "while", "with", "abstract", "boolean", "byte", "catch", "char", "class", "const", "debugger", "double", "enum", "extends", "final", "finally", "float", "implements", "import", "instanceof", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "throw", "throws", "transient", "try", "volatile"};
        int[] values = new int[]{120, 115, 121, 116, 31, 118, 113, 110, 13164, 119, 109, 112, 16230, 30, 12652, 5, 114, 12908, 13420, 8296, 122, 33640, 117, 123, 126, 126, 126, 124, 126, 126, 126, 126, 126, 126, 126, 126, 125, 126, 126, 111, 16486, 126, 126, 126, 126, 126, 126, 126, 126, 126, 126, 32620, 126, 62, 126, 126, 75, 126};
        keywords = new HashMap(109);
        Integer res = new Integer(126);
        for (int i = 0; i < strings.length; ++i) {
            keywords.put(strings[i], values[i] == 126 ? res : new Integer(values[i]));
        }
    }
}

