/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CSLog {
    static DateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
    static long rotateSize = 0x500000L;
    protected static int logLevel = 0;
    protected static String filename;
    static PrintWriter logWriter;
    static FileOutputStream outStream;
    static int cumulativLog;
    static boolean doSync;

    private CSLog() {
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int n) {
        logLevel = n;
    }

    public static void init(int n, String string) throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        outStream = new FileOutputStream(string, bl);
        CSLog.init(n, new PrintWriter((Writer)new OutputStreamWriter((OutputStream)outStream, "UTF-8"), bl2));
        filename = string;
    }

    public static void init(int n, PrintWriter printWriter) throws Exception {
        logWriter = printWriter;
        logLevel = n;
        filename = null;
    }

    private static synchronized void log_label(int n, int n2, String string, String string2, Throwable throwable) {
        if (n2 <= logLevel) {
            if (logWriter != null) {
                StringBuffer stringBuffer = new StringBuffer("[" + df.format(new Date()) + "] " + string + string2);
                logWriter.println(stringBuffer.toString());
                if (doSync && (long)(cumulativLog += stringBuffer.length()) > rotateSize / 2L) {
                    try {
                        outStream.getFD().sync();
                        cumulativLog = 0;
                    }
                    catch (IOException iOException) {
                        System.err.println("log_label() caught Exception ioe=" + iOException.getMessage());
                        iOException.printStackTrace();
                    }
                }
                if (throwable != null) {
                    throwable.printStackTrace(logWriter);
                }
                CSLog.rotateNow(false);
            } else {
                System.err.println("CSLog:log_label() logWriter is <NULL>");
            }
        }
    }

    public static void log(int n, int n2, String string) {
        CSLog.log(n, n2, string, null);
    }

    public static void log(int n, int n2, String string, Throwable throwable) {
        if (n2 <= logLevel) {
            CSLog.log_label(n, n2, "", string, throwable);
        }
    }

    public static void debug(int n, int n2, String string) {
        CSLog.debug(n, n2, string, null);
    }

    public static void debug(int n, int n2, String string, Throwable throwable) {
        if (n2 <= logLevel) {
            CSLog.log_label(n, n2, "DEBUG: ", string, throwable);
        }
    }

    public static void warn(int n, int n2, String string) {
        CSLog.warn(n, n2, string, null);
    }

    public static void warn(int n, int n2, String string, Throwable throwable) {
        if (n2 <= logLevel) {
            CSLog.log_label(n, n2, "WARNING: ", string, throwable);
        }
    }

    public static void error(int n, int n2, String string) {
        CSLog.error(n, n2, string, null);
    }

    public static void error(int n, int n2, String string, Throwable throwable) {
        if (n2 <= logLevel) {
            CSLog.log_label(n, n2, "ERROR: ", string, throwable);
        }
    }

    public static void setRotateSize(long l) {
        rotateSize = l;
    }

    public static void rotateNow(boolean bl) {
        Object object;
        Object object2;
        int n;
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        try {
            long l = file.length();
            file = null;
            if (!bl && l < rotateSize) {
                return;
            }
        }
        catch (SecurityException securityException) {
            CSLog.warn(1, 1, "Error in log rotation", securityException);
        }
        File file2 = null;
        for (n = 1; n < 10 && (file2 = new File(filename + n)).exists(); ++n) {
        }
        if (n == 10) {
            file2.delete();
        }
        try {
            filename = new File(filename).getCanonicalPath();
        }
        catch (Exception exception) {
            CSLog.warn(1, 1, "Error in log rotation. cannot get Cannonical Path", exception);
        }
        while (n > 1) {
            object2 = new File(filename + (n - 1));
            object = new File(filename + n);
            ((File)object2).renameTo((File)object);
            --n;
        }
        file2 = new File(filename);
        try {
            if (file2.exists()) {
                object2 = new BufferedInputStream(new FileInputStream(filename));
                object = new BufferedOutputStream(new FileOutputStream(filename + 1));
                byte[] byArray = new byte[1024];
                int n2 = 0;
                int n3 = 0;
                while ((n2 = ((InputStream)object2).read(byArray)) > 0) {
                    ((OutputStream)object).write(byArray, 0, n2);
                    n3 += n2;
                }
                ((InputStream)object2).close();
                ((OutputStream)object).close();
                RandomAccessFile randomAccessFile = new RandomAccessFile(filename, "rw");
                randomAccessFile.setLength(0L);
                randomAccessFile.close();
            }
            file2 = null;
        }
        catch (Exception exception) {
            CSLog.warn(1, 1, "Error in log rotation", exception);
        }
    }

    static {
        logWriter = null;
        outStream = null;
        cumulativLog = 0;
        doSync = System.getProperty("os.name").compareToIgnoreCase("SunOS") != 0;
    }
}

