/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.soif;

import com.sun.portal.search.soif.SOIF;
import java.io.UnsupportedEncodingException;

public class AVPair {
    public String attribute;
    public AVValue[] value = new AVValue[1];
    private static String encoding = SOIF.defaultEncoding;

    AVPair() {
    }

    public AVPair(String string) {
        this.attribute = string;
    }

    public AVPair(String string, String string2) {
        this.attribute = string;
        this.insert(string2, 0);
    }

    public AVPair(String string, byte[] byArray) {
        this.attribute = string;
        this.insert(byArray, 0);
    }

    public AVPair(String string, String string2, int n) {
        this.attribute = string;
        this.insert(string2, n);
    }

    public AVPair(String string, byte[] byArray, int n) {
        this(string, byArray, n, SOIF.defaultEncoding);
    }

    public AVPair(String string, byte[] byArray, int n, String string2) {
        this.attribute = string;
        if (string2 != null && string2.equalsIgnoreCase("UTF-16")) {
            string2 = "UTF-16BE";
        }
        encoding = string2;
        this.insert(byArray, n);
    }

    public boolean insert(String string, int n) {
        this.ensureCapacity(n + 1);
        if (this.value[n] == null) {
            this.value[n] = new AVValue(string);
            return true;
        }
        return false;
    }

    public boolean insert(byte[] byArray, int n) {
        this.ensureCapacity(n + 1);
        if (this.value[n] == null) {
            this.value[n] = new AVValue(byArray);
            return true;
        }
        return false;
    }

    public boolean replace(String string, int n) {
        boolean bl = this.remove(n);
        this.insert(string, n);
        return bl;
    }

    public boolean replace(byte[] byArray, int n) {
        boolean bl = this.remove(n);
        this.insert(byArray, n);
        return bl;
    }

    public boolean remove(int n) {
        if (this.value.length > n && this.value[n] != null) {
            this.value[n] = null;
            return true;
        }
        return false;
    }

    public void squeeze() {
        block0: for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] != null) continue;
            for (int j = i + 1; j < this.value.length; ++j) {
                if (this.value[j] == null) continue;
                this.value[i] = this.value[j];
                this.value[j] = null;
                continue block0;
            }
        }
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) {
        this.attribute = string;
    }

    public String getValue() {
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == null) continue;
            return this.value[i].getValue();
        }
        return null;
    }

    public byte[] getBytes() {
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == null) continue;
            return this.value[i].getBytes();
        }
        return null;
    }

    public String getValue(int n) {
        if (this.value.length > n && this.value[n] != null) {
            return this.value[n].getValue();
        }
        return null;
    }

    public byte[] getBytes(int n) {
        if (this.value.length > n && this.value[n] != null) {
            return this.value[n].getBytes();
        }
        return null;
    }

    protected void ensureCapacity(int n) {
        if (this.value == null) {
            this.value = new AVValue[n + 4];
        } else if (this.value.length < n) {
            AVValue[] aVValueArray = this.value;
            this.value = new AVValue[n + 4];
            System.arraycopy(aVValueArray, 0, this.value, 0, aVValueArray.length);
        }
    }

    public int valueCount() {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == null) continue;
            ++n;
        }
        return n;
    }

    public int getMaxIndex() {
        int n;
        for (n = this.value.length - 1; n > 0 && this.value[n] == null; --n) {
        }
        return n;
    }

    public int size() {
        return this.value.length;
    }

    public String[] getStringValues() {
        int n = this.valueCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < this.value.length; ++i) {
            String string = this.getValue(i);
            if (string == null) continue;
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    public byte[][] getByteValues() {
        int n = this.valueCount();
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.value.length) {
            byte[] byArray = this.getBytes(n2);
            if (byArray != null) {
                byArrayArray[n3] = byArray;
            }
            ++n2;
            ++n3;
        }
        return byArrayArray;
    }

    public boolean nthValid(int n) {
        if (this.value == null || this.value.length <= n) {
            return false;
        }
        return this.value[n] != null;
    }

    public int contentSize() {
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == null) continue;
            if (this.value[i].bvalue != null) {
                n += this.value[i].bvalue.length;
                continue;
            }
            if (this.value[i].value == null) continue;
            n += this.value[i].value.length() * 2;
        }
        return n;
    }

    public boolean isMV() {
        return this.getMaxIndex() != 0;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append("AVPairs instance:\n\tattribute\t= [" + this.attribute + "]\n");
            for (int i = 0; i < this.value.length; ++i) {
                stringBuffer.append("\tvalue[" + i + "]\t= [");
                if (this.value[i] == null) {
                    stringBuffer.append("empty");
                } else {
                    stringBuffer.append(this.value[i].value + "] / [");
                    if (this.value[i].bvalue == null) {
                        stringBuffer.append("null");
                    } else {
                        stringBuffer.append(new String(this.value[i].bvalue, encoding));
                    }
                }
                stringBuffer.append("]\n");
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "error";
        }
    }

    class AVValue {
        String value;
        byte[] bvalue;

        public AVValue(String string) {
            this.value = string;
        }

        public AVValue(byte[] byArray) {
            this.bvalue = byArray;
        }

        String getValue() {
            if (this.value == null && this.bvalue != null) {
                try {
                    this.value = new String(this.bvalue, encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return this.value;
        }

        byte[] getBytes() {
            if (this.bvalue == null && this.value != null) {
                try {
                    this.bvalue = this.value.getBytes(encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return this.bvalue;
        }

        void setValue(String string) {
            this.value = string;
            this.bvalue = null;
        }

        void setValue(byte[] byArray) {
            this.bvalue = byArray;
            this.value = null;
        }
    }
}

