/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.kt.search.Log;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.rdmserver.RDMConfig;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.PBlock;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public abstract class RDMContext {
    Map contextConfig;
    RDMConfig rdmConfig;
    String logFile;
    PrintWriter rdmLogStream;
    boolean rdm_log_enabled = true;

    public RDMContext(RDMConfig rDMConfig) throws Exception {
        this.rdmConfig = rDMConfig;
        String string = new File(rDMConfig.getServerRoot(), "config" + File.separator + "search.conf").getPath();
        try {
            this.contextConfig = new HashMap();
            PBlock.parsePBlockConfigFile(string, this.contextConfig);
        }
        catch (Exception exception) {
            throw new Exception("rdm-init: failed to read config file: " + string + ": " + exception.getMessage());
        }
        this.rdm_init_real();
    }

    public abstract void log(String var1);

    public abstract void log(String var1, Exception var2);

    public void logrdm(String string) {
        if (this.rdmLogStream != null) {
            this.rdmLogStream.println(string);
        }
    }

    public void rdmLogEnable(boolean bl) {
        this.rdm_log_enabled = bl;
    }

    public RDMConfig getRDMConfig() {
        return this.rdmConfig;
    }

    protected void rdm_init_real() throws Exception {
        Object object;
        String string;
        String string2;
        String string3 = (String)this.contextConfig.get("log-rotation-size");
        int n = 0x500000;
        if (string3 != null) {
            n = Integer.parseInt(string3) * 1024;
        }
        String string4 = (String)this.contextConfig.get("debug-loglevel");
        int n2 = 0;
        if (string4 != null) {
            n2 = Integer.parseInt(string4);
        }
        if ((string2 = (String)this.contextConfig.get("debug-logfile")) != null) {
            try {
                CSLog.init(n2, string2);
                CSLog.setRotateSize(n);
                CSLog.rotateNow(false);
            }
            catch (Exception exception) {
                throw new Exception("Failed to initialise RDM error log: " + string2 + ": " + exception.getMessage());
            }
        }
        if ((string = (String)this.contextConfig.get("search-logfile")) != null) {
            try {
                object = Log.getLog();
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                Log.setStream((OutputStream)fileOutputStream);
                Log.setLevel((int)n2);
                Log.setLevel((int)3, (int)0);
            }
            catch (Exception exception) {
                CSLog.error(1, 1, "Failed to initialise search engine log: " + string, exception);
                throw exception;
            }
        }
        object = (String)this.contextConfig.get("logfile");
        try {
            this.rdm_log_init((String)object);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot create RDM logFile: " + (String)object, exception);
            throw exception;
        }
        this.schema_init();
    }

    protected void rdm_log_init(String string) throws Exception {
        if (string != null) {
            this.logFile = string;
            try {
                boolean bl = true;
                boolean bl2 = true;
                this.rdmLogStream = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(string, bl)), "UTF-8"), bl2);
            }
            catch (Exception exception) {
                CSLog.error(1, 1, "Cannot append to logFile: " + string, exception);
                throw exception;
            }
        } else {
            this.rdmLogStream = new PrintWriter(System.err);
        }
    }

    public PrintWriter getLogStream() {
        return this.rdmLogStream;
    }

    public void schema_init() throws Exception {
        String string = null;
        try {
            RDMSchema rDMSchema;
            SOIF sOIF;
            string = SearchConfig.getValue("schema-description");
            SOIFInputStream sOIFInputStream = new SOIFInputStream(string);
            while ((sOIF = sOIFInputStream.readSOIF()) != null) {
                rDMSchema = RDMSchema.register(new RDMSchema(sOIF));
            }
            rDMSchema = RDMSchema.register(new RDMSchema(RDMSchema.getClassificationSchemaSOIF()));
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot parse schema: " + string, exception);
            throw exception;
        }
    }
}

