/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.db;

import com.sun.kt.search.Pipeline;
import com.sun.kt.search.ResultSet;
import com.sun.kt.search.SearchEngine;
import com.sun.kt.search.SearchEngineException;
import com.sun.kt.search.SequencedMap;
import com.sun.portal.search.db.NovaResultSet;
import com.sun.portal.search.db.RDMDb;
import com.sun.portal.search.db.RDMResultSet;
import com.sun.portal.search.db.RDMSecurityManager;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.db.SageAttr;
import com.sun.portal.search.rdm.RDMException;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.SearchConfig;
import com.sun.portal.search.util.Semaphore;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class NovaDb
implements RDMDb {
    SearchEngine engine;
    Properties indexProps;
    static boolean saveData = false;
    Semaphore querySemaphore;
    int queryThreads = 6;
    static Map schemaAttrMap = new HashMap();
    List curBatch = new ArrayList();
    static int maxBatchSize = 50000;

    public static void setSaveData(boolean bl) {
        saveData = bl;
    }

    protected void load_schema_index_attrs(String string, Properties properties) {
        SageAttr[] sageAttrArray = null;
        RDMSchema rDMSchema = RDMSchema.getSchema(string.toLowerCase());
        if (rDMSchema == null) {
            CSLog.warn(1, 1, "No schema for object type: " + string + " - indexing will be skipped.");
            return;
        }
        String[] stringArray = rDMSchema.schema_index_attrs();
        int n = 0;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Float> arrayList2 = new ArrayList<Float>();
        boolean bl2 = rDMSchema.getName().equalsIgnoreCase("CLASSIFICATION");
        int n2 = stringArray.length;
        sageAttrArray = new SageAttr[n2];
        for (n = 0; n < n2; ++n) {
            sageAttrArray[n] = new SageAttr();
            sageAttrArray[n].name = stringArray[n];
            String string2 = sageAttrArray[n].name.toLowerCase();
            String string3 = rDMSchema.schema_attr_type(sageAttrArray[n].name);
            if (string3 == null) {
                string3 = "string";
            }
            if (string3.equalsIgnoreCase("string") || string3.equalsIgnoreCase("blob")) {
                sageAttrArray[n].is_string = true;
            } else if (string3.equalsIgnoreCase("int") || string3.equalsIgnoreCase("serial")) {
                sageAttrArray[n].is_number = true;
            } else if (string3.equalsIgnoreCase("date")) {
                sageAttrArray[n].is_date = true;
            }
            if (sageAttrArray[n].name.equalsIgnoreCase("url")) {
                bl = true;
            }
            if (string2.equals("id") && bl2) {
                properties.setProperty(string2 + ".type", "String");
                properties.setProperty(string2 + ".indexed", "false");
                properties.setProperty(string2 + ".tokenized", "false");
            } else if (string2.equals("url")) {
                properties.setProperty(string2 + ".type", "String");
                properties.setProperty(string2 + ".indexed", "true");
                properties.setProperty(string2 + ".tokenized", "true");
            } else if (string2.equals("readacl")) {
                properties.setProperty(string2 + ".type", "String");
                properties.setProperty(string2 + ".indexed", "true");
                properties.setProperty(string2 + ".tokenized", "false");
            } else if (string2.equals("description")) {
                if (saveData) {
                    properties.setProperty(string2 + ".type", "String");
                }
                properties.setProperty(string2 + ".indexed", "true");
                properties.setProperty(string2 + ".tokenized", "true");
            } else if (string2.equals("partial-text")) {
                if (saveData) {
                    properties.setProperty(string2 + ".type", "String");
                    properties.setProperty(string2 + ".indexed", "true");
                    properties.setProperty(string2 + ".tokenized", "true");
                }
            } else if (sageAttrArray[n].is_date) {
                properties.setProperty(string2 + ".type", "Date");
                properties.setProperty(string2 + ".indexed", "false");
                properties.setProperty(string2 + ".tokenized", "false");
            } else if (sageAttrArray[n].is_number) {
                properties.setProperty(string2 + ".type", "Integer");
                properties.setProperty(string2 + ".indexed", "false");
                properties.setProperty(string2 + ".tokenized", "false");
            } else {
                properties.setProperty(string2 + ".type", "String");
                properties.setProperty(string2 + ".indexed", "true");
                properties.setProperty(string2 + ".tokenized", "true");
            }
            String string4 = rDMSchema.getValue(sageAttrArray[n].name, "score-multiplier");
            if (string4 == null) continue;
            try {
                Float f = Float.valueOf(string4);
                properties.setProperty(string2 + ".mult", f.toString());
                arrayList.add(sageAttrArray[n].name);
                arrayList2.add(f);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CSLog.warn(1, 1, "Ignoring illegal score multiplier: " + sageAttrArray[n].name + ":" + string4);
            }
        }
        schemaAttrMap.put(string.toLowerCase(), sageAttrArray);
    }

    public static Map soifToIndexableMap(SOIF sOIF) {
        String string;
        SequencedMap sequencedMap = new SequencedMap();
        SageAttr[] sageAttrArray = (SageAttr[])schemaAttrMap.get(sOIF.getSchemaName().toLowerCase());
        if (sageAttrArray == null) {
            if (CSLog.getLogLevel() > 1 || !sOIF.getSchemaName().equalsIgnoreCase("TAXONOMY")) {
                CSLog.warn(1, 1, "Unknown schema type - object not indexed: @" + sOIF.getSchemaName() + " { " + sOIF.getURL());
            }
            return sequencedMap;
        }
        boolean bl = sOIF.getSchemaName().equalsIgnoreCase("CLASSIFICATION");
        if (bl) {
            sequencedMap.put("id", sOIF.getValue("Id"));
        } else {
            sequencedMap.put("url", sOIF.getURL());
        }
        for (int i = 0; i < sageAttrArray.length; ++i) {
            Object object;
            string = sageAttrArray[i].name.toLowerCase();
            if (bl && string.equalsIgnoreCase("Id") || string.equalsIgnoreCase("URL")) continue;
            AVPair aVPair = sOIF.getAVPair(sageAttrArray[i].name);
            if (aVPair == null) {
                if (!bl || !sageAttrArray[i].name.equalsIgnoreCase("Category")) continue;
                Object object2 = object = sOIF.getValue("id");
                int n = 0;
                n = ((String)object).lastIndexOf(58);
                if (n != -1) {
                    object2 = ((String)object).substring(++n);
                }
                aVPair = new AVPair("Category", (String)object2);
            }
            if (((String[])(object = aVPair.getStringValues())).length == 0) continue;
            if (((String[])object).length == 1) {
                sequencedMap.put(string, object[0]);
                continue;
            }
            sequencedMap.put(string, object);
        }
        String string2 = sOIF.getValue("description");
        string = sOIF.getValue("partial-text");
        if (string2 != null) {
            int n = Math.max(0, string2.length() - 3);
            if (string == null || !string2.regionMatches(0, string, 0, n)) {
                sequencedMap.put("description", string2);
            }
        }
        if (string != null) {
            sequencedMap.put("partial-text", string);
        }
        return sequencedMap;
    }

    public static String getSOIFKey(SOIF sOIF) {
        return sOIF.getSchemaName().equalsIgnoreCase("CLASSIFICATION") ? sOIF.getValue("Id") : sOIF.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexBatch(SToken sToken) throws RDMException {
        List list = this.curBatch;
        synchronized (list) {
            if (this.curBatch.size() == 0) {
                return;
            }
            long l = new Date().getTime();
            int n = 0;
            Pipeline pipeline = this.engine.getIndexingPipeline();
            Iterator iterator = this.curBatch.iterator();
            while (iterator.hasNext()) {
                Map map;
                SOIF sOIF = (SOIF)iterator.next();
                try {
                    map = NovaDb.soifToIndexableMap(sOIF);
                }
                catch (Exception exception) {
                    CSLog.error(1, 1, "Failed to index: " + sOIF.getURL());
                    continue;
                }
                try {
                    pipeline.index(NovaDb.getSOIFKey(sOIF), map);
                    ++n;
                }
                catch (SearchEngineException searchEngineException) {
                    pipeline.flush();
                    this.engine.returnIndexingPipeline(pipeline);
                    throw new RDMException("Error indexing SOIF", (Exception)((Object)searchEngineException));
                }
            }
            pipeline.flush();
            this.engine.returnIndexingPipeline(pipeline);
            this.engine.merge();
            this.curBatch.clear();
            long l2 = new Date().getTime();
            CSLog.log(1, 1, "Indexed " + n + " RDs in " + (l2 - l) / 1000L + " seconds (" + (int)((float)n * 3600.0f * 1000.0f / (float)(l2 - l)) + " per hour)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(SToken sToken, SOIF sOIF, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        List list = this.curBatch;
        synchronized (list) {
            this.curBatch.add(sOIF);
            if (this.curBatch.size() >= maxBatchSize) {
                this.indexBatch(sToken);
            }
        }
    }

    public void delete(SToken sToken, SOIF sOIF, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        this.engine.delete(NovaDb.getSOIFKey(sOIF));
    }

    public void update(SToken sToken, SOIF sOIF, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        throw new RDMException("NovaDb: update() not implemented");
    }

    public RDMResultSet search(SToken sToken, String string, int n, Set set, String string2, RDMTransaction rDMTransaction) throws RDMException {
        NovaResultSet novaResultSet = null;
        try {
            this.querySemaphore.acquire();
            String string3 = RDMSecurityManager.getInstance().qualify_Nova_Query(sToken, string);
            List list = null;
            ResultSet resultSet = this.engine.search(string3, string2, list);
            if (CSLog.getLogLevel() >= 5) {
                // empty if block
            }
            novaResultSet = new NovaResultSet(sToken, this, string3, resultSet, n, this.engine.getNDocs(), rDMTransaction);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Error during search:", exception);
            throw new RDMException("Error during search");
        }
        finally {
            this.querySemaphore.release();
        }
        return novaResultSet;
    }

    public SOIF fetch(SToken sToken, String string, int n, RDMTransaction rDMTransaction) throws RDMException {
        return this.fetch(sToken, string, null, n, rDMTransaction);
    }

    public SOIF fetch(SToken sToken, String string, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        throw new RDMException("not implemented");
    }

    public void delete(SToken sToken, SOIFInputStream sOIFInputStream, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        try {
            SOIF sOIF;
            while ((sOIF = sOIFInputStream.readSOIF()) != null) {
                this.delete(sToken, sOIF, set, n, rDMTransaction);
            }
        }
        catch (Exception exception) {
            throw new RDMException(exception);
        }
    }

    public int count(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        return this.engine.getNDocs();
    }

    public void open(SToken sToken, String string, String string2, int n, int n2) throws RDMException {
        try {
            int n3;
            Properties properties = new Properties();
            properties.setProperty("indexDir", string + File.separator + string2);
            String string3 = SearchConfig.getValue("search-index-type");
            if (string3 != null) {
                properties.setProperty("postingsType", string3);
            }
            if ((string3 = SearchConfig.getValue("search-dictionary-type")) != null) {
                properties.setProperty("dictionaryType", string3);
            }
            int n4 = -1;
            string3 = SearchConfig.getValue("search-lookup-limit");
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
                if (n3 > 0) {
                    properties.setProperty("proxLimit", String.valueOf(n3));
                }
            } else {
                properties.setProperty("proxLimit", "-1");
            }
            if ((string3 = SearchConfig.getValue("search-index-threads")) != null) {
                n3 = Integer.parseInt(string3);
                if (n3 > 0) {
                    properties.setProperty("numPipelines", String.valueOf(n3));
                }
            } else {
                properties.setProperty("numPipelines", "1");
            }
            properties.setProperty("queueLength", "32");
            string3 = SearchConfig.getValue("search-index-partition-size");
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
                if (n3 > 0) {
                    properties.setProperty("inMemSize", String.valueOf(n3));
                }
            } else {
                properties.setProperty("inMemSize", "64");
            }
            if ((string3 = SearchConfig.getValue("search-index-merge-rate")) != null) {
                n3 = Integer.parseInt(string3);
                if (n3 > 0) {
                    properties.setProperty("mergeRate", String.valueOf(n3));
                }
            } else {
                properties.setProperty("mergeRate", "8");
            }
            if ((string3 = SearchConfig.getValue("search-index-max-merge-partitions")) != null) {
                n3 = Integer.parseInt(string3);
                if (n3 > 0) {
                    properties.setProperty("maxMergeSize", String.valueOf(n3));
                }
            } else {
                properties.setProperty("maxMergeSize", "40");
            }
            this.load_schema_index_attrs("DOCUMENT", properties);
            this.load_schema_index_attrs("CLASSIFICATION", properties);
            string3 = SearchConfig.getValue("search-query-threads");
            if (string3 != null && (n3 = Integer.parseInt(string3)) > 0) {
                this.queryThreads = n3;
            }
            this.querySemaphore = new Semaphore(this.queryThreads);
            try {
                this.engine = new SearchEngine(properties);
            }
            catch (SearchEngineException searchEngineException) {
                CSLog.error(1, 1, "Error opening search engine");
                throw new RDMException("IO Error opening search engine");
            }
        }
        catch (Exception exception) {
            RDMException rDMException;
            if (!(exception instanceof RDMException)) {
                rDMException = new RDMException(exception.getMessage());
            }
            throw (RDMException)rDMException;
        }
    }

    public void close(SToken sToken) throws RDMException {
        try {
            this.indexBatch(sToken);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Error indexing document batch", exception);
        }
        try {
            this.engine.close();
        }
        catch (SearchEngineException searchEngineException) {
            CSLog.error(1, 1, "Error shutting down partition manager.");
        }
    }

    public void optimize(SToken sToken) throws RDMException {
        try {
            this.engine.optimize();
        }
        catch (SearchEngineException searchEngineException) {
            throw new RDMException("Error optimizing engine", (Exception)((Object)searchEngineException));
        }
    }

    public int purge(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        this.engine.purge();
        return 0;
    }

    public void housekeep() throws RDMException {
        throw new RDMException("not implemented");
    }

    public void setIndexBatchSize(SToken sToken, int n) throws RDMException {
        maxBatchSize = n;
    }

    public void recover(SToken sToken, String string, boolean bl) throws RDMException {
        throw new RDMException("not implemented");
    }
}

