/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.db;

import com.sun.portal.search.db.Datum;
import com.sun.portal.search.db.DbCursor;
import com.sun.portal.search.db.NovaDb;
import com.sun.portal.search.db.PartitionedDb;
import com.sun.portal.search.db.RDMDb;
import com.sun.portal.search.db.RDMResultSet;
import com.sun.portal.search.db.SOIFDb;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.rdm.RDMException;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import java.util.Set;

public class IndexedSOIFDb
extends SOIFDb
implements RDMDb {
    NovaDb searchdb = new NovaDb();

    public void store(SToken sToken, SOIF sOIF, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        if ((n & 0x20000000) == 0) {
            super.store(sToken, sOIF, set, n, rDMTransaction);
        }
        if ((n & 0x10000000) == 0) {
            if (!sOIF.contains("__noreindex__")) {
                this.searchdb.store(sToken, sOIF, set, n, rDMTransaction);
            } else {
                sOIF.remove("__noreindex__");
            }
        }
    }

    public void delete(SToken sToken, SOIF sOIF, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        if ((n & 0x20000000) == 0) {
            super.delete(sToken, sOIF, n, rDMTransaction);
        }
        if ((n & 0x10000000) == 0) {
            int n2 = n & 0xFF000000;
            n &= 0xFFFFFF;
            if ((n2 & 0x1000000) != 0) {
                if (!sOIF.contains("__noreindex__")) {
                    this.searchdb.store(sToken, sOIF, set, n, rDMTransaction);
                }
            } else {
                this.searchdb.delete(sToken, sOIF, null, 0, rDMTransaction);
            }
        }
    }

    public void update(SToken sToken, SOIF sOIF, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        super.update(sToken, sOIF, set, n, rDMTransaction);
        if ((n & 0x10000000) == 0) {
            if (!sOIF.contains("__noreindex__")) {
                this.searchdb.store(sToken, sOIF, set, n, rDMTransaction);
            } else {
                sOIF.remove("__noreindex__");
            }
        }
    }

    public static void drop(SToken sToken, String string, String string2) throws RDMException {
        PartitionedDb.drop(sToken, string, string2);
    }

    public void optimize(SToken sToken) throws RDMException {
        super.optimize(sToken);
        this.searchdb.optimize(sToken);
    }

    public int purge(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        this.searchdb.purge(sToken, rDMTransaction);
        return super.purge(sToken, rDMTransaction);
    }

    public void open(SToken sToken, String string, String string2, int n, int n2) throws RDMException {
        super.open(sToken, string, string2, n, n2);
        this.searchdb.open(sToken, string, string2, n, n2);
    }

    public void close(SToken sToken) throws RDMException {
        super.close(sToken);
        this.searchdb.close(sToken);
    }

    public String getName() {
        return "Nova Search";
    }

    public RDMResultSet search(SToken sToken, String string, int n, Set set, String string2, RDMTransaction rDMTransaction) throws RDMException {
        RDMResultSet rDMResultSet = this.searchdb.search(sToken, string, n, set, string2, rDMTransaction);
        rDMResultSet.database = this;
        return rDMResultSet;
    }

    public void store(SToken sToken, SOIFInputStream sOIFInputStream, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        try {
            SOIF sOIF;
            while ((sOIF = sOIFInputStream.readSOIF()) != null) {
                this.store(sToken, sOIF, set, n, rDMTransaction);
            }
        }
        catch (Exception exception) {
            throw new RDMException(exception);
        }
    }

    public void delete(SToken sToken, SOIFInputStream sOIFInputStream, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        try {
            SOIF sOIF;
            while ((sOIF = sOIFInputStream.readSOIF()) != null) {
                this.delete(sToken, sOIF, set, n, rDMTransaction);
            }
        }
        catch (Exception exception) {
            throw new RDMException(exception);
        }
    }

    public int count(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        return this.searchdb.count(sToken, rDMTransaction);
    }

    public void recover(SToken sToken, String string, boolean bl) throws RDMException {
        super.recover(sToken, string, bl);
        this.searchdb.recover(sToken, string, bl);
    }

    public void reindex(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        this.searchdb.purge(sToken, rDMTransaction);
        int n = 0;
        DbCursor dbCursor = new DbCursor(this, rDMTransaction, n);
        Datum datum = new Datum();
        Datum datum2 = new Datum();
        while (dbCursor.get(datum, datum2, RDMDb.DB_NEXT) == 0) {
            if (new String(datum.get_data()).endsWith(".per")) continue;
            try {
                SOIF sOIF = new SOIF(datum2.get_data());
                SOIF sOIF2 = this.fetch(sToken, sOIF.getURL(), null, 0, rDMTransaction);
                System.out.println(sOIF2.getURL());
                this.searchdb.store(sToken, sOIF2, null, 0, rDMTransaction);
            }
            catch (Exception exception) {
                throw new RDMException(exception);
            }
        }
        this.searchdb.indexBatch(sToken);
    }

    public void setIndexBatchSize(SToken sToken, int n) throws RDMException {
        this.searchdb.setIndexBatchSize(sToken, n);
    }

    public void indexBatch(SToken sToken) throws RDMException {
        this.searchdb.indexBatch(sToken);
    }
}

