/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class PreferenceDescriptor {
    public static final String PREF_NAME = "name";
    public static final String PREF_VALUE = "value";
    public static final String READ_ONLY = "read-only";
    public static final String MULTI_VALUE = "multi-value";
    private String _prefName;
    private List _prefValues = new ArrayList();
    private List _descriptions = new ArrayList();
    private boolean _readOnly = false;
    private boolean _multiValue = false;
    private Logger _logger;
    private String _portletName;

    public PreferenceDescriptor(Logger logger, String portletName) {
        this._logger = logger;
        this._portletName = portletName;
    }

    public void load(Element element, Namespace namespace) {
        Element multiValueElement;
        List prefValueElements;
        this._prefName = element.getChildTextTrim(PREF_NAME, namespace);
        if (this._prefName == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.logp(Level.WARNING, "PreferenceDescriptor", "load()", "missing pref-name in preference descriptor for: " + this._portletName);
        }
        if ((prefValueElements = element.getChildren(PREF_VALUE, namespace)).isEmpty() && this._logger.isLoggable(Level.WARNING)) {
            this._logger.logp(Level.WARNING, "PreferenceDescriptor", "load()", "missing pref-value in preference descriptor for: " + this._prefName);
        } else {
            Iterator i = prefValueElements.iterator();
            while (i.hasNext()) {
                Element prefValueElement = (Element)i.next();
                this._prefValues.add(prefValueElement.getTextTrim());
            }
        }
        List descriptionElements = element.getChildren("description", namespace);
        Iterator i = descriptionElements.iterator();
        while (i.hasNext()) {
            Element descriptionElement = (Element)i.next();
            this._descriptions.add(descriptionElement.getTextTrim());
        }
        String readOnly = element.getChildTextTrim(READ_ONLY, namespace);
        if (readOnly != null && readOnly.equals("true")) {
            this._readOnly = true;
        }
        if ((multiValueElement = element.getChild(MULTI_VALUE, namespace)) != null) {
            this._multiValue = true;
        }
    }

    public String getPrefName() {
        return this._prefName;
    }

    public List getPrefValues() {
        return this._prefValues;
    }

    public String getDescription() {
        String description = null;
        if (!this._descriptions.isEmpty()) {
            description = (String)this._descriptions.get(0);
        }
        return description;
    }

    public List getDescriptions() {
        return this._descriptions;
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public boolean getMultiValueFlag() {
        return this._multiValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PreferenceDescriptor [");
        sb.append(" preference name [");
        if (this._prefName != null) {
            sb.append(this._prefName);
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" preference values [");
        Iterator iterator = this._prefValues.iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
        }
        sb.append("]");
        sb.append(" description [");
        if (!this._descriptions.isEmpty()) {
            sb.append((String)this._descriptions.get(0));
        } else {
            sb.append("NULL");
        }
        sb.append("]");
        sb.append(" read-only [");
        if (this._readOnly) {
            sb.append("fase");
        } else {
            sb.append("true");
        }
        sb.append("]");
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }
}

