/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletsDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityConstraintDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.UserAttributeDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class PortletAppDescriptor {
    public static final String PORTLET_APP = "portlet-app";
    public static final String PORTLET_APP_NAME = "portlet-app-name";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_NAME = "display-name";
    public static final String USER_ATTRIBUTE = "user-attribute";
    public static final String SECURITY_CONSTRAINT = "security-constraint";
    public static final String XML_LANG_ATTR = "lang";
    private List _descriptions = new ArrayList();
    private List _displayNames = new ArrayList();
    private PortletsDescriptor _portletsDescriptor;
    private SecurityConstraintDescriptor _secConstraintDescriptor;
    private List _userAttributeDescriptors = new ArrayList();
    private Logger _logger;
    private InputStream _extStream;
    private DeploymentExtensionDescriptor _depExtDescriptor;

    public PortletAppDescriptor(Logger logger, InputStream extStream) {
        this._logger = logger;
        this._extStream = extStream;
    }

    public void load(Element root, Namespace namespace, DeploymentDescriptorReader reader) throws DeploymentDescriptorException {
        List descriptionElements = root.getChildren(DESCRIPTION, namespace);
        Iterator i = descriptionElements.iterator();
        while (i.hasNext()) {
            Element descriptionElement = (Element)i.next();
            this._descriptions.add(descriptionElement.getTextTrim());
        }
        List displayNameElements = root.getChildren(DISPLAY_NAME, namespace);
        Iterator i2 = displayNameElements.iterator();
        while (i2.hasNext()) {
            Element displayNameElement = (Element)i2.next();
            this._displayNames.add(displayNameElement.getTextTrim());
        }
        if (this._extStream != null) {
            this._depExtDescriptor = reader.loadDeploymentExtensionDescriptor(this._extStream);
        }
        this._portletsDescriptor = new PortletsDescriptor(this._logger, this._depExtDescriptor);
        this._portletsDescriptor.load(root, namespace);
        List userAttrElements = root.getChildren(USER_ATTRIBUTE, namespace);
        for (int i3 = 0; i3 < userAttrElements.size(); ++i3) {
            Element userAttrElement = (Element)userAttrElements.get(i3);
            UserAttributeDescriptor userAttrDescriptor = new UserAttributeDescriptor(this._logger);
            userAttrDescriptor.load(userAttrElement, namespace);
            this._userAttributeDescriptors.add(userAttrDescriptor);
        }
        Element secConstraintElement = root.getChild(SECURITY_CONSTRAINT, namespace);
        if (secConstraintElement != null) {
            this._secConstraintDescriptor = new SecurityConstraintDescriptor(this._logger);
            this._secConstraintDescriptor.load(secConstraintElement, namespace);
        }
    }

    public PortletsDescriptor getPortletsDescriptor() {
        return this._portletsDescriptor;
    }

    public List getUserAttributeDescriptors() {
        return this._userAttributeDescriptors;
    }

    public String getPortletAppDescription() {
        String description = null;
        if (!this._descriptions.isEmpty()) {
            description = (String)this._descriptions.get(0);
        }
        return description;
    }

    public List getPortletAppDescriptions() {
        return this._descriptions;
    }

    public List getPortletAppDisplayNames() {
        return this._displayNames;
    }

    public SecurityConstraintDescriptor getSecurityConstraintDescriptor() {
        return this._secConstraintDescriptor;
    }

    public boolean isSavePreferencesAllowed() {
        boolean isAllowed = false;
        if (this._depExtDescriptor != null) {
            isAllowed = this._depExtDescriptor.isSavePreferencesAllowed();
        }
        return isAllowed;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletAppDescriptor [");
        sb.append(" portlet app descriptions [");
        Iterator iterator0 = this._descriptions.iterator();
        while (iterator0.hasNext()) {
            sb.append((String)iterator0.next());
        }
        sb.append(" ]");
        sb.append(" portlet app display names [");
        Iterator iterator2 = this._displayNames.iterator();
        while (iterator2.hasNext()) {
            sb.append((String)iterator2.next());
        }
        sb.append(" ]");
        sb.append(this.getPortletsDescriptor().toString());
        Iterator iterator1 = this._userAttributeDescriptors.iterator();
        while (iterator1.hasNext()) {
            UserAttributeDescriptor userAttrDescriptor = (UserAttributeDescriptor)iterator1.next();
            sb.append(userAttrDescriptor.toString());
            sb.append("\n");
        }
        sb.append("]");
        sb.append(" security constraint description [");
        if (this._secConstraintDescriptor != null) {
            sb.append(this._secConstraintDescriptor.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

