/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sun.portal.search.db.AutoCommitDb;
import com.sun.portal.search.db.BDBTxn;
import com.sun.portal.search.db.Datum;
import com.sun.portal.search.db.DbCursor;
import com.sun.portal.search.db.DbEnvInfo;
import com.sun.portal.search.db.DbUtil;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.rdm.RDMDeadlockException;
import com.sun.portal.search.rdm.RDMException;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.SearchConfig;
import com.sun.portal.search.util.String2Array;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PartitionedDb {
    public static final int MD5_BYTES = 16;
    public static final int MAXEXTEN = 64;
    public static final int DEFAULT_CACHESIZE = 0x1400000;
    public static final String ROOTDB = "root";
    public static final String EXTENT = "extent";
    public static final String INDEX = "index";
    public static final String TYPE = "type";
    public static final String UNIQ = "unique";
    public static final String DBASE = "database";
    public static final int INTTYPE = 1;
    public static final int TIMETYPE = 2;
    public static final int STRTYPE = 4;
    public static final int DEFAULT_CK_KB = 1000;
    public static final int DEFAULT_CK_MIN = 15;
    public static final int DEFAULT_LOGCLEAN_MIN = 2;
    int flags;
    String dbname;
    int extents;
    String[] extent;
    AutoCommitDb[] db;
    int ck_kb = 1000;
    int ck_min = 15;
    int logclean_min = 2;
    DbEnv dbenv;
    static Map dbEnvInfoMap = new HashMap();
    DbEnvInfo dbi = null;

    public String getName() {
        return this.dbname;
    }

    public int fetch(SToken sToken, Datum datum, Datum datum2, int n, RDMTransaction rDMTransaction) throws RDMException {
        return this.map(datum).fetch(datum, datum2, n, rDMTransaction);
    }

    public void store(SToken sToken, Datum datum, Datum datum2, int n, RDMTransaction rDMTransaction) throws RDMException {
        this.map(datum).store(datum, datum2, n, rDMTransaction);
        this.housekeep();
    }

    public void delete(SToken sToken, Datum datum, int n, RDMTransaction rDMTransaction) throws RDMException {
        this.map(datum).delete(datum, n, rDMTransaction);
        this.housekeep();
    }

    public int count(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        int n = 0;
        DbCursor dbCursor = null;
        Datum datum = new Datum();
        Datum datum2 = new Datum();
        dbCursor = new DbCursor(this, null, 0);
        while (dbCursor.get(datum, datum2, Db.DB_NEXT) == 0) {
            ++n;
        }
        dbCursor.close();
        return n;
    }

    AutoCommitDb map(Datum datum) {
        int n = DbUtil.hex2uint32(datum.get_data()) % this.extents;
        return this.db[n];
    }

    public static void create(SToken sToken, String string, String string2, String[] stringArray) throws RDMException {
        new PartitionedDb().create1(sToken, string, string2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void create1(SToken sToken, String string, String string2, String[] stringArray) throws RDMException {
        AutoCommitDb autoCommitDb;
        block19: {
            int n = 0;
            SOIF sOIF = null;
            AutoCommitDb autoCommitDb2 = null;
            autoCommitDb = null;
            boolean bl = false;
            try {
                try {
                    this.init(string, 0);
                    String string3 = SearchConfig.getValue("server-root");
                    if (string3 == null) {
                        string3 = string;
                    }
                    autoCommitDb2 = new AutoCommitDb();
                    autoCommitDb2.open(string + "/" + ROOTDB + "/rd.db", Db.DB_CREATE, 420, this.dbenv);
                    while (true) {
                        BDBTxn bDBTxn = null;
                        try {
                            bDBTxn = new BDBTxn(null, 0);
                            Datum datum = new Datum(ROOTDB);
                            datum = DbUtil.key_create(ROOTDB);
                            Datum datum2 = new Datum();
                            n = autoCommitDb2.fetch(datum, datum2, 0, bDBTxn);
                            if (n == -30990) {
                                CSLog.log(1, 1, "PartitionedDb: Creating root dabatase");
                                sOIF = new SOIF(DBASE, ROOTDB);
                                sOIF.insert(EXTENT, "db/root/rd.db");
                                datum2 = new Datum(sOIF.toByteArray("UTF-8"));
                                autoCommitDb2.store(datum, datum2, 0, bDBTxn);
                            }
                            sOIF = new SOIF(DBASE, string2);
                            for (int i = 0; i < stringArray.length; ++i) {
                                File file;
                                sOIF.insert(EXTENT, stringArray[i], i);
                                File file2 = new File(stringArray[i]);
                                if (!file2.isAbsolute()) {
                                    file2 = new File(string3 + File.separator + stringArray[i]);
                                }
                                if ((file = file2.getParentFile()) != null) {
                                    file.mkdirs();
                                }
                                autoCommitDb = new AutoCommitDb();
                                autoCommitDb.open(file2.getPath(), Db.DB_CREATE, 420, this.dbenv);
                                autoCommitDb.close();
                                autoCommitDb = null;
                            }
                            datum2.set_data(sOIF.toByteArray("UTF-8"));
                            datum = new Datum(string2);
                            datum = DbUtil.key_create(string2);
                            autoCommitDb2.store(datum, datum2, 0, bDBTxn);
                            ((RDMTransaction)bDBTxn).commit(0);
                            bDBTxn = null;
                            break;
                        }
                        catch (RDMDeadlockException rDMDeadlockException) {}
                        continue;
                        finally {
                            if (bDBTxn == null) continue;
                            ((RDMTransaction)bDBTxn).abort();
                            continue;
                        }
                        break;
                    }
                    autoCommitDb2.close();
                    autoCommitDb2 = null;
                }
                catch (Exception exception) {
                    CSLog.error(1, 1, "database creation failed: ", exception);
                    throw new RDMException(exception.getMessage());
                }
                Object var20_20 = null;
                if (autoCommitDb2 == null) break block19;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                if (autoCommitDb2 != null) {
                    autoCommitDb2.close();
                }
                if (autoCommitDb != null) {
                    autoCommitDb.close();
                }
                this.exit();
                throw throwable;
            }
            autoCommitDb2.close();
        }
        if (autoCommitDb != null) {
            autoCommitDb.close();
        }
        this.exit();
    }

    public static void drop(SToken sToken, String string, String string2) throws RDMException {
        new PartitionedDb().drop1(sToken, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void drop1(SToken sToken, String string, String string2) throws RDMException {
        block16: {
            AutoCommitDb autoCommitDb = null;
            BDBTxn bDBTxn = null;
            SOIF sOIF = null;
            Object var9_7 = null;
            try {
                try {
                    this.init(string, 0);
                    autoCommitDb = new AutoCommitDb();
                    autoCommitDb.open(string + "/" + ROOTDB + "/rd.db", Db.DB_CREATE, 420, this.dbenv);
                    block9: while (true) {
                        try {
                            bDBTxn = new BDBTxn(null, 0);
                            Datum datum = new Datum(string2);
                            datum = DbUtil.key_create(string2);
                            Datum datum2 = new Datum();
                            int n = autoCommitDb.fetch(datum, datum2, 0, bDBTxn);
                            if (n != 0) {
                                throw new RDMException("dbdelete: can't access database metadata: " + string2);
                            }
                            sOIF = new SOIF(datum2.get_data(), "UTF-8");
                            autoCommitDb.delete(datum, 0, bDBTxn);
                            int n2 = 0;
                            while (true) {
                                String string3;
                                if ((string3 = sOIF.getValue(EXTENT, n2)) == null) {
                                    ((RDMTransaction)bDBTxn).commit(0);
                                    bDBTxn = null;
                                    break block9;
                                }
                                CSLog.log(1, 1, "Deleting dabatase partition: " + string3 + "");
                                new File(string3).delete();
                                ++n2;
                            }
                        }
                        catch (RDMDeadlockException rDMDeadlockException) {}
                        continue;
                        finally {
                            if (bDBTxn == null) continue;
                            ((RDMTransaction)bDBTxn).abort();
                            continue;
                        }
                        break;
                    }
                    autoCommitDb.close();
                    autoCommitDb = null;
                    this.exit();
                }
                catch (Exception exception) {
                    RDMException rDMException;
                    if (!(exception instanceof RDMException)) {
                        rDMException = new RDMException(exception);
                    }
                    CSLog.error(1, 1, "database deletion failed", rDMException);
                    throw rDMException;
                }
                Object var19_17 = null;
                if (autoCommitDb == null) break block16;
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                if (autoCommitDb != null) {
                    autoCommitDb.close();
                }
                this.exit();
                throw throwable;
            }
            autoCommitDb.close();
        }
        this.exit();
    }

    public int purge(SToken sToken, RDMTransaction rDMTransaction) throws RDMException {
        int n = 0;
        try {
            for (int i = 0; i < this.extents; ++i) {
                DbTxn dbTxn = null;
                if (rDMTransaction != null) {
                    dbTxn = (DbTxn)rDMTransaction.getNativeTxn();
                }
                n += this.db[i].db.truncate(dbTxn, 0);
            }
        }
        catch (DbException dbException) {
            throw new RDMException((Exception)((Object)dbException));
        }
        return n;
    }

    public void optimize(SToken sToken) throws RDMException {
    }

    public void open(SToken sToken, String string, String string2, int n, int n2) throws RDMException {
        int n3 = 0;
        boolean bl = false;
        SOIF sOIF = null;
        AutoCommitDb autoCommitDb = null;
        try {
            String string3;
            int n4;
            String string4;
            this.init(string, 0);
            int n5 = Db.DB_THREAD | Db.DB_NOMMAP | ((n & 4) != 0 ? Db.DB_CREATE : ((n & 2) != 0 ? 0 : ((n & 1) != 0 ? Db.DB_RDONLY : Db.DB_RDONLY)));
            autoCommitDb = new AutoCommitDb();
            new File(string + "/root").mkdirs();
            autoCommitDb.open(string + "/" + ROOTDB + "/rd.db", n5, n2, this.dbenv);
            Datum datum = new Datum(string2);
            datum = DbUtil.key_create(string2);
            Datum datum2 = new Datum();
            n3 = autoCommitDb.fetch(datum, datum2, 0, null);
            if (n3 == -30990 && (n & 4) != 0) {
                try {
                    CSLog.log(1, 5, "Db not found, creating: " + string2);
                    String[] stringArray = null;
                    string4 = SearchConfig.getValue("database-partitions");
                    if (string4 != null) {
                        stringArray = String2Array.string2Array(string4, ',', true);
                    } else {
                        stringArray = new String[]{"db/" + string2 + "/rd.db"};
                        CSLog.log(1, 5, "Using default partition configuration: " + stringArray[0]);
                    }
                    this.create1(sToken, string, string2, stringArray);
                    n3 = autoCommitDb.fetch(datum, datum2, 0, null);
                }
                catch (Exception exception) {
                    CSLog.error(1, 1, "Failed to create db: " + string2, exception);
                    throw new RDMException("Failed to create db: " + string2);
                }
            } else if (n3 != 0) {
                throw new RDMException((Exception)((Object)new DbException("Failed to open db", n3)));
            }
            sOIF = new SOIF(datum2.get_data(), "UTF-8");
            this.db = new AutoCommitDb[64];
            this.extent = new String[64];
            for (n4 = 0; n4 < 64 && (string3 = sOIF.getValue(EXTENT, n4)) != null; ++n4) {
                string4 = string3;
                if (!new File(string4).isAbsolute()) {
                    string4 = new File(SearchConfig.getValue("server-root") + File.separator + string4).getAbsolutePath();
                }
                this.db[n4] = new AutoCommitDb();
                this.db[n4].open(string4, n5, n2, this.dbenv);
                this.extent[n4] = string3;
            }
            this.extents = n4;
        }
        catch (Exception exception) {
            RDMException rDMException;
            if (!(exception instanceof RDMException)) {
                rDMException = new RDMException(exception.getMessage());
            }
            throw (RDMException)rDMException;
        }
        finally {
            if (autoCommitDb != null) {
                autoCommitDb.close();
            }
        }
    }

    public void partopen(String string, String string2, int n, int n2) throws Exception {
        int n3 = Db.DB_THREAD | Db.DB_NOMMAP | ((n & 4) != 0 ? Db.DB_CREATE : ((n & 2) != 0 ? 0 : ((n & 1) != 0 ? Db.DB_RDONLY : Db.DB_RDONLY)));
        this.extents = 1;
        if (!new File(string2).isAbsolute()) {
            string2 = new File(string2).getAbsolutePath();
        }
        if (string == null) {
            string = string2;
        }
        this.init(string, 0);
        this.db = new AutoCommitDb[64];
        this.db[0] = new AutoCommitDb();
        this.db[0].open(string2, n3, n2, this.dbenv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SToken sToken) throws RDMException {
        try {
            for (int i = 0; i < this.extents; ++i) {
                if (this.db[i] == null) continue;
                this.db[i].close();
            }
            this.housekeep();
        }
        finally {
            this.exit();
        }
    }

    public int check_recover(String string, int n) throws RDMException {
        return 0;
    }

    public void recover(String string, boolean bl) throws RDMException {
        this.init(string, (bl ? Db.DB_RECOVER_FATAL : Db.DB_RECOVER) | Db.DB_PRIVATE);
        this.exit();
    }

    synchronized void init(String string, int n) throws RDMException {
        String string2 = null;
        try {
            string2 = new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            throw new RDMException("Can't access " + string);
        }
        this.dbi = (DbEnvInfo)dbEnvInfoMap.get(string2);
        if (this.dbi == null) {
            this.dbi = new DbEnvInfo();
            this.dbi.dbenv = null;
            this.dbi.dbenv_opened = 0;
            this.dbi.dbhome = string2;
            dbEnvInfoMap.put(string2, this.dbi);
        }
        if (this.dbi.dbenv_opened > 0) {
            ++this.dbi.dbenv_opened;
            this.dbenv = this.dbi.dbenv;
            return;
        }
        this.check_recover(string, 0);
        int n2 = Db.DB_INIT_LOG | Db.DB_INIT_LOCK | Db.DB_INIT_MPOOL | Db.DB_INIT_TXN | Db.DB_CREATE | Db.DB_THREAD | Db.DB_USE_ENVIRON | n;
        this.dbi.dbenv = this.dbenv = new DbEnv(0);
        int n3 = 0x1400000;
        String string3 = SearchConfig.getValue("database-cache-size-kb");
        if (string3 != null) {
            try {
                n3 = Integer.parseInt(string3) * 1024;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.dbenv.set_cachesize(0, n3, 0);
            this.dbenv.set_lk_detect(Db.DB_LOCK_YOUNGEST);
            this.dbenv.set_flags(Db.DB_TXN_NOSYNC, true);
            try {
                this.dbenv.open(string, n2, 420);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RDMException(fileNotFoundException.getMessage());
            }
            catch (DbException dbException) {
                CSLog.error(1, 1, "dbenv.open() failed", dbException);
                throw dbException;
            }
            BDBTxn.init(this.dbi.dbenv);
            ++this.dbi.dbenv_opened;
        }
        catch (DbException dbException) {
            throw new RDMException((Exception)((Object)dbException));
        }
    }

    synchronized void exit() throws RDMException {
        if (this.dbi.dbenv_opened <= 0) {
            return;
        }
        if (--this.dbi.dbenv_opened == 0) {
            try {
                this.dbi.dbenv.close(0);
                this.dbi.dbenv = null;
                dbEnvInfoMap.remove(this.dbi.dbhome);
            }
            catch (DbException dbException) {
                CSLog.error(1, 1, "dbenv.close() failed", dbException);
                throw new RDMException((Exception)((Object)dbException));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int repartition(SToken sToken, String string, String string2, String[] stringArray) throws RDMException {
        Arrays.sort(stringArray);
        Object[] objectArray = this.extent;
        Arrays.sort(objectArray, 0, this.extents - 1);
        int n = 50;
        PartitionedDb partitionedDb = new PartitionedDb();
        partitionedDb.create1(sToken, string, string2, stringArray);
        partitionedDb.open(sToken, string, string2, 2, 420);
        int n2 = 0;
        BDBTxn bDBTxn = null;
        Dbc dbc = null;
        Datum datum = new Datum();
        Datum datum2 = new Datum();
        int n3 = 0;
        while (true) {
            if (n3 >= this.extents) {
                partitionedDb.close(sToken);
                return n2;
            }
            AutoCommitDb autoCommitDb = this.db[n3];
            datum.set_data("");
            datum2.set_data("");
            boolean bl = false;
            while (!bl) {
                block21: {
                    Object var21_22;
                    Datum datum3 = new Datum(datum.get_data());
                    Datum datum4 = new Datum(datum2.get_data());
                    try {
                        while (true) {
                            try {
                                bDBTxn = new BDBTxn(null, 0);
                                dbc = autoCommitDb.db.cursor((DbTxn)((RDMTransaction)bDBTxn).getNativeTxn(), 0);
                                datum.set_data(datum3.get_data());
                                datum2.set_data(datum4.get_data());
                                dbc.get((Dbt)datum, (Dbt)datum2, Db.DB_SET_RANGE);
                                int n4 = 0;
                                int n5 = 0;
                                do {
                                    if (autoCommitDb.location.equals(partitionedDb.map((Datum)datum).location)) continue;
                                    partitionedDb.map(datum).store(datum, datum2, 0, bDBTxn);
                                    autoCommitDb.delete(datum, 0, bDBTxn);
                                    ++n4;
                                    ++n2;
                                } while (n4 < n && (n5 = dbc.get((Dbt)datum, (Dbt)datum2, Db.DB_NEXT)) == 0);
                                if (n5 == -30990) {
                                    bl = true;
                                } else if (n5 != 0) {
                                    throw new RDMException("internal error: cursor get next returned " + n5);
                                }
                                dbc.close();
                                dbc = null;
                                ((RDMTransaction)bDBTxn).commit(0);
                                bDBTxn = null;
                            }
                            catch (DbDeadlockException dbDeadlockException) {
                                var21_22 = null;
                                if (dbc != null) {
                                    try {
                                        dbc.close();
                                    }
                                    catch (DbException dbException) {
                                        throw new RDMException((Exception)((Object)dbException));
                                    }
                                }
                                if (bDBTxn == null) continue;
                                ((RDMTransaction)bDBTxn).abort();
                                continue;
                            }
                            catch (DbException dbException) {
                                throw new RDMException((Exception)((Object)dbException));
                            }
                            break;
                        }
                        var21_22 = null;
                        if (dbc == null) break block21;
                    }
                    catch (Throwable throwable) {
                        var21_22 = null;
                        if (dbc != null) {
                            try {}
                            catch (DbException dbException) {
                                throw new RDMException((Exception)((Object)dbException));
                            }
                            dbc.close();
                        }
                        if (bDBTxn != null) {
                            ((RDMTransaction)bDBTxn).abort();
                        }
                        throw throwable;
                    }
                    try {}
                    catch (DbException dbException) {
                        throw new RDMException((Exception)((Object)dbException));
                    }
                    dbc.close();
                }
                if (bDBTxn == null) continue;
                ((RDMTransaction)bDBTxn).abort();
            }
            ++n3;
        }
    }

    void housekeep() throws RDMException {
        long l;
        boolean bl;
        if (this.ck_kb != -1 || this.ck_min != -1) {
            int n = this.ck_kb;
            int n2 = this.ck_min;
            while (true) {
                try {
                    this.dbenv.txn_checkpoint(n, n2, 0);
                }
                catch (DbException dbException) {
                    if (dbException.get_errno() == -30998) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        n = 0;
                        n2 = 0;
                        continue;
                    }
                    CSLog.error(1, 1, "txn_checkpoint() failed", dbException);
                    throw new RDMException((Exception)((Object)dbException));
                }
                break;
            }
        }
        String[] stringArray = null;
        long l2 = new Date().getTime();
        long l3 = l2 - this.dbi.last_log;
        boolean bl2 = bl = l3 >= (long)(this.logclean_min * 60 * 1000);
        if (this.logclean_min != -1 && (l = new Date().getTime()) - this.dbi.last_log >= (long)(this.logclean_min * 60 * 1000)) {
            this.dbi.last_log = l;
            try {
                stringArray = this.dbenv.log_archive(Db.DB_ARCH_ABS);
            }
            catch (DbException dbException) {
                CSLog.error(1, 1, "log_archive failed", dbException);
                throw new RDMException((Exception)((Object)dbException));
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    new File(stringArray[i]).delete();
                }
            }
        }
    }
}

