/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class DateTimeInfo {
    private static final Map _store = new HashMap();
    private static final String[] DAYS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static long _lastCalculation = 0L;
    private static String[] YEARS;
    private static final String[] HOURS_24;
    private static final String[] HOURS_12;
    private static final String[] MINUTES;
    private static final String[] SECONDS;
    private static final String BUNDLE_NAME = "java.text.resources.LocaleElements";
    private Locale _locale;
    private int[] _dateOrder;
    private String[] _abbrMonths;
    private String[] _months;
    private String[] _days;
    private boolean _24Hours;
    private String[] _hours;
    private String[] _minutes;
    private String[] _seconds;
    private String[] _amPmMarkers;
    private int[] _timeOrder;
    private char _dateElementSeparator;

    public static DateTimeInfo getInstance() {
        return DateTimeInfo.getInstance(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTimeInfo getInstance(Locale locale) {
        DateTimeInfo dti = (DateTimeInfo)_store.get(locale);
        if (dti == null) {
            Map map = _store;
            synchronized (map) {
                dti = (DateTimeInfo)_store.get(locale);
                if (dti == null) {
                    dti = new DateTimeInfo(locale);
                    _store.put(locale, dti);
                }
            }
        }
        return dti;
    }

    private DateTimeInfo(Locale locale) {
        this._locale = locale;
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, this._locale);
        this._dateOrder = this.obtainDateOrder(bundle);
        this._abbrMonths = this.obtainAbbrMonths(bundle);
        this._months = this.obtainMonths(bundle);
        this._days = DAYS;
        this._24Hours = this.obtainIs24Hours(bundle);
        this._hours = this._24Hours ? HOURS_24 : HOURS_12;
        this._minutes = MINUTES;
        this._seconds = SECONDS;
        this._amPmMarkers = this.obtainAmPmMarkers(bundle);
        this._timeOrder = this.obtainTimeOrder();
        this._dateElementSeparator = this.obtainDateElementSeparator(bundle);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int[] getDateOrder() {
        return this._dateOrder;
    }

    public String[] getAbbrMonths() {
        return this._abbrMonths;
    }

    public String[] getMonths() {
        return this._months;
    }

    public String[] getDays() {
        return this._days;
    }

    public String[] getYears() {
        if (System.currentTimeMillis() - _lastCalculation > 86400000L) {
            this.recalculateYears();
        }
        return YEARS;
    }

    public String[] getYears(int begin, int howMany) {
        String[] years = new String[howMany];
        for (int i = 0; i < years.length; ++i) {
            years[i] = Integer.toString(begin++);
        }
        return years;
    }

    public int[] getTimeOrder() {
        return this._timeOrder;
    }

    public char getDateElementSeparator() {
        return this._dateElementSeparator;
    }

    public boolean is24Hours() {
        return this._24Hours;
    }

    public String[] getHours() {
        return this._hours;
    }

    public String[] getMinutes() {
        return this._minutes;
    }

    public String[] getSeconds() {
        return this._seconds;
    }

    public String[] getAmPmMarkers() {
        return this._amPmMarkers;
    }

    public int toIndexValue(int section, int value) {
        switch (section) {
            case 5: 
            case 10: {
                --value;
                break;
            }
        }
        return value;
    }

    public int fromStringValue(int section, String str) {
        int value = -1;
        switch (section) {
            case 1: {
                value = Integer.parseInt(str);
                break;
            }
            case 2: {
                value = Integer.parseInt(str) - 1;
                break;
            }
            case 5: {
                value = Integer.parseInt(str);
                break;
            }
            case 10: {
                value = Integer.parseInt(str);
                break;
            }
            case 11: {
                value = Integer.parseInt(str);
                break;
            }
            case 12: {
                value = Integer.parseInt(str);
                break;
            }
            case 13: {
                value = Integer.parseInt(str);
                break;
            }
            case 9: {
                for (int i = 0; value == -1 && i < this._amPmMarkers.length; ++i) {
                    if (!this._amPmMarkers[i].equalsIgnoreCase(str)) continue;
                    value = i;
                }
                break;
            }
        }
        return value;
    }

    private synchronized void recalculateYears() {
        _lastCalculation = System.currentTimeMillis();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        YEARS = new String[10];
        for (int i = 0; i < YEARS.length; ++i) {
            DateTimeInfo.YEARS[i] = Integer.toString(year++);
        }
    }

    private int[] obtainDateOrder(ResourceBundle bundle) {
        String[] patterns = bundle.getStringArray("DateTimePatterns");
        char[] datePattern = patterns[7].toCharArray();
        int[] localeOrder = new int[4];
        for (int i = 0; i < localeOrder.length; ++i) {
            localeOrder[i] = -1;
        }
        int pos = 0;
        block6: for (int i = 0; pos < localeOrder.length && i < datePattern.length; ++i) {
            switch (datePattern[i]) {
                case 'M': {
                    if (pos != 0 && localeOrder[pos - 1] == 2) continue block6;
                    localeOrder[pos++] = 2;
                    continue block6;
                }
                case 'd': {
                    if (pos != 0 && localeOrder[pos - 1] == 5) continue block6;
                    localeOrder[pos++] = 5;
                    continue block6;
                }
                case 'y': {
                    if (pos != 0 && localeOrder[pos - 1] == 1) continue block6;
                    localeOrder[pos++] = 1;
                    continue block6;
                }
            }
        }
        return localeOrder;
    }

    private char obtainDateElementSeparator(ResourceBundle bundle) {
        char separator = '/';
        String[] patterns = bundle.getStringArray("DateTimePatterns");
        char[] datePattern = patterns[7].toCharArray();
        boolean found = false;
        for (int i = 0; i < datePattern.length && !found; ++i) {
            char c = datePattern[i];
            if (c == 'd' || c == 'M' || c == 'y') continue;
            separator = c;
            found = true;
        }
        return separator;
    }

    private String[] obtainAbbrMonths(ResourceBundle bundle) {
        String[] months = bundle.getStringArray("MonthAbbreviations");
        String[] realMonths = new String[12];
        System.arraycopy(months, 0, realMonths, 0, realMonths.length);
        return realMonths;
    }

    private String[] obtainMonths(ResourceBundle bundle) {
        String[] months = bundle.getStringArray("MonthNames");
        String[] realMonths = new String[12];
        System.arraycopy(months, 0, realMonths, 0, realMonths.length);
        return realMonths;
    }

    private boolean obtainIs24Hours(ResourceBundle bundle) {
        String hourPattern = bundle.getStringArray("DateTimePatterns")[2];
        return hourPattern.indexOf("H") > -1;
    }

    private String[] obtainAmPmMarkers(ResourceBundle bundle) {
        return bundle.getStringArray("AmPmMarkers");
    }

    private int[] obtainTimeOrder() {
        int[] order = this.is24Hours() ? new int[]{11, 12, 13} : new int[]{10, 12, 13, 9};
        return order;
    }

    static {
        HOURS_24 = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
        HOURS_12 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        MINUTES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
        SECONDS = MINUTES;
    }
}

